﻿/*
Run this script to update the MET/CONNECT database from 3.3.0 to 3.4.0

You are recommended to back up your database before running this script

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '2.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 2.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.0.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.0.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.1.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.1.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.2.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.2.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

-- set database compatibility level to SQL Server 2012
DECLARE @comp NVARCHAR(max);
SET @comp = N'ALTER DATABASE [' + (SELECT DB_NAME()) + ']
SET COMPATIBILITY_LEVEL = 110 '
EXEC sp_executesql @comp
GO

-- No need to process if we have a 3.4.0 version record
IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE nVersionUID = '5E750356-7DBF-47CE-BF02-1FE831F73383' )
BEGIN
	BEGIN TRANSACTION

	-- get the current collation and switch it to case-sensitive
	DECLARE @sql NVARCHAR(max);
	DECLARE @coll_cs NVARCHAR(100);
	SELECT @coll_cs = collation_name FROM sys.databases WHERE name = (SELECT DB_NAME());
	SELECT @coll_cs = REPLACE(@coll_cs, N'CI', N'CS');


	-->>MTM-3218<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[AuditLink] WHERE [nAuditLinkUID] = '14A9CE33-6752-40CF-A49A-66FE1F84C18C')
	BEGIN
		PRINT 'Adding audit link'

		INSERT INTO [dbo].[AuditLink] ([nAuditLinkUID],[cColumnName],[cTableName],[cReturnValue],[mCustomSelect],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('14A9CE33-6752-40CF-A49A-66FE1F84C18C','nSecurityGroupUID','SecurityGroups','cGroupName',NULL,-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201126 01:29:28.050', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201126 01:29:28.050', '20201126 01:29:28.050', NULL, NULL)

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '9271B501-91F1-473B-A93D-768240659091')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('9271B501-91F1-473B-A93D-768240659091', N'SecurityGroupMembers', N'nSecurityGroupUID', N'Label', N'Security Group UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201126 01:29:28.050', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201126 01:29:28.050', '20201126 01:29:28.050', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '1C58E8D0-2E81-4F03-9F6D-C2838FD26DE0')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('1C58E8D0-2E81-4F03-9F6D-C2838FD26DE0', N'SecurityGroupMembers', N'nSecurityGroupMemberUID', N'Label', N'Security Group Member UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201126 01:29:28.050', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201126 01:29:28.050', '20201126 01:29:28.050', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '035CC2B5-8BDD-4FAD-ACFE-D0F4617B233A')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('035CC2B5-8BDD-4FAD-ACFE-D0F4617B233A', N'SecurityGroupMembers', N'nUserUID', N'Label', N'User UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201126 01:29:28.050', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201126 01:29:28.050', '20201126 01:29:28.050', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'AAFA9019-8B8E-4EB8-A16C-77131B009EBD' )
	BEGIN
		PRINT 'Adding translation entry: AAFA9019-8B8E-4EB8-A16C-77131B009EBD'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('AAFA9019-8B8E-4EB8-A16C-77131B009EBD',3223,N'EN',N'Security Group UID',N'Security Group UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D08310CC-C47F-4521-A6CC-1BD930E8A31A' )
	BEGIN
		PRINT 'Adding translation entry: D08310CC-C47F-4521-A6CC-1BD930E8A31A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D08310CC-C47F-4521-A6CC-1BD930E8A31A',3223,N'DE',N'Security Group UID',N'#DE# Security Group UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'AF2EE2C7-EE37-48DC-AA66-2146ADDF7E40' )
	BEGIN
		PRINT 'Adding translation entry: AF2EE2C7-EE37-48DC-AA66-2146ADDF7E40'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('AF2EE2C7-EE37-48DC-AA66-2146ADDF7E40',3223,N'RU',N'Security Group UID',N'#RU# Security Group UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '76DFB676-0142-4BFA-9879-8A6B5382380D' )
	BEGIN
		PRINT 'Adding translation entry: 76DFB676-0142-4BFA-9879-8A6B5382380D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('76DFB676-0142-4BFA-9879-8A6B5382380D',3223,N'PT',N'Security Group UID',N'#PT# Security Group UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D8AB6B33-12D5-4937-B21C-CEB0801FDBCB' )
	BEGIN
		PRINT 'Adding translation entry: D8AB6B33-12D5-4937-B21C-CEB0801FDBCB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D8AB6B33-12D5-4937-B21C-CEB0801FDBCB',3223,N'ZH',N'Security Group UID',N'#ZH# Security Group UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '17A1CEDB-35FC-4F8E-8249-24498C3670D9' )
	BEGIN
		PRINT 'Adding translation entry: 17A1CEDB-35FC-4F8E-8249-24498C3670D9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('17A1CEDB-35FC-4F8E-8249-24498C3670D9',3223,N'JA',N'Security Group UID',N'#JA# Security Group UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D982CE63-419D-434A-83EF-DF6B27FD22CB' )
	BEGIN
		PRINT 'Adding translation entry: D982CE63-419D-434A-83EF-DF6B27FD22CB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D982CE63-419D-434A-83EF-DF6B27FD22CB',3223,N'FR',N'Security Group UID',N'#FR# Security Group UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8F3CE825-D734-4841-A15A-8BE54B0CD01C' )
	BEGIN
		PRINT 'Adding translation entry: 8F3CE825-D734-4841-A15A-8BE54B0CD01C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8F3CE825-D734-4841-A15A-8BE54B0CD01C',3223,N'ES',N'Security Group UID',N'#ES# Security Group UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DEF68726-550A-408E-AD8D-F2E0CAAC689B' )
	BEGIN
		PRINT 'Adding translation entry: DEF68726-550A-408E-AD8D-F2E0CAAC689B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DEF68726-550A-408E-AD8D-F2E0CAAC689B',3223,N'IT',N'Security Group UID',N'#IT# Security Group UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '846F851C-9300-4245-8E6C-1C59FB7C9FE1' )
	BEGIN
		PRINT 'Adding translation entry: 846F851C-9300-4245-8E6C-1C59FB7C9FE1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('846F851C-9300-4245-8E6C-1C59FB7C9FE1',3224,N'EN',N'Security Group Member UID',N'Security Group Member UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DAA042DE-EA85-48ED-BF39-45EB0F92DB26' )
	BEGIN
		PRINT 'Adding translation entry: DAA042DE-EA85-48ED-BF39-45EB0F92DB26'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DAA042DE-EA85-48ED-BF39-45EB0F92DB26',3224,N'DE',N'Security Group Member UID',N'#DE# Security Group Member UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '004FC101-7E93-4713-8403-26F63CB5D30D' )
	BEGIN
		PRINT 'Adding translation entry: 004FC101-7E93-4713-8403-26F63CB5D30D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('004FC101-7E93-4713-8403-26F63CB5D30D',3224,N'RU',N'Security Group Member UID',N'#RU# Security Group Member UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '339D8805-51DA-4192-A734-8EBCD0E1BCFC' )
	BEGIN
		PRINT 'Adding translation entry: 339D8805-51DA-4192-A734-8EBCD0E1BCFC'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('339D8805-51DA-4192-A734-8EBCD0E1BCFC',3224,N'PT',N'Security Group Member UID',N'#PT# Security Group Member UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A791AF76-93F1-41F2-87BF-BD8A19F3E533' )
	BEGIN
		PRINT 'Adding translation entry: A791AF76-93F1-41F2-87BF-BD8A19F3E533'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A791AF76-93F1-41F2-87BF-BD8A19F3E533',3224,N'ZH',N'Security Group Member UID',N'#ZH# Security Group Member UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6102C09F-7ED2-4811-8A5F-6D460AF35B81' )
	BEGIN
		PRINT 'Adding translation entry: 6102C09F-7ED2-4811-8A5F-6D460AF35B81'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6102C09F-7ED2-4811-8A5F-6D460AF35B81',3224,N'JA',N'Security Group Member UID',N'#JA# Security Group Member UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8050F596-40B9-4CE7-8A12-E89E7D4E4135' )
	BEGIN
		PRINT 'Adding translation entry: 8050F596-40B9-4CE7-8A12-E89E7D4E4135'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8050F596-40B9-4CE7-8A12-E89E7D4E4135',3224,N'FR',N'Security Group Member UID',N'#FR# Security Group Member UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5E25F1BB-4749-4A5E-8476-25B24AF691B3' )
	BEGIN
		PRINT 'Adding translation entry: 5E25F1BB-4749-4A5E-8476-25B24AF691B3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5E25F1BB-4749-4A5E-8476-25B24AF691B3',3224,N'ES',N'Security Group Member UID',N'#ES# Security Group Member UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C6B1E86C-B62F-4A76-A2C4-4F9C5270A720' )
	BEGIN
		PRINT 'Adding translation entry: C6B1E86C-B62F-4A76-A2C4-4F9C5270A720'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C6B1E86C-B62F-4A76-A2C4-4F9C5270A720',3224,N'IT',N'Security Group Member UID',N'#IT# Security Group Member UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201126 01:45:25','20201126 01:45:25',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-3227<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'A3F3A983-465A-46FA-9CD3-15A674121398')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('A3F3A983-465A-46FA-9CD3-15A674121398', N'FacilityUserLink', N'nFacilityUserLinkUID', N'Label', N'Facility User Link UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', '20201130 17:43:43.050', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '1906F339-A015-4970-8180-15CD0A983F66')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('1906F339-A015-4970-8180-15CD0A983F66', N'FacilityUserLink', N'nFacilityUID', N'Label', N'Facility UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', '20201130 17:43:43.050', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'AB53BC4E-737A-421F-8B0C-B0F66717508C')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('AB53BC4E-737A-421F-8B0C-B0F66717508C', N'FacilityUserLink', N'nUserUID', N'Label', N'User UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', '20201130 17:43:43.050', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '648D7A35-4F88-4D1F-93DB-15BA941322B8' )
	BEGIN
		PRINT 'Adding translation entry: 648D7A35-4F88-4D1F-93DB-15BA941322B8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('648D7A35-4F88-4D1F-93DB-15BA941322B8',3225,N'EN',N'Facility User Link UID',N'Facility User Link UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','20201130 20:00:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F59122B5-886B-4FCC-BB65-85EAD871E5CA' )
	BEGIN
		PRINT 'Adding translation entry: F59122B5-886B-4FCC-BB65-85EAD871E5CA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F59122B5-886B-4FCC-BB65-85EAD871E5CA',3225,N'DE',N'Facility User Link UID',N'#DE# Facility User Link UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','20201130 20:00:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C0D91A72-9200-4526-AA23-8D96054CB4E2' )
	BEGIN
		PRINT 'Adding translation entry: C0D91A72-9200-4526-AA23-8D96054CB4E2'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C0D91A72-9200-4526-AA23-8D96054CB4E2',3225,N'RU',N'Facility User Link UID',N'#RU# Facility User Link UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','20201130 20:00:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6AA98886-62D2-4165-8B1B-B176A9CE4024' )
	BEGIN
		PRINT 'Adding translation entry: 6AA98886-62D2-4165-8B1B-B176A9CE4024'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6AA98886-62D2-4165-8B1B-B176A9CE4024',3225,N'PT',N'Facility User Link UID',N'#PT# Facility User Link UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','20201130 20:00:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '54CE8649-BEAB-4AC8-AFB2-6FE3D5569D36' )
	BEGIN
		PRINT 'Adding translation entry: 54CE8649-BEAB-4AC8-AFB2-6FE3D5569D36'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('54CE8649-BEAB-4AC8-AFB2-6FE3D5569D36',3225,N'ZH',N'Facility User Link UID',N'#ZH# Facility User Link UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','20201130 20:00:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'ADE6C6C8-4AD9-4A95-A3EC-79BD400B5BB8' )
	BEGIN
		PRINT 'Adding translation entry: ADE6C6C8-4AD9-4A95-A3EC-79BD400B5BB8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('ADE6C6C8-4AD9-4A95-A3EC-79BD400B5BB8',3225,N'JA',N'Facility User Link UID',N'#JA# Facility User Link UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','20201130 20:00:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8D5E7F6B-EDA5-4BC8-BF3B-30F99293D626' )
	BEGIN
		PRINT 'Adding translation entry: 8D5E7F6B-EDA5-4BC8-BF3B-30F99293D626'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8D5E7F6B-EDA5-4BC8-BF3B-30F99293D626',3225,N'FR',N'Facility User Link UID',N'#FR# Facility User Link UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','20201130 20:00:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B8148910-C40D-49D3-9807-1A684034BA20' )
	BEGIN
		PRINT 'Adding translation entry: B8148910-C40D-49D3-9807-1A684034BA20'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B8148910-C40D-49D3-9807-1A684034BA20',3225,N'ES',N'Facility User Link UID',N'#ES# Facility User Link UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','20201130 20:00:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5751699D-1E59-459E-BF32-D8611A5689D2' )
	BEGIN
		PRINT 'Adding translation entry: 5751699D-1E59-459E-BF32-D8611A5689D2'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5751699D-1E59-459E-BF32-D8611A5689D2',3225,N'IT',N'Facility User Link UID',N'#IT# Facility User Link UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 20:00:34','20201130 20:00:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-3236<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '8A0CBCCD-4EDE-4DE4-9662-29FDFA8B9351')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('8A0CBCCD-4EDE-4DE4-9662-29FDFA8B9351', N'CallSheetFiles', N'nCallSheetFileUID', N'Label', N'Work Order File UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', '20201130 17:43:43.050', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '09FF7E2E-777A-4F7E-8AFF-10B4359F20DB')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('09FF7E2E-777A-4F7E-8AFF-10B4359F20DB', N'CallSheetFiles', N'nFileUID', N'Label', N'File UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', '20201130 17:43:43.050', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '5197BB29-4EDE-45C4-BD69-5025A0536239')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('5197BB29-4EDE-45C4-BD69-5025A0536239', N'CallSheetFiles', N'nCallSheetUID', N'Label', N'Work Order UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201130 17:43:43.050', '20201130 17:43:43.050', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '32F00CD7-9025-4CBE-A7A3-A7BC5C135209' )
	BEGIN
		PRINT 'Adding translation entry: 32F00CD7-9025-4CBE-A7A3-A7BC5C135209'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('32F00CD7-9025-4CBE-A7A3-A7BC5C135209',3226,N'EN',N'Work Order File UID',N'Work Order File UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','20201130 22:12:37',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'AF4E5B42-5B36-44B5-B53F-6466E9017518' )
	BEGIN
		PRINT 'Adding translation entry: AF4E5B42-5B36-44B5-B53F-6466E9017518'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('AF4E5B42-5B36-44B5-B53F-6466E9017518',3226,N'DE',N'Work Order File UID',N'#DE# Work Order File UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','20201130 22:12:37',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9B0BD903-649F-46E4-8A15-605F0FDEDFFE' )
	BEGIN
		PRINT 'Adding translation entry: 9B0BD903-649F-46E4-8A15-605F0FDEDFFE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9B0BD903-649F-46E4-8A15-605F0FDEDFFE',3226,N'RU',N'Work Order File UID',N'#RU# Work Order File UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','20201130 22:12:37',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7D3E4DEB-0AFC-4254-AE84-6FA83A7C0818' )
	BEGIN
		PRINT 'Adding translation entry: 7D3E4DEB-0AFC-4254-AE84-6FA83A7C0818'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7D3E4DEB-0AFC-4254-AE84-6FA83A7C0818',3226,N'PT',N'Work Order File UID',N'#PT# Work Order File UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','20201130 22:12:37',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B85E3EF3-23DF-40E3-B49E-CE23A21A631D' )
	BEGIN
		PRINT 'Adding translation entry: B85E3EF3-23DF-40E3-B49E-CE23A21A631D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B85E3EF3-23DF-40E3-B49E-CE23A21A631D',3226,N'ZH',N'Work Order File UID',N'#ZH# Work Order File UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','20201130 22:12:37',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2AAFFEF2-37FE-4C26-9A0F-E77E77CC0097' )
	BEGIN
		PRINT 'Adding translation entry: 2AAFFEF2-37FE-4C26-9A0F-E77E77CC0097'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2AAFFEF2-37FE-4C26-9A0F-E77E77CC0097',3226,N'JA',N'Work Order File UID',N'#JA# Work Order File UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','20201130 22:12:37',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6F6019FC-FF0D-4EDB-98D6-4215BA96FD75' )
	BEGIN
		PRINT 'Adding translation entry: 6F6019FC-FF0D-4EDB-98D6-4215BA96FD75'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6F6019FC-FF0D-4EDB-98D6-4215BA96FD75',3226,N'FR',N'Work Order File UID',N'#FR# Work Order File UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','20201130 22:12:37',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '71D673B0-8663-4C4C-B05C-4C11C230FB69' )
	BEGIN
		PRINT 'Adding translation entry: 71D673B0-8663-4C4C-B05C-4C11C230FB69'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('71D673B0-8663-4C4C-B05C-4C11C230FB69',3226,N'ES',N'Work Order File UID',N'#ES# Work Order File UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','20201130 22:12:37',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '73D2C5EF-3177-4592-BE1E-14558F58523D' )
	BEGIN
		PRINT 'Adding translation entry: 73D2C5EF-3177-4592-BE1E-14558F58523D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('73D2C5EF-3177-4592-BE1E-14558F58523D',3226,N'IT',N'Work Order File UID',N'#IT# Work Order File UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201130 22:12:37','20201130 22:12:37',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-1390<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '473E1B46-C080-499A-B11F-8E1360749D34' )
	BEGIN
		PRINT 'Adding translation entry: 473E1B46-C080-499A-B11F-8E1360749D34'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('473E1B46-C080-499A-B11F-8E1360749D34',3227,N'EN',N'INSTRUCTIONS',N'Instructions',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','20201202 22:26:57',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '541B96E6-7A59-445C-8EDF-FC79F8CE3A9F' )
	BEGIN
		PRINT 'Adding translation entry: 541B96E6-7A59-445C-8EDF-FC79F8CE3A9F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('541B96E6-7A59-445C-8EDF-FC79F8CE3A9F',3227,N'DE',N'INSTRUCTIONS',N'#DE# Instructions',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','20201202 22:26:57',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E02F2065-919A-488A-A3D6-4313A8E9839D' )
	BEGIN
		PRINT 'Adding translation entry: E02F2065-919A-488A-A3D6-4313A8E9839D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E02F2065-919A-488A-A3D6-4313A8E9839D',3227,N'RU',N'INSTRUCTIONS',N'#RU# Instructions',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','20201202 22:26:57',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '23E8EE40-C237-4015-B310-225154BBEFFA' )
	BEGIN
		PRINT 'Adding translation entry: 23E8EE40-C237-4015-B310-225154BBEFFA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('23E8EE40-C237-4015-B310-225154BBEFFA',3227,N'PT',N'INSTRUCTIONS',N'#PT# Instructions',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','20201202 22:26:57',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8EE772A3-4A25-46CF-8AB2-DDCC54CC8D20' )
	BEGIN
		PRINT 'Adding translation entry: 8EE772A3-4A25-46CF-8AB2-DDCC54CC8D20'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8EE772A3-4A25-46CF-8AB2-DDCC54CC8D20',3227,N'ZH',N'INSTRUCTIONS',N'#ZH# Instructions',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','20201202 22:26:57',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'FDDA4F34-7785-4EB1-B3F6-52995B775F0D' )
	BEGIN
		PRINT 'Adding translation entry: FDDA4F34-7785-4EB1-B3F6-52995B775F0D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('FDDA4F34-7785-4EB1-B3F6-52995B775F0D',3227,N'JA',N'INSTRUCTIONS',N'#JA# Instructions',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','20201202 22:26:57',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '10CB9BFB-F70E-4D20-8C11-E602FBC7BA88' )
	BEGIN
		PRINT 'Adding translation entry: 10CB9BFB-F70E-4D20-8C11-E602FBC7BA88'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('10CB9BFB-F70E-4D20-8C11-E602FBC7BA88',3227,N'FR',N'INSTRUCTIONS',N'#FR# Instructions',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','20201202 22:26:57',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'BC0A83EA-1560-4E5D-87FC-E14866FE9F0E' )
	BEGIN
		PRINT 'Adding translation entry: BC0A83EA-1560-4E5D-87FC-E14866FE9F0E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('BC0A83EA-1560-4E5D-87FC-E14866FE9F0E',3227,N'ES',N'INSTRUCTIONS',N'#ES# Instructions',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','20201202 22:26:57',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'FBC23526-C2ED-4CD9-998C-6FD4C32FB5D8' )
	BEGIN
		PRINT 'Adding translation entry: FBC23526-C2ED-4CD9-998C-6FD4C32FB5D8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('FBC23526-C2ED-4CD9-998C-6FD4C32FB5D8',3227,N'IT',N'INSTRUCTIONS',N'#IT# Instructions',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201202 22:26:57','20201202 22:26:57',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-3255<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[AuditLink] WHERE [nAuditLinkUID] = '3D4AAF17-3869-4FA7-AEB1-770CD451F04F')
	BEGIN
		PRINT 'Adding audit link'

		INSERT INTO [dbo].[AuditLink] ([nAuditLinkUID],[cColumnName],[cTableName],[cReturnValue],[mCustomSelect],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3D4AAF17-3869-4FA7-AEB1-770CD451F04F','nManualTemplateRowUID','ManualTemplateRows','AuditDisplay',NULL,-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'BA9EAA7B-3779-4CF0-B09F-0F50A1397077')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('BA9EAA7B-3779-4CF0-B09F-0F50A1397077', N'ManualTemplateRows', N'nNominalUnitUID', N'Label', N'Nominal Unit',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'DA17740D-D627-4BAB-8118-04734575E998')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('DA17740D-D627-4BAB-8118-04734575E998', N'ManualTemplateRows', N'nRefUnitUID', N'Label', N'Reference Unit',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '7D60D5D1-D39E-40E9-99E7-C11D31CC6345')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('7D60D5D1-D39E-40E9-99E7-C11D31CC6345', N'ManualTemplateRows', N'nManualTemplateUID', N'Label', N'Manual Template UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '6A039598-5149-4A79-8D5D-6E5B097B8172')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('6A039598-5149-4A79-8D5D-6E5B097B8172', N'ManualTemplateRows', N'nManualTemplateRowUID', N'Label', N'Manual Template Row UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '05B98C1C-032E-4CFA-B882-13F490AC35E8')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('05B98C1C-032E-4CFA-B882-13F490AC35E8', N'ManualTemplateRowTolerances', N'lFullScaleErrorIsPpm', N'Label', N'Full Scale Error Is PPM',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'C144A34D-378C-448F-AF9E-0D22A61F034D')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('C144A34D-378C-448F-AF9E-0D22A61F034D', N'ManualTemplateRowTolerances', N'lIsTransducer', N'Label', N'Is Transducer',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'F22343F6-037C-462D-9C75-797649540C15')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('F22343F6-037C-462D-9C75-797649540C15', N'ManualTemplateRowTolerances', N'lReadingErrorIsPpm', N'Label', N'Reading Error Is PPM',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'BAB928FD-17E7-40E2-B38F-C4743B81110B')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('BAB928FD-17E7-40E2-B38F-C4743B81110B', N'ManualTemplateRowTolerances', N'lUseGreaterOfReadingFullScale', N'Label', N'Use Greater Of Rdg And FS',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'F9EED86B-5131-4006-B1C3-E283FC5A47DB')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('F9EED86B-5131-4006-B1C3-E283FC5A47DB', N'ManualTemplateRowTolerances', N'nFloor', N'Label', N'Floor',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'CE93D049-5270-438D-B3FD-EC19CE481382')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('CE93D049-5270-438D-B3FD-EC19CE481382', N'ManualTemplateRowTolerances', N'nFullScaleErrorPercent', N'Label', N'Full Scale Error Percent',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'B24C50E6-6F74-4FEC-B854-6286AE632B4D')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('B24C50E6-6F74-4FEC-B854-6286AE632B4D', N'ManualTemplateRowTolerances', N'nInputMax', N'Label', N'Max Input',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '34E037CD-BF32-4CAC-A6F0-5F13304C764C')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('34E037CD-BF32-4CAC-A6F0-5F13304C764C', N'ManualTemplateRowTolerances', N'nInputMin', N'Label', N'Min Input',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '9E866D81-5FE5-483C-BA68-B45428A5307D')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('9E866D81-5FE5-483C-BA68-B45428A5307D', N'ManualTemplateRowTolerances', N'nManualTemplateRowUID', N'Label', N'Manual Template Row UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '8770C43F-9BD4-48D2-9790-ECBBA70954E9')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('8770C43F-9BD4-48D2-9790-ECBBA70954E9', N'ManualTemplateRowTolerances', N'nManualTemplateRowToleranceUID', N'Label', N'Manual Template Row Tolerance UID',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '19E7EE29-E1BD-428B-B1CA-E70610DB6D58')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('19E7EE29-E1BD-428B-B1CA-E70610DB6D58', N'ManualTemplateRowTolerances', N'nOutputMax', N'Label', N'Max Output',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'E92B4AE8-429D-4DA7-8F6B-4E0032A04A42')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('E92B4AE8-429D-4DA7-8F6B-4E0032A04A42', N'ManualTemplateRowTolerances', N'nOutputMin', N'Label', N'Min Output',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '7EF77004-DF16-4F04-BEB8-237EE85174A8')
	BEGIN
	    PRINT N'Adding UCI Data Item'
	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('7EF77004-DF16-4F04-BEB8-237EE85174A8', N'ManualTemplateRowTolerances', N'nReadingErrorPercent', N'Label', N'Reading Error Percent',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20201207 17:37:44.297', '20201207 17:37:44.297', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '09B9536D-4430-4D05-92C1-8D1245D29748' )
	BEGIN
		PRINT 'Adding translation entry: 09B9536D-4430-4D05-92C1-8D1245D29748'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('09B9536D-4430-4D05-92C1-8D1245D29748',3228,N'EN',N'Nominal Unit',N'Nominal Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2D048AD6-52E1-4A57-B98F-631D1151E562' )
	BEGIN
		PRINT 'Adding translation entry: 2D048AD6-52E1-4A57-B98F-631D1151E562'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2D048AD6-52E1-4A57-B98F-631D1151E562',3228,N'DE',N'Nominal Unit',N'#DE# Nominal Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '699FBC60-025B-4F3A-A8E5-69B129C7DC4C' )
	BEGIN
		PRINT 'Adding translation entry: 699FBC60-025B-4F3A-A8E5-69B129C7DC4C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('699FBC60-025B-4F3A-A8E5-69B129C7DC4C',3228,N'RU',N'Nominal Unit',N'#RU# Nominal Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B9372E07-A318-4EF3-9B23-4A7EBDD86AAA' )
	BEGIN
		PRINT 'Adding translation entry: B9372E07-A318-4EF3-9B23-4A7EBDD86AAA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B9372E07-A318-4EF3-9B23-4A7EBDD86AAA',3228,N'PT',N'Nominal Unit',N'#PT# Nominal Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EF66E645-CA92-482A-965E-B1B11B75FE29' )
	BEGIN
		PRINT 'Adding translation entry: EF66E645-CA92-482A-965E-B1B11B75FE29'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EF66E645-CA92-482A-965E-B1B11B75FE29',3228,N'ZH',N'Nominal Unit',N'#ZH# Nominal Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D3B71B3A-3181-4195-9105-623237D80585' )
	BEGIN
		PRINT 'Adding translation entry: D3B71B3A-3181-4195-9105-623237D80585'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D3B71B3A-3181-4195-9105-623237D80585',3228,N'JA',N'Nominal Unit',N'#JA# Nominal Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D9275CDE-96F7-4720-B9BE-1A81C07F09B3' )
	BEGIN
		PRINT 'Adding translation entry: D9275CDE-96F7-4720-B9BE-1A81C07F09B3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D9275CDE-96F7-4720-B9BE-1A81C07F09B3',3228,N'FR',N'Nominal Unit',N'#FR# Nominal Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '3018CE65-3EA4-47FE-9479-598E539C23C3' )
	BEGIN
		PRINT 'Adding translation entry: 3018CE65-3EA4-47FE-9479-598E539C23C3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3018CE65-3EA4-47FE-9479-598E539C23C3',3228,N'ES',N'Nominal Unit',N'#ES# Nominal Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '642813A0-5735-4E69-B2F1-C7454ED7A86E' )
	BEGIN
		PRINT 'Adding translation entry: 642813A0-5735-4E69-B2F1-C7454ED7A86E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('642813A0-5735-4E69-B2F1-C7454ED7A86E',3228,N'IT',N'Nominal Unit',N'#IT# Nominal Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '83734013-52C4-4E68-B8B3-09CB197F5A84' )
	BEGIN
		PRINT 'Adding translation entry: 83734013-52C4-4E68-B8B3-09CB197F5A84'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('83734013-52C4-4E68-B8B3-09CB197F5A84',3229,N'EN',N'Reference Unit',N'Reference Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C6A2C3B5-6B26-426F-842B-2ACACDD0C5E3' )
	BEGIN
		PRINT 'Adding translation entry: C6A2C3B5-6B26-426F-842B-2ACACDD0C5E3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C6A2C3B5-6B26-426F-842B-2ACACDD0C5E3',3229,N'DE',N'Reference Unit',N'#DE# Reference Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '72B08C4F-DA12-4964-B00B-DBB86261EFFD' )
	BEGIN
		PRINT 'Adding translation entry: 72B08C4F-DA12-4964-B00B-DBB86261EFFD'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('72B08C4F-DA12-4964-B00B-DBB86261EFFD',3229,N'RU',N'Reference Unit',N'#RU# Reference Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'FE44FD94-3C97-4E75-9C53-39C7EF6587A8' )
	BEGIN
		PRINT 'Adding translation entry: FE44FD94-3C97-4E75-9C53-39C7EF6587A8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('FE44FD94-3C97-4E75-9C53-39C7EF6587A8',3229,N'PT',N'Reference Unit',N'#PT# Reference Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '16D71B15-FB64-445D-AF3F-444E83BAD29A' )
	BEGIN
		PRINT 'Adding translation entry: 16D71B15-FB64-445D-AF3F-444E83BAD29A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('16D71B15-FB64-445D-AF3F-444E83BAD29A',3229,N'ZH',N'Reference Unit',N'#ZH# Reference Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '45BB5880-F215-48A9-A7DE-DFA2D2054FEE' )
	BEGIN
		PRINT 'Adding translation entry: 45BB5880-F215-48A9-A7DE-DFA2D2054FEE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('45BB5880-F215-48A9-A7DE-DFA2D2054FEE',3229,N'JA',N'Reference Unit',N'#JA# Reference Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C542F499-4140-4273-9A59-3EF52115098D' )
	BEGIN
		PRINT 'Adding translation entry: C542F499-4140-4273-9A59-3EF52115098D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C542F499-4140-4273-9A59-3EF52115098D',3229,N'FR',N'Reference Unit',N'#FR# Reference Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '4633A75C-EB3C-41EC-AF4A-1658AB2C23A6' )
	BEGIN
		PRINT 'Adding translation entry: 4633A75C-EB3C-41EC-AF4A-1658AB2C23A6'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('4633A75C-EB3C-41EC-AF4A-1658AB2C23A6',3229,N'ES',N'Reference Unit',N'#ES# Reference Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A9E9C72B-325F-43E3-AE97-97BB36D94FD3' )
	BEGIN
		PRINT 'Adding translation entry: A9E9C72B-325F-43E3-AE97-97BB36D94FD3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A9E9C72B-325F-43E3-AE97-97BB36D94FD3',3229,N'IT',N'Reference Unit',N'#IT# Reference Unit',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1AB1391A-5DDA-4A6A-862E-C8E8AE113344' )
	BEGIN
		PRINT 'Adding translation entry: 1AB1391A-5DDA-4A6A-862E-C8E8AE113344'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1AB1391A-5DDA-4A6A-862E-C8E8AE113344',3230,N'EN',N'Manual Template UID',N'Manual Template UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '342C1BA6-79E0-451E-A408-41D5B066FEFE' )
	BEGIN
		PRINT 'Adding translation entry: 342C1BA6-79E0-451E-A408-41D5B066FEFE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('342C1BA6-79E0-451E-A408-41D5B066FEFE',3230,N'DE',N'Manual Template UID',N'#DE# Manual Template UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8F3BC6E6-11E0-47A6-BF42-3AFA99D79BB2' )
	BEGIN
		PRINT 'Adding translation entry: 8F3BC6E6-11E0-47A6-BF42-3AFA99D79BB2'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8F3BC6E6-11E0-47A6-BF42-3AFA99D79BB2',3230,N'RU',N'Manual Template UID',N'#RU# Manual Template UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2996A83A-DB0C-4766-8BFB-A413A254F50A' )
	BEGIN
		PRINT 'Adding translation entry: 2996A83A-DB0C-4766-8BFB-A413A254F50A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2996A83A-DB0C-4766-8BFB-A413A254F50A',3230,N'PT',N'Manual Template UID',N'#PT# Manual Template UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B8A3FCCE-F0A9-4E1A-B8E4-B42DCB56E3D0' )
	BEGIN
		PRINT 'Adding translation entry: B8A3FCCE-F0A9-4E1A-B8E4-B42DCB56E3D0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B8A3FCCE-F0A9-4E1A-B8E4-B42DCB56E3D0',3230,N'ZH',N'Manual Template UID',N'#ZH# Manual Template UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '022642BB-0965-4D50-81DE-D8866C14821D' )
	BEGIN
		PRINT 'Adding translation entry: 022642BB-0965-4D50-81DE-D8866C14821D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('022642BB-0965-4D50-81DE-D8866C14821D',3230,N'JA',N'Manual Template UID',N'#JA# Manual Template UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '92D4B8A9-ABCC-4E66-8341-FA8F2F11DFDF' )
	BEGIN
		PRINT 'Adding translation entry: 92D4B8A9-ABCC-4E66-8341-FA8F2F11DFDF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('92D4B8A9-ABCC-4E66-8341-FA8F2F11DFDF',3230,N'FR',N'Manual Template UID',N'#FR# Manual Template UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2B83EE14-93D0-4D44-A051-B8718C69DA4E' )
	BEGIN
		PRINT 'Adding translation entry: 2B83EE14-93D0-4D44-A051-B8718C69DA4E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2B83EE14-93D0-4D44-A051-B8718C69DA4E',3230,N'ES',N'Manual Template UID',N'#ES# Manual Template UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '62405D52-D108-4A0C-BE95-DF4E18342DF7' )
	BEGIN
		PRINT 'Adding translation entry: 62405D52-D108-4A0C-BE95-DF4E18342DF7'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('62405D52-D108-4A0C-BE95-DF4E18342DF7',3230,N'IT',N'Manual Template UID',N'#IT# Manual Template UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '32909A57-D093-4C42-8E09-70D4B74B58AC' )
	BEGIN
		PRINT 'Adding translation entry: 32909A57-D093-4C42-8E09-70D4B74B58AC'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('32909A57-D093-4C42-8E09-70D4B74B58AC',3231,N'EN',N'Manual Template Row UID',N'Manual Template Row UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2DB3D80A-6238-413C-A693-B13E9710BB85' )
	BEGIN
		PRINT 'Adding translation entry: 2DB3D80A-6238-413C-A693-B13E9710BB85'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2DB3D80A-6238-413C-A693-B13E9710BB85',3231,N'DE',N'Manual Template Row UID',N'#DE# Manual Template Row UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '032C0665-64F9-4F26-890C-3D0F80A63194' )
	BEGIN
		PRINT 'Adding translation entry: 032C0665-64F9-4F26-890C-3D0F80A63194'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('032C0665-64F9-4F26-890C-3D0F80A63194',3231,N'RU',N'Manual Template Row UID',N'#RU# Manual Template Row UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5A65F61A-A0A5-4671-9E23-A5D4A2FB8D48' )
	BEGIN
		PRINT 'Adding translation entry: 5A65F61A-A0A5-4671-9E23-A5D4A2FB8D48'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5A65F61A-A0A5-4671-9E23-A5D4A2FB8D48',3231,N'PT',N'Manual Template Row UID',N'#PT# Manual Template Row UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C5EC96BD-B816-412A-BCB3-044AE4605362' )
	BEGIN
		PRINT 'Adding translation entry: C5EC96BD-B816-412A-BCB3-044AE4605362'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C5EC96BD-B816-412A-BCB3-044AE4605362',3231,N'ZH',N'Manual Template Row UID',N'#ZH# Manual Template Row UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A8EB6EBE-C567-4F14-82B3-DC567B79E8BB' )
	BEGIN
		PRINT 'Adding translation entry: A8EB6EBE-C567-4F14-82B3-DC567B79E8BB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A8EB6EBE-C567-4F14-82B3-DC567B79E8BB',3231,N'JA',N'Manual Template Row UID',N'#JA# Manual Template Row UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'FCAAABAE-1AB0-457D-95CA-1E357B79A7C1' )
	BEGIN
		PRINT 'Adding translation entry: FCAAABAE-1AB0-457D-95CA-1E357B79A7C1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('FCAAABAE-1AB0-457D-95CA-1E357B79A7C1',3231,N'FR',N'Manual Template Row UID',N'#FR# Manual Template Row UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '292D1F98-1BC2-46BA-9052-ECC6F81E650C' )
	BEGIN
		PRINT 'Adding translation entry: 292D1F98-1BC2-46BA-9052-ECC6F81E650C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('292D1F98-1BC2-46BA-9052-ECC6F81E650C',3231,N'ES',N'Manual Template Row UID',N'#ES# Manual Template Row UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EF933F22-9E51-432C-8563-DC539714A003' )
	BEGIN
		PRINT 'Adding translation entry: EF933F22-9E51-432C-8563-DC539714A003'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EF933F22-9E51-432C-8563-DC539714A003',3231,N'IT',N'Manual Template Row UID',N'#IT# Manual Template Row UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'BA7ACBB9-46F7-4550-90A3-1D401CCE33DD' )
	BEGIN
		PRINT 'Adding translation entry: BA7ACBB9-46F7-4550-90A3-1D401CCE33DD'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('BA7ACBB9-46F7-4550-90A3-1D401CCE33DD',3232,N'EN',N'Full Scale Error Is PPM',N'Full Scale Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EA73C76F-BE25-4363-972C-B98A19AC8E97' )
	BEGIN
		PRINT 'Adding translation entry: EA73C76F-BE25-4363-972C-B98A19AC8E97'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EA73C76F-BE25-4363-972C-B98A19AC8E97',3232,N'DE',N'Full Scale Error Is PPM',N'#DE# Full Scale Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '457B3C55-F386-4FCB-822B-53469FBA2A5D' )
	BEGIN
		PRINT 'Adding translation entry: 457B3C55-F386-4FCB-822B-53469FBA2A5D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('457B3C55-F386-4FCB-822B-53469FBA2A5D',3232,N'RU',N'Full Scale Error Is PPM',N'#RU# Full Scale Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D2CA356B-EECB-4A36-839E-D9921E5F2E41' )
	BEGIN
		PRINT 'Adding translation entry: D2CA356B-EECB-4A36-839E-D9921E5F2E41'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D2CA356B-EECB-4A36-839E-D9921E5F2E41',3232,N'PT',N'Full Scale Error Is PPM',N'#PT# Full Scale Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D65DC837-2EFD-43DB-9369-7CE9388401FC' )
	BEGIN
		PRINT 'Adding translation entry: D65DC837-2EFD-43DB-9369-7CE9388401FC'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D65DC837-2EFD-43DB-9369-7CE9388401FC',3232,N'ZH',N'Full Scale Error Is PPM',N'#ZH# Full Scale Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '4547F34C-B642-4E8F-A0CF-FB3F4C9B43F9' )
	BEGIN
		PRINT 'Adding translation entry: 4547F34C-B642-4E8F-A0CF-FB3F4C9B43F9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('4547F34C-B642-4E8F-A0CF-FB3F4C9B43F9',3232,N'JA',N'Full Scale Error Is PPM',N'#JA# Full Scale Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'FBBAB0FA-74BE-44EA-83AD-131818B47BAE' )
	BEGIN
		PRINT 'Adding translation entry: FBBAB0FA-74BE-44EA-83AD-131818B47BAE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('FBBAB0FA-74BE-44EA-83AD-131818B47BAE',3232,N'FR',N'Full Scale Error Is PPM',N'#FR# Full Scale Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F5841BA8-44B2-49F4-88CA-B48CE8B1F40D' )
	BEGIN
		PRINT 'Adding translation entry: F5841BA8-44B2-49F4-88CA-B48CE8B1F40D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F5841BA8-44B2-49F4-88CA-B48CE8B1F40D',3232,N'ES',N'Full Scale Error Is PPM',N'#ES# Full Scale Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '004B704D-9977-45EC-8735-912363F78763' )
	BEGIN
		PRINT 'Adding translation entry: 004B704D-9977-45EC-8735-912363F78763'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('004B704D-9977-45EC-8735-912363F78763',3232,N'IT',N'Full Scale Error Is PPM',N'#IT# Full Scale Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DCD30A98-ACCA-4B7A-B556-CD32508BB35D' )
	BEGIN
		PRINT 'Adding translation entry: DCD30A98-ACCA-4B7A-B556-CD32508BB35D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DCD30A98-ACCA-4B7A-B556-CD32508BB35D',3233,N'EN',N'Is Transducer',N'Is Transducer',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2E31C61C-3898-4A94-9ED8-7EEEC294F3CE' )
	BEGIN
		PRINT 'Adding translation entry: 2E31C61C-3898-4A94-9ED8-7EEEC294F3CE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2E31C61C-3898-4A94-9ED8-7EEEC294F3CE',3233,N'DE',N'Is Transducer',N'#DE# Is Transducer',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E45EC755-7551-4969-A97A-1C42073018C3' )
	BEGIN
		PRINT 'Adding translation entry: E45EC755-7551-4969-A97A-1C42073018C3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E45EC755-7551-4969-A97A-1C42073018C3',3233,N'RU',N'Is Transducer',N'#RU# Is Transducer',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '19280C4F-4FE6-4FFF-BF53-0A1D2DA4730D' )
	BEGIN
		PRINT 'Adding translation entry: 19280C4F-4FE6-4FFF-BF53-0A1D2DA4730D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('19280C4F-4FE6-4FFF-BF53-0A1D2DA4730D',3233,N'PT',N'Is Transducer',N'#PT# Is Transducer',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '608CF613-EA1C-437E-B85A-E80B631B8D4B' )
	BEGIN
		PRINT 'Adding translation entry: 608CF613-EA1C-437E-B85A-E80B631B8D4B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('608CF613-EA1C-437E-B85A-E80B631B8D4B',3233,N'ZH',N'Is Transducer',N'#ZH# Is Transducer',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7D8DA453-2254-4D61-95F1-315A50DC6562' )
	BEGIN
		PRINT 'Adding translation entry: 7D8DA453-2254-4D61-95F1-315A50DC6562'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7D8DA453-2254-4D61-95F1-315A50DC6562',3233,N'JA',N'Is Transducer',N'#JA# Is Transducer',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '095BC70A-8E42-4633-A742-4E2C132498EE' )
	BEGIN
		PRINT 'Adding translation entry: 095BC70A-8E42-4633-A742-4E2C132498EE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('095BC70A-8E42-4633-A742-4E2C132498EE',3233,N'FR',N'Is Transducer',N'#FR# Is Transducer',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '51E6CDF3-68E0-4326-B3C0-69D862E6139C' )
	BEGIN
		PRINT 'Adding translation entry: 51E6CDF3-68E0-4326-B3C0-69D862E6139C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('51E6CDF3-68E0-4326-B3C0-69D862E6139C',3233,N'ES',N'Is Transducer',N'#ES# Is Transducer',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '58057B53-05A0-4C0F-A361-444319E9D9BE' )
	BEGIN
		PRINT 'Adding translation entry: 58057B53-05A0-4C0F-A361-444319E9D9BE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('58057B53-05A0-4C0F-A361-444319E9D9BE',3233,N'IT',N'Is Transducer',N'#IT# Is Transducer',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2CFDD5A2-59DA-4664-9C67-686631CA9CAB' )
	BEGIN
		PRINT 'Adding translation entry: 2CFDD5A2-59DA-4664-9C67-686631CA9CAB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2CFDD5A2-59DA-4664-9C67-686631CA9CAB',3234,N'EN',N'Reading Error Is PPM',N'Reading Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DF7449C5-149D-41D2-9971-2F909A31EAFA' )
	BEGIN
		PRINT 'Adding translation entry: DF7449C5-149D-41D2-9971-2F909A31EAFA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DF7449C5-149D-41D2-9971-2F909A31EAFA',3234,N'DE',N'Reading Error Is PPM',N'#DE# Reading Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '90027B55-52B3-4200-B8FA-1EBED41804D1' )
	BEGIN
		PRINT 'Adding translation entry: 90027B55-52B3-4200-B8FA-1EBED41804D1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('90027B55-52B3-4200-B8FA-1EBED41804D1',3234,N'RU',N'Reading Error Is PPM',N'#RU# Reading Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DE0A18DB-DDD6-4A04-8FE7-B05512F0A031' )
	BEGIN
		PRINT 'Adding translation entry: DE0A18DB-DDD6-4A04-8FE7-B05512F0A031'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DE0A18DB-DDD6-4A04-8FE7-B05512F0A031',3234,N'PT',N'Reading Error Is PPM',N'#PT# Reading Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '38CFC9B4-0BE7-4D6D-9E45-996D74BFEB8E' )
	BEGIN
		PRINT 'Adding translation entry: 38CFC9B4-0BE7-4D6D-9E45-996D74BFEB8E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('38CFC9B4-0BE7-4D6D-9E45-996D74BFEB8E',3234,N'ZH',N'Reading Error Is PPM',N'#ZH# Reading Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5DEBD927-3A2D-4A2F-9817-38F30E5157DB' )
	BEGIN
		PRINT 'Adding translation entry: 5DEBD927-3A2D-4A2F-9817-38F30E5157DB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5DEBD927-3A2D-4A2F-9817-38F30E5157DB',3234,N'JA',N'Reading Error Is PPM',N'#JA# Reading Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1D37409E-2A7B-49EC-AE5C-0EBFFA270C10' )
	BEGIN
		PRINT 'Adding translation entry: 1D37409E-2A7B-49EC-AE5C-0EBFFA270C10'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1D37409E-2A7B-49EC-AE5C-0EBFFA270C10',3234,N'FR',N'Reading Error Is PPM',N'#FR# Reading Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D193B5D6-56A5-4BF7-B7BB-715E5E2DC78F' )
	BEGIN
		PRINT 'Adding translation entry: D193B5D6-56A5-4BF7-B7BB-715E5E2DC78F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D193B5D6-56A5-4BF7-B7BB-715E5E2DC78F',3234,N'ES',N'Reading Error Is PPM',N'#ES# Reading Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '3105EF2D-D73A-4EF4-9D75-358F8FF38BFE' )
	BEGIN
		PRINT 'Adding translation entry: 3105EF2D-D73A-4EF4-9D75-358F8FF38BFE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3105EF2D-D73A-4EF4-9D75-358F8FF38BFE',3234,N'IT',N'Reading Error Is PPM',N'#IT# Reading Error Is PPM',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '729496DC-CBD4-4915-ACA0-9E291AAE18F1' )
	BEGIN
		PRINT 'Adding translation entry: 729496DC-CBD4-4915-ACA0-9E291AAE18F1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('729496DC-CBD4-4915-ACA0-9E291AAE18F1',3235,N'EN',N'Use Greater Of Rdg And FS',N'Use Greater Of Rdg And FS',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5D73284A-1CB9-453C-895B-FCDD29CF9546' )
	BEGIN
		PRINT 'Adding translation entry: 5D73284A-1CB9-453C-895B-FCDD29CF9546'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5D73284A-1CB9-453C-895B-FCDD29CF9546',3235,N'DE',N'Use Greater Of Rdg And FS',N'#DE# Use Greater Of Rdg And FS',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '62226819-A546-49EA-AFE3-25901A761154' )
	BEGIN
		PRINT 'Adding translation entry: 62226819-A546-49EA-AFE3-25901A761154'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('62226819-A546-49EA-AFE3-25901A761154',3235,N'RU',N'Use Greater Of Rdg And FS',N'#RU# Use Greater Of Rdg And FS',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B673D8D0-0F47-4602-BD5F-514256985D71' )
	BEGIN
		PRINT 'Adding translation entry: B673D8D0-0F47-4602-BD5F-514256985D71'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B673D8D0-0F47-4602-BD5F-514256985D71',3235,N'PT',N'Use Greater Of Rdg And FS',N'#PT# Use Greater Of Rdg And FS',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5855CE8C-5C5F-43D8-A026-11A3F70A9834' )
	BEGIN
		PRINT 'Adding translation entry: 5855CE8C-5C5F-43D8-A026-11A3F70A9834'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5855CE8C-5C5F-43D8-A026-11A3F70A9834',3235,N'ZH',N'Use Greater Of Rdg And FS',N'#ZH# Use Greater Of Rdg And FS',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '98F43568-E965-4B40-B4C5-9EC85DD26151' )
	BEGIN
		PRINT 'Adding translation entry: 98F43568-E965-4B40-B4C5-9EC85DD26151'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('98F43568-E965-4B40-B4C5-9EC85DD26151',3235,N'JA',N'Use Greater Of Rdg And FS',N'#JA# Use Greater Of Rdg And FS',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6105AC75-B523-4E64-BB51-2CEFB4F2E8B2' )
	BEGIN
		PRINT 'Adding translation entry: 6105AC75-B523-4E64-BB51-2CEFB4F2E8B2'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6105AC75-B523-4E64-BB51-2CEFB4F2E8B2',3235,N'FR',N'Use Greater Of Rdg And FS',N'#FR# Use Greater Of Rdg And FS',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '745A1B6E-E4EE-44F8-AEDA-BA285A064240' )
	BEGIN
		PRINT 'Adding translation entry: 745A1B6E-E4EE-44F8-AEDA-BA285A064240'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('745A1B6E-E4EE-44F8-AEDA-BA285A064240',3235,N'ES',N'Use Greater Of Rdg And FS',N'#ES# Use Greater Of Rdg And FS',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '889D74FF-8365-4B36-BF5F-84EF702CBCE5' )
	BEGIN
		PRINT 'Adding translation entry: 889D74FF-8365-4B36-BF5F-84EF702CBCE5'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('889D74FF-8365-4B36-BF5F-84EF702CBCE5',3235,N'IT',N'Use Greater Of Rdg And FS',N'#IT# Use Greater Of Rdg And FS',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '946BEA51-7402-4B60-8DB3-DB4ECC632BA7' )
	BEGIN
		PRINT 'Adding translation entry: 946BEA51-7402-4B60-8DB3-DB4ECC632BA7'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('946BEA51-7402-4B60-8DB3-DB4ECC632BA7',3236,N'EN',N'Full Scale Error Percent',N'Full Scale Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F169AFEA-5BAA-4703-A4B8-D3D5283459DE' )
	BEGIN
		PRINT 'Adding translation entry: F169AFEA-5BAA-4703-A4B8-D3D5283459DE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F169AFEA-5BAA-4703-A4B8-D3D5283459DE',3236,N'DE',N'Full Scale Error Percent',N'#DE# Full Scale Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '83FEB3EA-0C3A-46B3-977E-9E1AACEA4B1B' )
	BEGIN
		PRINT 'Adding translation entry: 83FEB3EA-0C3A-46B3-977E-9E1AACEA4B1B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('83FEB3EA-0C3A-46B3-977E-9E1AACEA4B1B',3236,N'RU',N'Full Scale Error Percent',N'#RU# Full Scale Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '275236C4-65EE-4C84-A2CA-279B95AB08D3' )
	BEGIN
		PRINT 'Adding translation entry: 275236C4-65EE-4C84-A2CA-279B95AB08D3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('275236C4-65EE-4C84-A2CA-279B95AB08D3',3236,N'PT',N'Full Scale Error Percent',N'#PT# Full Scale Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5B1FFD31-E452-4987-8D33-47598E8C42A1' )
	BEGIN
		PRINT 'Adding translation entry: 5B1FFD31-E452-4987-8D33-47598E8C42A1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5B1FFD31-E452-4987-8D33-47598E8C42A1',3236,N'ZH',N'Full Scale Error Percent',N'#ZH# Full Scale Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6E10DD7E-3846-4594-B361-F23CCA58EE6F' )
	BEGIN
		PRINT 'Adding translation entry: 6E10DD7E-3846-4594-B361-F23CCA58EE6F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6E10DD7E-3846-4594-B361-F23CCA58EE6F',3236,N'JA',N'Full Scale Error Percent',N'#JA# Full Scale Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EFDFDA30-234D-4D7B-B29A-DA4FF929BB57' )
	BEGIN
		PRINT 'Adding translation entry: EFDFDA30-234D-4D7B-B29A-DA4FF929BB57'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EFDFDA30-234D-4D7B-B29A-DA4FF929BB57',3236,N'FR',N'Full Scale Error Percent',N'#FR# Full Scale Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F77B341C-ED76-4E6B-9677-9B232A0DAE90' )
	BEGIN
		PRINT 'Adding translation entry: F77B341C-ED76-4E6B-9677-9B232A0DAE90'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F77B341C-ED76-4E6B-9677-9B232A0DAE90',3236,N'ES',N'Full Scale Error Percent',N'#ES# Full Scale Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E220B672-8EF1-4271-8473-EBF24EE9EB89' )
	BEGIN
		PRINT 'Adding translation entry: E220B672-8EF1-4271-8473-EBF24EE9EB89'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E220B672-8EF1-4271-8473-EBF24EE9EB89',3236,N'IT',N'Full Scale Error Percent',N'#IT# Full Scale Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '350D8486-DFF5-4067-8A9D-384D98F87C15' )
	BEGIN
		PRINT 'Adding translation entry: 350D8486-DFF5-4067-8A9D-384D98F87C15'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('350D8486-DFF5-4067-8A9D-384D98F87C15',3237,N'EN',N'Max Input',N'Max Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9EC8D7CF-61C0-40AB-820F-846737621B83' )
	BEGIN
		PRINT 'Adding translation entry: 9EC8D7CF-61C0-40AB-820F-846737621B83'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9EC8D7CF-61C0-40AB-820F-846737621B83',3237,N'DE',N'Max Input',N'#DE# Max Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C5D1AB74-C51A-4EE0-8F14-C06DE95EF486' )
	BEGIN
		PRINT 'Adding translation entry: C5D1AB74-C51A-4EE0-8F14-C06DE95EF486'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C5D1AB74-C51A-4EE0-8F14-C06DE95EF486',3237,N'RU',N'Max Input',N'#RU# Max Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '84600CBA-97EB-4C72-9C98-88C8F6E1473C' )
	BEGIN
		PRINT 'Adding translation entry: 84600CBA-97EB-4C72-9C98-88C8F6E1473C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('84600CBA-97EB-4C72-9C98-88C8F6E1473C',3237,N'PT',N'Max Input',N'#PT# Max Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '45D77E71-410C-47A5-A276-6B9CFEDA0CFE' )
	BEGIN
		PRINT 'Adding translation entry: 45D77E71-410C-47A5-A276-6B9CFEDA0CFE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('45D77E71-410C-47A5-A276-6B9CFEDA0CFE',3237,N'ZH',N'Max Input',N'#ZH# Max Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7FADF788-E9C7-430A-A1D2-BA64FEAEBF24' )
	BEGIN
		PRINT 'Adding translation entry: 7FADF788-E9C7-430A-A1D2-BA64FEAEBF24'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7FADF788-E9C7-430A-A1D2-BA64FEAEBF24',3237,N'JA',N'Max Input',N'#JA# Max Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9274B891-F3AC-47EA-A21E-B5645F0E32F4' )
	BEGIN
		PRINT 'Adding translation entry: 9274B891-F3AC-47EA-A21E-B5645F0E32F4'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9274B891-F3AC-47EA-A21E-B5645F0E32F4',3237,N'FR',N'Max Input',N'#FR# Max Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C2012E6F-593E-411E-BBA3-9A125ADB321D' )
	BEGIN
		PRINT 'Adding translation entry: C2012E6F-593E-411E-BBA3-9A125ADB321D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C2012E6F-593E-411E-BBA3-9A125ADB321D',3237,N'ES',N'Max Input',N'#ES# Max Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A6B8B6D3-9AAB-463E-A832-5EF1350B203F' )
	BEGIN
		PRINT 'Adding translation entry: A6B8B6D3-9AAB-463E-A832-5EF1350B203F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A6B8B6D3-9AAB-463E-A832-5EF1350B203F',3237,N'IT',N'Max Input',N'#IT# Max Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'CCAEE6C9-4B93-484C-84C1-73589E002DB9' )
	BEGIN
		PRINT 'Adding translation entry: CCAEE6C9-4B93-484C-84C1-73589E002DB9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('CCAEE6C9-4B93-484C-84C1-73589E002DB9',3238,N'EN',N'Min Input',N'Min Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '10533D1D-C35E-4A6E-BC2B-801460579A9F' )
	BEGIN
		PRINT 'Adding translation entry: 10533D1D-C35E-4A6E-BC2B-801460579A9F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('10533D1D-C35E-4A6E-BC2B-801460579A9F',3238,N'DE',N'Min Input',N'#DE# Min Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '70BA37C1-F981-4CFB-9BF0-AD3CF5CC1B3A' )
	BEGIN
		PRINT 'Adding translation entry: 70BA37C1-F981-4CFB-9BF0-AD3CF5CC1B3A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('70BA37C1-F981-4CFB-9BF0-AD3CF5CC1B3A',3238,N'RU',N'Min Input',N'#RU# Min Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '738A006F-5788-4926-83BF-85CEE9574717' )
	BEGIN
		PRINT 'Adding translation entry: 738A006F-5788-4926-83BF-85CEE9574717'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('738A006F-5788-4926-83BF-85CEE9574717',3238,N'PT',N'Min Input',N'#PT# Min Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8AEEB92D-1B87-4DE9-8115-0959241EAE1D' )
	BEGIN
		PRINT 'Adding translation entry: 8AEEB92D-1B87-4DE9-8115-0959241EAE1D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8AEEB92D-1B87-4DE9-8115-0959241EAE1D',3238,N'ZH',N'Min Input',N'#ZH# Min Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'FE3E1919-B036-4206-A9D4-50407A77B570' )
	BEGIN
		PRINT 'Adding translation entry: FE3E1919-B036-4206-A9D4-50407A77B570'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('FE3E1919-B036-4206-A9D4-50407A77B570',3238,N'JA',N'Min Input',N'#JA# Min Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2DC913DE-8FD8-4678-901F-242EF7D6A19E' )
	BEGIN
		PRINT 'Adding translation entry: 2DC913DE-8FD8-4678-901F-242EF7D6A19E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2DC913DE-8FD8-4678-901F-242EF7D6A19E',3238,N'FR',N'Min Input',N'#FR# Min Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '337FF834-533E-4DF7-B43A-BA5698F53320' )
	BEGIN
		PRINT 'Adding translation entry: 337FF834-533E-4DF7-B43A-BA5698F53320'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('337FF834-533E-4DF7-B43A-BA5698F53320',3238,N'ES',N'Min Input',N'#ES# Min Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'CDD95C06-1477-4532-A9DC-0D8866656123' )
	BEGIN
		PRINT 'Adding translation entry: CDD95C06-1477-4532-A9DC-0D8866656123'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('CDD95C06-1477-4532-A9DC-0D8866656123',3238,N'IT',N'Min Input',N'#IT# Min Input',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '153643B8-E4F2-42AC-8310-F2AA43F0BBA9' )
	BEGIN
		PRINT 'Adding translation entry: 153643B8-E4F2-42AC-8310-F2AA43F0BBA9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('153643B8-E4F2-42AC-8310-F2AA43F0BBA9',3239,N'EN',N'Manual Template Row Tolerance UID',N'Manual Template Row Tolerance UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '77579DE3-F39C-432D-9A6D-B5FD913283E8' )
	BEGIN
		PRINT 'Adding translation entry: 77579DE3-F39C-432D-9A6D-B5FD913283E8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('77579DE3-F39C-432D-9A6D-B5FD913283E8',3239,N'DE',N'Manual Template Row Tolerance UID',N'#DE# Manual Template Row Tolerance UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B9D57675-6A55-4099-B4F5-D87FB3873B89' )
	BEGIN
		PRINT 'Adding translation entry: B9D57675-6A55-4099-B4F5-D87FB3873B89'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B9D57675-6A55-4099-B4F5-D87FB3873B89',3239,N'RU',N'Manual Template Row Tolerance UID',N'#RU# Manual Template Row Tolerance UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '258A704F-D487-4569-8342-588BAB555842' )
	BEGIN
		PRINT 'Adding translation entry: 258A704F-D487-4569-8342-588BAB555842'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('258A704F-D487-4569-8342-588BAB555842',3239,N'PT',N'Manual Template Row Tolerance UID',N'#PT# Manual Template Row Tolerance UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6151DC6F-24AD-4488-AC19-099D022CAAFA' )
	BEGIN
		PRINT 'Adding translation entry: 6151DC6F-24AD-4488-AC19-099D022CAAFA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6151DC6F-24AD-4488-AC19-099D022CAAFA',3239,N'ZH',N'Manual Template Row Tolerance UID',N'#ZH# Manual Template Row Tolerance UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B23B7325-23A8-429A-A319-214E281BB966' )
	BEGIN
		PRINT 'Adding translation entry: B23B7325-23A8-429A-A319-214E281BB966'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B23B7325-23A8-429A-A319-214E281BB966',3239,N'JA',N'Manual Template Row Tolerance UID',N'#JA# Manual Template Row Tolerance UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '67B35B3F-DCF7-4D05-8A98-1E5BFABE46BE' )
	BEGIN
		PRINT 'Adding translation entry: 67B35B3F-DCF7-4D05-8A98-1E5BFABE46BE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('67B35B3F-DCF7-4D05-8A98-1E5BFABE46BE',3239,N'FR',N'Manual Template Row Tolerance UID',N'#FR# Manual Template Row Tolerance UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7D4EA1ED-8743-45E2-92A8-3000B555BD4A' )
	BEGIN
		PRINT 'Adding translation entry: 7D4EA1ED-8743-45E2-92A8-3000B555BD4A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7D4EA1ED-8743-45E2-92A8-3000B555BD4A',3239,N'ES',N'Manual Template Row Tolerance UID',N'#ES# Manual Template Row Tolerance UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1484D765-F84A-445E-A506-C138F41B9B61' )
	BEGIN
		PRINT 'Adding translation entry: 1484D765-F84A-445E-A506-C138F41B9B61'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1484D765-F84A-445E-A506-C138F41B9B61',3239,N'IT',N'Manual Template Row Tolerance UID',N'#IT# Manual Template Row Tolerance UID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E1C15BCC-BDE0-4AD3-965E-2EE419329ECA' )
	BEGIN
		PRINT 'Adding translation entry: E1C15BCC-BDE0-4AD3-965E-2EE419329ECA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E1C15BCC-BDE0-4AD3-965E-2EE419329ECA',3240,N'EN',N'Max Output',N'Max Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C59A93D2-7C61-46A1-A546-6D3ECB75062B' )
	BEGIN
		PRINT 'Adding translation entry: C59A93D2-7C61-46A1-A546-6D3ECB75062B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C59A93D2-7C61-46A1-A546-6D3ECB75062B',3240,N'DE',N'Max Output',N'#DE# Max Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '04606640-0A90-4344-A2D2-581885AE7267' )
	BEGIN
		PRINT 'Adding translation entry: 04606640-0A90-4344-A2D2-581885AE7267'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('04606640-0A90-4344-A2D2-581885AE7267',3240,N'RU',N'Max Output',N'#RU# Max Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '418FA390-DE3A-43A1-8E6B-32E8233EC4C8' )
	BEGIN
		PRINT 'Adding translation entry: 418FA390-DE3A-43A1-8E6B-32E8233EC4C8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('418FA390-DE3A-43A1-8E6B-32E8233EC4C8',3240,N'PT',N'Max Output',N'#PT# Max Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '289C2570-0D79-4D80-A854-23532539AE07' )
	BEGIN
		PRINT 'Adding translation entry: 289C2570-0D79-4D80-A854-23532539AE07'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('289C2570-0D79-4D80-A854-23532539AE07',3240,N'ZH',N'Max Output',N'#ZH# Max Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DDE5C6EA-485D-469E-BBB6-3FD1565E2D0D' )
	BEGIN
		PRINT 'Adding translation entry: DDE5C6EA-485D-469E-BBB6-3FD1565E2D0D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DDE5C6EA-485D-469E-BBB6-3FD1565E2D0D',3240,N'JA',N'Max Output',N'#JA# Max Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7B3518DC-02D2-4601-B67C-B421C996E247' )
	BEGIN
		PRINT 'Adding translation entry: 7B3518DC-02D2-4601-B67C-B421C996E247'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7B3518DC-02D2-4601-B67C-B421C996E247',3240,N'FR',N'Max Output',N'#FR# Max Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '15B1758B-5F7B-478B-9386-0A4330F5F756' )
	BEGIN
		PRINT 'Adding translation entry: 15B1758B-5F7B-478B-9386-0A4330F5F756'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('15B1758B-5F7B-478B-9386-0A4330F5F756',3240,N'ES',N'Max Output',N'#ES# Max Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2DE163FB-B815-4AA9-951A-72A2EE31F6C4' )
	BEGIN
		PRINT 'Adding translation entry: 2DE163FB-B815-4AA9-951A-72A2EE31F6C4'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2DE163FB-B815-4AA9-951A-72A2EE31F6C4',3240,N'IT',N'Max Output',N'#IT# Max Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D868E659-43B0-4477-AD4B-69C172D6A77B' )
	BEGIN
		PRINT 'Adding translation entry: D868E659-43B0-4477-AD4B-69C172D6A77B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D868E659-43B0-4477-AD4B-69C172D6A77B',3241,N'EN',N'Min Output',N'Min Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'CA71E6CD-EA79-4BF0-B002-615DCD5234B1' )
	BEGIN
		PRINT 'Adding translation entry: CA71E6CD-EA79-4BF0-B002-615DCD5234B1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('CA71E6CD-EA79-4BF0-B002-615DCD5234B1',3241,N'DE',N'Min Output',N'#DE# Min Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '08193155-73B4-4572-820A-6323FD6AD8F9' )
	BEGIN
		PRINT 'Adding translation entry: 08193155-73B4-4572-820A-6323FD6AD8F9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('08193155-73B4-4572-820A-6323FD6AD8F9',3241,N'RU',N'Min Output',N'#RU# Min Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '4151DC7E-E789-47C4-9067-0B574E30E074' )
	BEGIN
		PRINT 'Adding translation entry: 4151DC7E-E789-47C4-9067-0B574E30E074'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('4151DC7E-E789-47C4-9067-0B574E30E074',3241,N'PT',N'Min Output',N'#PT# Min Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '4FEEECEA-E878-4A12-8A9B-4CA4B5B033E3' )
	BEGIN
		PRINT 'Adding translation entry: 4FEEECEA-E878-4A12-8A9B-4CA4B5B033E3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('4FEEECEA-E878-4A12-8A9B-4CA4B5B033E3',3241,N'ZH',N'Min Output',N'#ZH# Min Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F8DE2BAE-7B7F-43FF-AD73-1F4F8F87AE7C' )
	BEGIN
		PRINT 'Adding translation entry: F8DE2BAE-7B7F-43FF-AD73-1F4F8F87AE7C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F8DE2BAE-7B7F-43FF-AD73-1F4F8F87AE7C',3241,N'JA',N'Min Output',N'#JA# Min Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '63B69480-4553-46B8-8292-1389B566A108' )
	BEGIN
		PRINT 'Adding translation entry: 63B69480-4553-46B8-8292-1389B566A108'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('63B69480-4553-46B8-8292-1389B566A108',3241,N'FR',N'Min Output',N'#FR# Min Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B40926BD-FFA0-4CCF-8F0B-8862A633D043' )
	BEGIN
		PRINT 'Adding translation entry: B40926BD-FFA0-4CCF-8F0B-8862A633D043'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B40926BD-FFA0-4CCF-8F0B-8862A633D043',3241,N'ES',N'Min Output',N'#ES# Min Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '26F87435-0544-4A76-A38D-0B44E5B0CFBE' )
	BEGIN
		PRINT 'Adding translation entry: 26F87435-0544-4A76-A38D-0B44E5B0CFBE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('26F87435-0544-4A76-A38D-0B44E5B0CFBE',3241,N'IT',N'Min Output',N'#IT# Min Output',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '0172E8EF-4E06-4ED7-9852-95A493BB9021' )
	BEGIN
		PRINT 'Adding translation entry: 0172E8EF-4E06-4ED7-9852-95A493BB9021'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('0172E8EF-4E06-4ED7-9852-95A493BB9021',3242,N'EN',N'Reading Error Percent',N'Reading Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '24822BFA-8197-4794-B614-EFF8ADC062CE' )
	BEGIN
		PRINT 'Adding translation entry: 24822BFA-8197-4794-B614-EFF8ADC062CE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('24822BFA-8197-4794-B614-EFF8ADC062CE',3242,N'DE',N'Reading Error Percent',N'#DE# Reading Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '819C3552-3D3A-4E40-9BB0-9FC275A25D89' )
	BEGIN
		PRINT 'Adding translation entry: 819C3552-3D3A-4E40-9BB0-9FC275A25D89'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('819C3552-3D3A-4E40-9BB0-9FC275A25D89',3242,N'RU',N'Reading Error Percent',N'#RU# Reading Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F693132F-904E-433B-9CE2-DE0A4B5DB9F0' )
	BEGIN
		PRINT 'Adding translation entry: F693132F-904E-433B-9CE2-DE0A4B5DB9F0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F693132F-904E-433B-9CE2-DE0A4B5DB9F0',3242,N'PT',N'Reading Error Percent',N'#PT# Reading Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '0CD7A6F1-9FAC-43C7-9525-4200ED649BE8' )
	BEGIN
		PRINT 'Adding translation entry: 0CD7A6F1-9FAC-43C7-9525-4200ED649BE8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('0CD7A6F1-9FAC-43C7-9525-4200ED649BE8',3242,N'ZH',N'Reading Error Percent',N'#ZH# Reading Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '300A8FDE-AD89-4111-ABA1-B242196A7C6B' )
	BEGIN
		PRINT 'Adding translation entry: 300A8FDE-AD89-4111-ABA1-B242196A7C6B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('300A8FDE-AD89-4111-ABA1-B242196A7C6B',3242,N'JA',N'Reading Error Percent',N'#JA# Reading Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'BC9DF504-CBED-4E72-8629-5CDE82D8272D' )
	BEGIN
		PRINT 'Adding translation entry: BC9DF504-CBED-4E72-8629-5CDE82D8272D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('BC9DF504-CBED-4E72-8629-5CDE82D8272D',3242,N'FR',N'Reading Error Percent',N'#FR# Reading Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C15FD01B-441B-486B-9F54-646D6733F34C' )
	BEGIN
		PRINT 'Adding translation entry: C15FD01B-441B-486B-9F54-646D6733F34C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C15FD01B-441B-486B-9F54-646D6733F34C',3242,N'ES',N'Reading Error Percent',N'#ES# Reading Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '31D987E8-A069-446A-A0DA-B1333371ECD7' )
	BEGIN
		PRINT 'Adding translation entry: 31D987E8-A069-446A-A0DA-B1333371ECD7'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('31D987E8-A069-446A-A0DA-B1333371ECD7',3242,N'IT',N'Reading Error Percent',N'#IT# Reading Error Percent',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20201207 23:08:07','20201207 23:08:07',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-2756<<--
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE [nContextElementUID] = '2638155C-1927-4D5F-B929-A70099B1D535' AND [lActive] = 0)
	BEGIN
		UPDATE
			[dbo].[ContextElements]
		SET
			[lActive] = -1
		WHERE
			[nContextElementUID] = '2638155C-1927-4D5F-B929-A70099B1D535'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-3349<<--
	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_ProblemReportsWithEx' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_ProblemReportsWithEx]'

		DROP VIEW [dbo].[vw_ProblemReportsWithEx]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[vw_ProblemReportsWithEx]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_ProblemReportsWithEx]'

		EXEC sp_executesql N'
/*****************************************************************************************************************
	vw_ProblemReportsWithEx

	(C) 2021 Fluke Calibration
------------------------------------------------------------------------------------------------------------------
	CHANGE HISTORY
	01/05/2021  MM  Initial Version
*****************************************************************************************************************/
CREATE VIEW [dbo].[vw_ProblemReportsWithEx]
AS
SELECT
	pr.[nProblemReportsUID],
	pr.[nProcedureUID],
	pr.[nTypeProcedureDefaultUID],
	pr.[nTypeUID],
	pr.[nSubmittedByUID],
	pr.[nApprovedByUID],
	pr.[nFacilityUID],
	pr.[nWorkingFacilityUID],
	pr.[nCallSheetUID],
	pr.[cAuthority],
	pr.[cProblemNumber],
	pr.[cReferenceNumber],
	pr.[cEngineer],
	pr.[cArea],
	pr.[cCategory],
	pr.[cProblemType],
	pr.[cStatus],
	pr.[tStatusDate],
	pr.[tIssueDate],
	pr.[tSubmittedDate],
	pr.[tResolvedDate],
	pr.[tClosedDate],
	pr.[mProblem],
	pr.[mLocalResponse],
	pr.[mTechnicalResponse],
	pr.[lSubmitted],
	pr.[lActive],
	pr.[lDeleted],
	pr.[lApproved],
	pr.[lAdded],
	pr.[nAddFacilityUID],
	pr.[nAddUserUID],
	pr.[tAddTime],
	pr.[nUpdateFacilityUID],
	pr.[nUpdateUserUID],
	pr.[tUpdateTime],
	pr.[tMobileTime],
	pr.[tSystemUpdateTime],
	pr.[nImportUID],
	p.[cProcedureName],
	t.[cDescription],
	t.[cModelNumber],
	f1.[cFacilityName] AS [cManufacturer],
	f2.[cFacilityName] AS [cLab],
	f3.[cFacilityName] AS [cOwner],
	f3.[cFacilityNumber] AS [cOwnerNumber],
	u.[cFirstName] + '' '' + u.[cLastName] AS [cName],
	u1.[cFirstName] + '' '' + u1.[cLastName] AS [cApprovedBy],
	cs.[cCallSheetNumber] AS [cWorkOrderNumber],
	cs.[cCertificationNumber],
	cs.[cID] AS [cAssetID],
	cs.[cBarcode] AS [cBarcode],
	cs.[cModelNumber] AS [cAssetModelNumber],
	cs.[cDescription] AS [cAssetDescription],
	cs.[cManufacturer] AS [cAssetManufacturer],
	cs.[cTechnician] AS [cTechnician],
	prx.[cField1],
	prx.[cField2],
	prx.[cField3],
	prx.[cField4],
	prx.[cField5],
	prx.[cField6],
	prx.[cField7],
	prx.[cField8],
	prx.[cField9],
	prx.[cField10],
	prx.[cField11],
	prx.[cField12],
	prx.[cField13],
	prx.[cField14],
	prx.[cField15],
	prx.[cField16],
	prx.[cField17],
	prx.[cField18],
	prx.[cField19],
	prx.[cField20],
	prx.[cField21],
	prx.[cField22],
	prx.[cField23],
	prx.[cField24],
	prx.[cField25],
	prx.[tField1],
	prx.[tField2],
	prx.[tField3],
	prx.[tField4],
	prx.[tField5],
	prx.[tField6],
	prx.[tField7],
	prx.[tField8],
	prx.[tField9],
	prx.[tField10],
	prx.[nField1],
	prx.[nField2],
	prx.[nField3],
	prx.[nField4],
	prx.[nField5],
	prx.[nField6],
	prx.[nField7],
	prx.[nField8],
	prx.[nField9],
	prx.[nField10],
	COALESCE(prx.[lField1], 0) AS [lField1],
	COALESCE(prx.[lField2], 0) AS [lField2],
	COALESCE(prx.[lField3], 0) AS [lField3],
	COALESCE(prx.[lField4], 0) AS [lField4],
	COALESCE(prx.[lField5], 0) AS [lField5],
	COALESCE(prx.[lField6], 0) AS [lField6],
	COALESCE(prx.[lField7], 0) AS [lField7],
	COALESCE(prx.[lField8], 0) AS [lField8],
	COALESCE(prx.[lField9], 0) AS [lField9],
	COALESCE(prx.[lField10], 0) AS [lField10],
	prx.[mField1],
	prx.[mField2],
	prx.[lActive] AS [lPrxActive]
FROM ProblemReports	pr
LEFT JOIN Procedures p ON p.nProcedureUID = pr.nProcedureUID
LEFT JOIN Types t ON t.nTypeUID = pr.nTypeUID
LEFT JOIN Facilities f1 ON f1.nFacilityUID = t.nManufacturerUID
LEFT JOIN Facilities f2 ON f2.nFacilityUID = pr.nWorkingFacilityUID
LEFT JOIN Facilities f3 ON f3.nFacilityUID = pr.nFacilityUID
LEFT JOIN Users u ON u.nUserUID = pr.nSubmittedByUID
LEFT JOIN Users u1 ON u1.nUserUID = pr.nApprovedByUID
LEFT JOIN vw_CallSheets cs ON pr.nCallSheetUID = cs.nCallSheetUID
LEFT JOIN ProblemReportEx prx ON pr.nProblemReportsUID = prx.nProblemReportsUID
WHERE
	pr.lDeleted = 0	'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'A335F482-F04F-4FD9-A785-38057CBE14DB')
	BEGIN
		IF (SELECT cValue FROM [dbo].[ContextElements] WHERE nContextElementUID = 'A335F482-F04F-4FD9-A785-38057CBE14DB') <> 'SELECT strFields, nProblemReportsUID AS [UID] FROM vw_ProblemReportsWithEx strWhere'
		BEGIN
			PRINT N'Updating Context Element'

			UPDATE [dbo].[ContextElements] SET [cValue] = 'SELECT strFields, nProblemReportsUID AS [UID] FROM vw_ProblemReportsWithEx strWhere' WHERE nContextElementUID = 'A335F482-F04F-4FD9-A785-38057CBE14DB'

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '0F81D17C-A708-4C1E-A261-74F703062675')
	BEGIN
		IF (SELECT COALESCE(cValue,'') FROM [dbo].[ContextElements] WHERE nContextElementUID = '0F81D17C-A708-4C1E-A261-74F703062675') <> 'cManufacturer'
		BEGIN
			PRINT N'Updating Context Element'

			UPDATE [dbo].[ContextElements] SET [cValue] = 'cManufacturer' WHERE nContextElementUID = '0F81D17C-A708-4C1E-A261-74F703062675'

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'AE194A85-597A-4CAC-AD41-198C28957C74')
	BEGIN
		IF (SELECT COALESCE(cValue,'') FROM [dbo].[ContextElements] WHERE nContextElementUID = 'AE194A85-597A-4CAC-AD41-198C28957C74') <> 'cLab'
		BEGIN
			PRINT N'Updating Context Element'

			UPDATE [dbo].[ContextElements] SET [cValue] = 'cLab' WHERE nContextElementUID = 'AE194A85-597A-4CAC-AD41-198C28957C74'

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '97A102CA-542E-44E5-A8FB-F30053430A60')
	BEGIN
		IF (SELECT COALESCE(cValue,'') FROM [dbo].[ContextElements] WHERE nContextElementUID = '97A102CA-542E-44E5-A8FB-F30053430A60') <> 'cName'
		BEGIN
			PRINT N'Updating Context Element'

			UPDATE [dbo].[ContextElements] SET [cValue] = 'cName' WHERE nContextElementUID = '97A102CA-542E-44E5-A8FB-F30053430A60'

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '6E10D918-DE07-43CE-BAFA-9984D888723C')
	BEGIN
		IF (SELECT COALESCE(nUCIDataUID,'00000000-0000-0000-0000-000000000000') FROM [dbo].[ContextElements] WHERE nContextElementUID = '6E10D918-DE07-43CE-BAFA-9984D888723C') <> '2F087BE1-0442-403B-9818-F62ADE90E60A'
		BEGIN
			PRINT N'Updating Context Element'

			UPDATE [dbo].[ContextElements] SET [nUCIDataUID] = '2F087BE1-0442-403B-9818-F62ADE90E60A' WHERE nContextElementUID = '6E10D918-DE07-43CE-BAFA-9984D888723C'

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'C35A7431-6A59-4A42-9324-1C3DF12FCA40')
	BEGIN
	    PRINT N'Adding Context Element Link for cAuthority'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('C35A7431-6A59-4A42-9324-1C3DF12FCA40','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','6E10D918-DE07-43CE-BAFA-9984D888723C',N'AND',13,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '59AA276B-3D7F-4ACC-A73B-02F67BFF38E8')
	BEGIN
	    PRINT N'Adding Context Element for cProblemType'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('59AA276B-3D7F-4ACC-A73B-02F67BFF38E8','FE4CA065-670E-461A-A9E8-C1339B3F1E91',N'Field',N'cProblemType',N'Problem Type',115,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '25E7E14B-90EC-46ED-B985-B681A99D8FCD')
	BEGIN
	    PRINT N'Adding Context Element Link for cProblemType'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('25E7E14B-90EC-46ED-B985-B681A99D8FCD','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','59AA276B-3D7F-4ACC-A73B-02F67BFF38E8',N'AND',14,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F54662F7-07AA-4FD8-87B2-D8463345962C')
	BEGIN
	    PRINT N'Adding Context Element for cCategory'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('F54662F7-07AA-4FD8-87B2-D8463345962C','7BD398C8-8EA0-4745-B65A-8E0892BA6B2C',N'Field',N'cCategory',N'Category',115,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'DB9A239B-DB07-424A-AE30-15A82F148B27')
	BEGIN
	    PRINT N'Adding Context Element Link for cCategory'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('DB9A239B-DB07-424A-AE30-15A82F148B27','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','F54662F7-07AA-4FD8-87B2-D8463345962C',N'AND',15,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8A52A3A7-E5BF-4455-BD46-7F87225B973B')
	BEGIN
	    PRINT N'Adding Context Element for cStatus'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8A52A3A7-E5BF-4455-BD46-7F87225B973B','426653ED-AEEA-4323-A236-23128AB033BD',N'Field',N'cStatus',N'Status',100,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '848BB7CC-FF22-45BB-A836-BC8DE3D50E8B')
	BEGIN
	    PRINT N'Adding Context Element Link for cStatus'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('848BB7CC-FF22-45BB-A836-BC8DE3D50E8B','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','8A52A3A7-E5BF-4455-BD46-7F87225B973B',N'AND',16,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'F57736E5-5C55-485C-B90F-6C6A10292941')
	BEGIN
	    PRINT N'Adding Context Element Link for tStatusDate'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('F57736E5-5C55-485C-B90F-6C6A10292941','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','FCE95453-8922-4FA3-AE8C-7FFAF236C0B4',N'AND',17,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '01886982-2B7F-4BE4-9DBE-61D0764AC297')
	BEGIN
	    PRINT N'Adding Context Element for cWorkOrderNumber'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('01886982-2B7F-4BE4-9DBE-61D0764AC297','AC41ED7F-49DB-44B9-8FEF-B6338B41658D',N'Field',N'cWorkOrderNumber',N'Work Order Number',127,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'CDC18626-EFC5-4BA0-859B-C048E631995B')
	BEGIN
	    PRINT N'Adding Context Element Link for cWorkOrderNumber'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('CDC18626-EFC5-4BA0-859B-C048E631995B','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','01886982-2B7F-4BE4-9DBE-61D0764AC297',N'AND',19,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8B9CA129-AE0E-4C3C-8D9C-383DD814C2D0')
	BEGIN
	    PRINT N'Adding Context Element for tIssueDate'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8B9CA129-AE0E-4C3C-8D9C-383DD814C2D0','40A934A8-055E-4534-B6F6-5B0751CAAB8F',N'Field',N'tIssueDate',N'Issue Date',83,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1D966862-CD61-46B4-A153-D5C957BFFBA3')
	BEGIN
	    PRINT N'Adding Context Element Link for tIssueDate'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1D966862-CD61-46B4-A153-D5C957BFFBA3','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','8B9CA129-AE0E-4C3C-8D9C-383DD814C2D0',N'AND',20,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '630B7D43-501F-4180-A8CD-6BA23A2A0992')
	BEGIN
	    PRINT N'Adding Context Element for tResolvedDate'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('630B7D43-501F-4180-A8CD-6BA23A2A0992','3689258F-F959-4605-A257-108FC510DF8B',N'Field',N'tResolvedDate',N'Resolved Date',103,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '811F5EB6-B9DC-4A9A-B140-23385C0DC71B')
	BEGIN
	    PRINT N'Adding Context Element Link for tResolvedDate'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('811F5EB6-B9DC-4A9A-B140-23385C0DC71B','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','630B7D43-501F-4180-A8CD-6BA23A2A0992',N'AND',21,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '17275CA5-B8ED-4CDB-A4CE-916150BCDCD8')
	BEGIN
	    PRINT N'Adding Context Element for cApprovedBy'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('17275CA5-B8ED-4CDB-A4CE-916150BCDCD8','827F7716-3649-4BF8-971F-4D537C2941B9',N'Field',N'cApprovedBy',N'Approved By',96,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '94E32673-52F8-4D20-8574-11103DB8C0D0')
	BEGIN
	    PRINT N'Adding Context Element Link for cApprovedBy'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('94E32673-52F8-4D20-8574-11103DB8C0D0','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','17275CA5-B8ED-4CDB-A4CE-916150BCDCD8',N'AND',22,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '12E9FD6B-152C-47B6-95E9-03A413BF6E8E')
	BEGIN
	    PRINT N'Adding Context Element for lSubmitted'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('12E9FD6B-152C-47B6-95E9-03A413BF6E8E','8304A989-0050-4410-8A02-99F56DE01D09',N'Field',N'lSubmitted',N'Submitted',81,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '99BADD3F-E546-4C68-912A-A83C92DF6780')
	BEGIN
	    PRINT N'Adding Context Element Link for lSubmitted'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('99BADD3F-E546-4C68-912A-A83C92DF6780','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','12E9FD6B-152C-47B6-95E9-03A413BF6E8E',N'AND',23,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'dfe6e3a0-8cee-405e-a293-670f8d31f7a6')
	BEGIN
	    PRINT N'Adding Context Element for cField1'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('dfe6e3a0-8cee-405e-a293-670f8d31f7a6',NULL,N'Field',N'cField1',N'ProblemReportEx.cField1',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5e0e9f1c-ff89-4110-ba53-00fe4bf60d2d')
	BEGIN
	    PRINT N'Adding Context Element Link for cField1'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('5e0e9f1c-ff89-4110-ba53-00fe4bf60d2d','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','dfe6e3a0-8cee-405e-a293-670f8d31f7a6',N'AND',24,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8cdcd54c-072e-4aec-8a12-de022412b0a8')
	BEGIN
	    PRINT N'Adding Context Element for cField2'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8cdcd54c-072e-4aec-8a12-de022412b0a8',NULL,N'Field',N'cField2',N'ProblemReportEx.cField2',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f8d3ce4f-d0d3-492e-b060-adf81af6d676')
	BEGIN
	    PRINT N'Adding Context Element Link for cField2'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f8d3ce4f-d0d3-492e-b060-adf81af6d676','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','8cdcd54c-072e-4aec-8a12-de022412b0a8',N'AND',25,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c7188519-3238-449a-ae83-74ffac5b7b26')
	BEGIN
	    PRINT N'Adding Context Element for cField3'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c7188519-3238-449a-ae83-74ffac5b7b26',NULL,N'Field',N'cField3',N'ProblemReportEx.cField3',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'a836c6ef-0c17-46d5-948b-ac7251105d6f')
	BEGIN
	    PRINT N'Adding Context Element Link for cField3'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('a836c6ef-0c17-46d5-948b-ac7251105d6f','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','c7188519-3238-449a-ae83-74ffac5b7b26',N'AND',26,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ebdebdbb-4c58-4e53-892f-22c9de77ac6e')
	BEGIN
	    PRINT N'Adding Context Element for cField4'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ebdebdbb-4c58-4e53-892f-22c9de77ac6e',NULL,N'Field',N'cField4',N'ProblemReportEx.cField4',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7a2f7aeb-9f1c-4a08-ba69-5540c89d7201')
	BEGIN
	    PRINT N'Adding Context Element Link for cField4'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('7a2f7aeb-9f1c-4a08-ba69-5540c89d7201','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','ebdebdbb-4c58-4e53-892f-22c9de77ac6e',N'AND',27,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '0995354a-cb07-4369-b84d-cccf4a67ea83')
	BEGIN
	    PRINT N'Adding Context Element for cField5'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('0995354a-cb07-4369-b84d-cccf4a67ea83',NULL,N'Field',N'cField5',N'ProblemReportEx.cField5',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '848b9d8e-cb24-4b86-870f-2572c0c66e4d')
	BEGIN
	    PRINT N'Adding Context Element Link for cField5'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('848b9d8e-cb24-4b86-870f-2572c0c66e4d','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','0995354a-cb07-4369-b84d-cccf4a67ea83',N'AND',28,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8c62fdda-ce77-458c-ae65-81507be3bf35')
	BEGIN
	    PRINT N'Adding Context Element for cField6'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8c62fdda-ce77-458c-ae65-81507be3bf35',NULL,N'Field',N'cField6',N'ProblemReportEx.cField6',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '290fb25a-2c41-47db-a54d-d9e547af3051')
	BEGIN
	    PRINT N'Adding Context Element Link for cField6'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('290fb25a-2c41-47db-a54d-d9e547af3051','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','8c62fdda-ce77-458c-ae65-81507be3bf35',N'AND',29,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '3f6aabfa-e816-408c-a2fa-e1990077900d')
	BEGIN
	    PRINT N'Adding Context Element for cField7'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('3f6aabfa-e816-408c-a2fa-e1990077900d',NULL,N'Field',N'cField7',N'ProblemReportEx.cField7',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'be3f0419-b022-4018-99ff-544b7ba90c4b')
	BEGIN
	    PRINT N'Adding Context Element Link for cField7'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('be3f0419-b022-4018-99ff-544b7ba90c4b','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','3f6aabfa-e816-408c-a2fa-e1990077900d',N'AND',30,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a6fb20e3-dbfb-479c-9b34-8b3611725713')
	BEGIN
	    PRINT N'Adding Context Element for cField8'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a6fb20e3-dbfb-479c-9b34-8b3611725713',NULL,N'Field',N'cField8',N'ProblemReportEx.cField8',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '837f276b-f19b-4ba7-9a67-4e668c675c82')
	BEGIN
	    PRINT N'Adding Context Element Link for cField8'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('837f276b-f19b-4ba7-9a67-4e668c675c82','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','a6fb20e3-dbfb-479c-9b34-8b3611725713',N'AND',31,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'e97608f1-28e3-46b5-a634-f571d8cc7d46')
	BEGIN
	    PRINT N'Adding Context Element for cField9'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('e97608f1-28e3-46b5-a634-f571d8cc7d46',NULL,N'Field',N'cField9',N'ProblemReportEx.cField9',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8d3c2bfa-ff7c-49bb-b4a1-a163c0dbe7a3')
	BEGIN
	    PRINT N'Adding Context Element Link for cField9'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('8d3c2bfa-ff7c-49bb-b4a1-a163c0dbe7a3','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','e97608f1-28e3-46b5-a634-f571d8cc7d46',N'AND',32,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'd480971e-c2d2-4b65-9c7b-e9c51668ce41')
	BEGIN
	    PRINT N'Adding Context Element for cField10'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('d480971e-c2d2-4b65-9c7b-e9c51668ce41',NULL,N'Field',N'cField10',N'ProblemReportEx.cField10',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8c8b83e6-195c-47e2-af17-11c7269c1668')
	BEGIN
	    PRINT N'Adding Context Element Link for cField10'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('8c8b83e6-195c-47e2-af17-11c7269c1668','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','d480971e-c2d2-4b65-9c7b-e9c51668ce41',N'AND',33,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '246f0583-f0db-4de6-abf8-f75525368ba0')
	BEGIN
	    PRINT N'Adding Context Element for cField11'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('246f0583-f0db-4de6-abf8-f75525368ba0',NULL,N'Field',N'cField11',N'ProblemReportEx.cField11',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1b0e45fe-8d48-4d92-90e8-90749cbe1fd9')
	BEGIN
	    PRINT N'Adding Context Element Link for cField11'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1b0e45fe-8d48-4d92-90e8-90749cbe1fd9','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','246f0583-f0db-4de6-abf8-f75525368ba0',N'AND',34,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '25ba3941-ccb1-4eb7-a4f6-d8c8af71b60c')
	BEGIN
	    PRINT N'Adding Context Element for cField12'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('25ba3941-ccb1-4eb7-a4f6-d8c8af71b60c',NULL,N'Field',N'cField12',N'ProblemReportEx.cField12',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'fbd137c4-417e-4974-96f5-5316a4897500')
	BEGIN
	    PRINT N'Adding Context Element Link for cField12'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('fbd137c4-417e-4974-96f5-5316a4897500','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','25ba3941-ccb1-4eb7-a4f6-d8c8af71b60c',N'AND',35,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '2614ca7c-e1a6-4fd8-8d40-2fbfe3f6dd51')
	BEGIN
	    PRINT N'Adding Context Element for cField13'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('2614ca7c-e1a6-4fd8-8d40-2fbfe3f6dd51',NULL,N'Field',N'cField13',N'ProblemReportEx.cField13',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'a4477659-c171-4735-a657-d56354dba608')
	BEGIN
	    PRINT N'Adding Context Element Link for cField13'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('a4477659-c171-4735-a657-d56354dba608','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','2614ca7c-e1a6-4fd8-8d40-2fbfe3f6dd51',N'AND',36,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7d873e54-d2a5-437a-a13d-08c1e8ff0ca9')
	BEGIN
	    PRINT N'Adding Context Element for cField14'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('7d873e54-d2a5-437a-a13d-08c1e8ff0ca9',NULL,N'Field',N'cField14',N'ProblemReportEx.cField14',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'ff658af2-c9fc-4ca3-9b00-f249f2eb7117')
	BEGIN
	    PRINT N'Adding Context Element Link for cField14'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('ff658af2-c9fc-4ca3-9b00-f249f2eb7117','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','7d873e54-d2a5-437a-a13d-08c1e8ff0ca9',N'AND',37,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a1798051-a027-4472-9c38-15b1ac5930c5')
	BEGIN
	    PRINT N'Adding Context Element for cField15'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a1798051-a027-4472-9c38-15b1ac5930c5',NULL,N'Field',N'cField15',N'ProblemReportEx.cField15',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'e125e246-b04d-4e24-9db2-edd8a8824bc2')
	BEGIN
	    PRINT N'Adding Context Element Link for cField15'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('e125e246-b04d-4e24-9db2-edd8a8824bc2','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','a1798051-a027-4472-9c38-15b1ac5930c5',N'AND',38,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '170b2eb9-f306-4c72-85b5-0addbd69693e')
	BEGIN
	    PRINT N'Adding Context Element for cField16'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('170b2eb9-f306-4c72-85b5-0addbd69693e',NULL,N'Field',N'cField16',N'ProblemReportEx.cField16',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'c33879ff-9ef6-484d-bbaf-0a4b6b4e3d7f')
	BEGIN
	    PRINT N'Adding Context Element Link for cField16'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('c33879ff-9ef6-484d-bbaf-0a4b6b4e3d7f','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','170b2eb9-f306-4c72-85b5-0addbd69693e',N'AND',39,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '1b0b70bd-22cc-4fec-bc20-5cba2065bf92')
	BEGIN
	    PRINT N'Adding Context Element for cField17'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('1b0b70bd-22cc-4fec-bc20-5cba2065bf92',NULL,N'Field',N'cField17',N'ProblemReportEx.cField17',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7585b9db-6624-44de-97c6-1c4ea4588058')
	BEGIN
	    PRINT N'Adding Context Element Link for cField17'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('7585b9db-6624-44de-97c6-1c4ea4588058','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','1b0b70bd-22cc-4fec-bc20-5cba2065bf92',N'AND',40,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'cbc018d8-defc-4c0b-b1dd-98067e53a9ff')
	BEGIN
	    PRINT N'Adding Context Element for cField18'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('cbc018d8-defc-4c0b-b1dd-98067e53a9ff',NULL,N'Field',N'cField18',N'ProblemReportEx.cField18',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '233d23e5-db88-4905-b16d-15bdd40fd8e9')
	BEGIN
	    PRINT N'Adding Context Element Link for cField18'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('233d23e5-db88-4905-b16d-15bdd40fd8e9','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','cbc018d8-defc-4c0b-b1dd-98067e53a9ff',N'AND',41,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'bffb85bf-c226-4432-8204-95fa74c760bb')
	BEGIN
	    PRINT N'Adding Context Element for cField19'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('bffb85bf-c226-4432-8204-95fa74c760bb',NULL,N'Field',N'cField19',N'ProblemReportEx.cField19',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '3f698dac-863c-41f5-9fce-e42d6e21f4e6')
	BEGIN
	    PRINT N'Adding Context Element Link for cField19'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('3f698dac-863c-41f5-9fce-e42d6e21f4e6','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','bffb85bf-c226-4432-8204-95fa74c760bb',N'AND',42,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '57cde00a-10b7-4fc4-8ef7-9ee4c8e845af')
	BEGIN
	    PRINT N'Adding Context Element for cField20'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('57cde00a-10b7-4fc4-8ef7-9ee4c8e845af',NULL,N'Field',N'cField20',N'ProblemReportEx.cField20',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '61d453c0-7b46-416b-a552-22291176b0f6')
	BEGIN
	    PRINT N'Adding Context Element Link for cField20'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('61d453c0-7b46-416b-a552-22291176b0f6','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','57cde00a-10b7-4fc4-8ef7-9ee4c8e845af',N'AND',43,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7fda277a-e829-4f77-8374-ae548b895878')
	BEGIN
	    PRINT N'Adding Context Element for cField21'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('7fda277a-e829-4f77-8374-ae548b895878',NULL,N'Field',N'cField21',N'ProblemReportEx.cField21',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'ecc93eca-4fc5-4e02-9655-2e0b41ee30bf')
	BEGIN
	    PRINT N'Adding Context Element Link for cField21'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('ecc93eca-4fc5-4e02-9655-2e0b41ee30bf','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','7fda277a-e829-4f77-8374-ae548b895878',N'AND',44,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '179550f8-6bf8-4803-bbfc-3290798aa42a')
	BEGIN
	    PRINT N'Adding Context Element for cField22'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('179550f8-6bf8-4803-bbfc-3290798aa42a',NULL,N'Field',N'cField22',N'ProblemReportEx.cField22',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'e6c5dc0f-1d40-4b7d-a176-42923c47b509')
	BEGIN
	    PRINT N'Adding Context Element Link for cField22'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('e6c5dc0f-1d40-4b7d-a176-42923c47b509','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','179550f8-6bf8-4803-bbfc-3290798aa42a',N'AND',45,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'edca15bd-923a-44ed-a705-6f41ea54465c')
	BEGIN
	    PRINT N'Adding Context Element for cField23'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('edca15bd-923a-44ed-a705-6f41ea54465c',NULL,N'Field',N'cField23',N'ProblemReportEx.cField23',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '27ff920a-9c31-4096-b01d-eafed4f0cf77')
	BEGIN
	    PRINT N'Adding Context Element Link for cField23'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('27ff920a-9c31-4096-b01d-eafed4f0cf77','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','edca15bd-923a-44ed-a705-6f41ea54465c',N'AND',46,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ff345e8a-3d9e-4a2c-9dfd-7b8c4daa82ad')
	BEGIN
	    PRINT N'Adding Context Element for cField24'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ff345e8a-3d9e-4a2c-9dfd-7b8c4daa82ad',NULL,N'Field',N'cField24',N'ProblemReportEx.cField24',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7e29fd65-a5e2-4f44-bba4-deebcfc338c2')
	BEGIN
	    PRINT N'Adding Context Element Link for cField24'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('7e29fd65-a5e2-4f44-bba4-deebcfc338c2','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','ff345e8a-3d9e-4a2c-9dfd-7b8c4daa82ad',N'AND',47,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7ed30f16-dcf3-498d-8bfc-8be3ee77c8f0')
	BEGIN
	    PRINT N'Adding Context Element for cField25'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('7ed30f16-dcf3-498d-8bfc-8be3ee77c8f0',NULL,N'Field',N'cField25',N'ProblemReportEx.cField25',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '667bf4a7-178e-4105-93d7-d7ccb135f0c7')
	BEGIN
	    PRINT N'Adding Context Element Link for cField25'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('667bf4a7-178e-4105-93d7-d7ccb135f0c7','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','7ed30f16-dcf3-498d-8bfc-8be3ee77c8f0',N'AND',48,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4241e5bc-9e03-4346-89dd-5a5861c97bb2')
	BEGIN
	    PRINT N'Adding Context Element for tField1'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('4241e5bc-9e03-4346-89dd-5a5861c97bb2',NULL,N'Field',N'tField1',N'ProblemReportEx.tField1',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f4f496e8-f8f0-4a7d-bb41-d7bb0d0e6167')
	BEGIN
	    PRINT N'Adding Context Element Link for tField1'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f4f496e8-f8f0-4a7d-bb41-d7bb0d0e6167','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','4241e5bc-9e03-4346-89dd-5a5861c97bb2',N'AND',49,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'b5d89887-fd16-4ba4-b145-5742f8bc0743')
	BEGIN
	    PRINT N'Adding Context Element for tField2'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('b5d89887-fd16-4ba4-b145-5742f8bc0743',NULL,N'Field',N'tField2',N'ProblemReportEx.tField2',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'e8e66a51-b352-45ca-9668-96eeecfdd483')
	BEGIN
	    PRINT N'Adding Context Element Link for tField2'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('e8e66a51-b352-45ca-9668-96eeecfdd483','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','b5d89887-fd16-4ba4-b145-5742f8bc0743',N'AND',50,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '0865260f-7661-4de7-b9d5-e3351fab286b')
	BEGIN
	    PRINT N'Adding Context Element for tField3'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('0865260f-7661-4de7-b9d5-e3351fab286b',NULL,N'Field',N'tField3',N'ProblemReportEx.tField3',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'd59b3e32-8aec-4bb1-96de-7964644c594b')
	BEGIN
	    PRINT N'Adding Context Element Link for tField3'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('d59b3e32-8aec-4bb1-96de-7964644c594b','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','0865260f-7661-4de7-b9d5-e3351fab286b',N'AND',51,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '55101bfb-f793-47ec-a8c3-26798d64c184')
	BEGIN
	    PRINT N'Adding Context Element for tField4'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('55101bfb-f793-47ec-a8c3-26798d64c184',NULL,N'Field',N'tField4',N'ProblemReportEx.tField4',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '346e8293-d7e4-460a-b507-896fe9b11667')
	BEGIN
	    PRINT N'Adding Context Element Link for tField4'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('346e8293-d7e4-460a-b507-896fe9b11667','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','55101bfb-f793-47ec-a8c3-26798d64c184',N'AND',52,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '39d0e48e-ae61-409b-9d3b-0f0a24645ced')
	BEGIN
	    PRINT N'Adding Context Element for tField5'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('39d0e48e-ae61-409b-9d3b-0f0a24645ced',NULL,N'Field',N'tField5',N'ProblemReportEx.tField5',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '72271b19-b830-440d-9e17-b344a9248b9e')
	BEGIN
	    PRINT N'Adding Context Element Link for tField5'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('72271b19-b830-440d-9e17-b344a9248b9e','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','39d0e48e-ae61-409b-9d3b-0f0a24645ced',N'AND',53,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4e6fcb3f-efc2-4fee-8114-23933c1c0cb0')
	BEGIN
	    PRINT N'Adding Context Element for tField6'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('4e6fcb3f-efc2-4fee-8114-23933c1c0cb0',NULL,N'Field',N'tField6',N'ProblemReportEx.tField6',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8f38f3a7-fbf0-47b1-9017-470ccb5cb552')
	BEGIN
	    PRINT N'Adding Context Element Link for tField6'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('8f38f3a7-fbf0-47b1-9017-470ccb5cb552','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','4e6fcb3f-efc2-4fee-8114-23933c1c0cb0',N'AND',54,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'f178b01a-e28c-41af-ae6f-0151b6d7dbdd')
	BEGIN
	    PRINT N'Adding Context Element for tField7'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('f178b01a-e28c-41af-ae6f-0151b6d7dbdd',NULL,N'Field',N'tField7',N'ProblemReportEx.tField7',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '91d3b45e-9f2c-4584-8db0-1fd73dfb88c3')
	BEGIN
	    PRINT N'Adding Context Element Link for tField7'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('91d3b45e-9f2c-4584-8db0-1fd73dfb88c3','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','f178b01a-e28c-41af-ae6f-0151b6d7dbdd',N'AND',55,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'e287727f-20c9-4dad-b1d8-6cccc32912c1')
	BEGIN
	    PRINT N'Adding Context Element for tField8'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('e287727f-20c9-4dad-b1d8-6cccc32912c1',NULL,N'Field',N'tField8',N'ProblemReportEx.tField8',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5b098eab-81a6-410a-a7e2-e11517d3ead6')
	BEGIN
	    PRINT N'Adding Context Element Link for tField8'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('5b098eab-81a6-410a-a7e2-e11517d3ead6','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','e287727f-20c9-4dad-b1d8-6cccc32912c1',N'AND',56,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'db7b85d7-5481-4c15-9dac-f891cb7a6f09')
	BEGIN
	    PRINT N'Adding Context Element for tField9'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('db7b85d7-5481-4c15-9dac-f891cb7a6f09',NULL,N'Field',N'tField9',N'ProblemReportEx.tField9',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '63420052-5fa8-44f0-baa6-0988e537c601')
	BEGIN
	    PRINT N'Adding Context Element Link for tField9'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('63420052-5fa8-44f0-baa6-0988e537c601','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','db7b85d7-5481-4c15-9dac-f891cb7a6f09',N'AND',57,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7f317b73-be9b-4138-825e-e5a7410a48c3')
	BEGIN
	    PRINT N'Adding Context Element for tField10'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('7f317b73-be9b-4138-825e-e5a7410a48c3',NULL,N'Field',N'tField10',N'ProblemReportEx.tField10',69,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'd067d00e-3d5b-40e2-bf0d-f523d6b4b418')
	BEGIN
	    PRINT N'Adding Context Element Link for tField10'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('d067d00e-3d5b-40e2-bf0d-f523d6b4b418','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','7f317b73-be9b-4138-825e-e5a7410a48c3',N'AND',58,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'fa26bbe5-936a-4b15-b78c-9038ec8475d6')
	BEGIN
	    PRINT N'Adding Context Element for nField1'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('fa26bbe5-936a-4b15-b78c-9038ec8475d6',NULL,N'Field',N'nField1',N'ProblemReportEx.nField1',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8d932ae5-f6b3-4d72-8d43-104eeb0495dc')
	BEGIN
	    PRINT N'Adding Context Element Link for nField1'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('8d932ae5-f6b3-4d72-8d43-104eeb0495dc','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','fa26bbe5-936a-4b15-b78c-9038ec8475d6',N'AND',59,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8bab557f-29ac-4240-af1f-13979dec3df2')
	BEGIN
	    PRINT N'Adding Context Element for nField2'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8bab557f-29ac-4240-af1f-13979dec3df2',NULL,N'Field',N'nField2',N'ProblemReportEx.nField2',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '3c1b2e9a-8e9d-41be-b057-1dc368db6cf0')
	BEGIN
	    PRINT N'Adding Context Element Link for nField2'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('3c1b2e9a-8e9d-41be-b057-1dc368db6cf0','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','8bab557f-29ac-4240-af1f-13979dec3df2',N'AND',60,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a3de745f-6cd7-4fd0-ae68-3c46d88dcf9c')
	BEGIN
	    PRINT N'Adding Context Element for nField3'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a3de745f-6cd7-4fd0-ae68-3c46d88dcf9c',NULL,N'Field',N'nField3',N'ProblemReportEx.nField3',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '923a7383-119d-4303-8d18-e1b3362f5b64')
	BEGIN
	    PRINT N'Adding Context Element Link for nField3'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('923a7383-119d-4303-8d18-e1b3362f5b64','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','a3de745f-6cd7-4fd0-ae68-3c46d88dcf9c',N'AND',61,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '0bcfd0ab-c2ba-4f10-8b8c-17aea9c4a484')
	BEGIN
	    PRINT N'Adding Context Element for nField4'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('0bcfd0ab-c2ba-4f10-8b8c-17aea9c4a484',NULL,N'Field',N'nField4',N'ProblemReportEx.nField4',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'aafed025-3bbf-4265-a642-ac516ea027e8')
	BEGIN
	    PRINT N'Adding Context Element Link for nField4'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('aafed025-3bbf-4265-a642-ac516ea027e8','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','0bcfd0ab-c2ba-4f10-8b8c-17aea9c4a484',N'AND',62,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '52046200-9c80-41fe-aab8-7159b3e36ba7')
	BEGIN
	    PRINT N'Adding Context Element for nField5'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('52046200-9c80-41fe-aab8-7159b3e36ba7',NULL,N'Field',N'nField5',N'ProblemReportEx.nField5',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6a77750b-1fa9-4ad5-a040-b8896bd4ea3a')
	BEGIN
	    PRINT N'Adding Context Element Link for nField5'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('6a77750b-1fa9-4ad5-a040-b8896bd4ea3a','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','52046200-9c80-41fe-aab8-7159b3e36ba7',N'AND',63,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'f87a84e3-255d-4e00-a0f7-fdce2980aad1')
	BEGIN
	    PRINT N'Adding Context Element for nField6'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('f87a84e3-255d-4e00-a0f7-fdce2980aad1',NULL,N'Field',N'nField6',N'ProblemReportEx.nField6',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f21b52b7-055d-444d-84de-1af85dfeb69e')
	BEGIN
	    PRINT N'Adding Context Element Link for nField6'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f21b52b7-055d-444d-84de-1af85dfeb69e','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','f87a84e3-255d-4e00-a0f7-fdce2980aad1',N'AND',64,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8da54186-be85-4bee-b965-b616d119758e')
	BEGIN
	    PRINT N'Adding Context Element for nField7'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8da54186-be85-4bee-b965-b616d119758e',NULL,N'Field',N'nField7',N'ProblemReportEx.nField7',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'c29d4fa1-90c8-4cef-9649-9ddf758a2cd6')
	BEGIN
	    PRINT N'Adding Context Element Link for nField7'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('c29d4fa1-90c8-4cef-9649-9ddf758a2cd6','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','8da54186-be85-4bee-b965-b616d119758e',N'AND',65,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '39a6c5d9-e5b9-4d1a-bcd9-9000c4984c5d')
	BEGIN
	    PRINT N'Adding Context Element for nField8'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('39a6c5d9-e5b9-4d1a-bcd9-9000c4984c5d',NULL,N'Field',N'nField8',N'ProblemReportEx.nField8',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'e88e6afa-7efc-48f9-953d-1b41d1d4dac3')
	BEGIN
	    PRINT N'Adding Context Element Link for nField8'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('e88e6afa-7efc-48f9-953d-1b41d1d4dac3','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','39a6c5d9-e5b9-4d1a-bcd9-9000c4984c5d',N'AND',66,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '6e9e49c2-e1d6-4c13-8601-b81378821b27')
	BEGIN
	    PRINT N'Adding Context Element for nField9'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('6e9e49c2-e1d6-4c13-8601-b81378821b27',NULL,N'Field',N'nField9',N'ProblemReportEx.nField9',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5e3cd959-dc78-4c53-bc7d-c6c487acffe1')
	BEGIN
	    PRINT N'Adding Context Element Link for nField9'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('5e3cd959-dc78-4c53-bc7d-c6c487acffe1','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','6e9e49c2-e1d6-4c13-8601-b81378821b27',N'AND',67,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '27c6659e-9a8b-4e2c-b34b-7e312768aac0')
	BEGIN
	    PRINT N'Adding Context Element for nField10'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('27c6659e-9a8b-4e2c-b34b-7e312768aac0',NULL,N'Field',N'nField10',N'ProblemReportEx.nField10',72,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'cf5441c4-c341-43f5-86cb-7b9b1b9c0f6f')
	BEGIN
	    PRINT N'Adding Context Element Link for nField10'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('cf5441c4-c341-43f5-86cb-7b9b1b9c0f6f','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','27c6659e-9a8b-4e2c-b34b-7e312768aac0',N'AND',68,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '91d6225b-dd45-4439-b325-f522af04165e')
	BEGIN
	    PRINT N'Adding Context Element for lField1'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('91d6225b-dd45-4439-b325-f522af04165e',NULL,N'Field',N'lField1',N'ProblemReportEx.lField1',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '87646058-7e04-43ac-b412-463d41ad0385')
	BEGIN
	    PRINT N'Adding Context Element Link for lField1'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('87646058-7e04-43ac-b412-463d41ad0385','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','91d6225b-dd45-4439-b325-f522af04165e',N'AND',69,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '96fde084-5db9-4206-8671-6d5876cf1955')
	BEGIN
	    PRINT N'Adding Context Element for lField2'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('96fde084-5db9-4206-8671-6d5876cf1955',NULL,N'Field',N'lField2',N'ProblemReportEx.lField2',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '3fc07e23-2478-4279-9ae7-e5fc7740a569')
	BEGIN
	    PRINT N'Adding Context Element Link for lField2'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('3fc07e23-2478-4279-9ae7-e5fc7740a569','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','96fde084-5db9-4206-8671-6d5876cf1955',N'AND',70,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '456ab8d3-3894-4d4d-863a-5c2755a015d9')
	BEGIN
	    PRINT N'Adding Context Element for lField3'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('456ab8d3-3894-4d4d-863a-5c2755a015d9',NULL,N'Field',N'lField3',N'ProblemReportEx.lField3',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4bcf9bd0-863e-48ff-8db2-cb13ae4af92c')
	BEGIN
	    PRINT N'Adding Context Element Link for lField3'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('4bcf9bd0-863e-48ff-8db2-cb13ae4af92c','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','456ab8d3-3894-4d4d-863a-5c2755a015d9',N'AND',71,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '2bce09d4-13ab-4750-b6c0-09dc4821097f')
	BEGIN
	    PRINT N'Adding Context Element for lField4'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('2bce09d4-13ab-4750-b6c0-09dc4821097f',NULL,N'Field',N'lField4',N'ProblemReportEx.lField4',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f2b79483-75a9-4a44-8844-996adaa73ca6')
	BEGIN
	    PRINT N'Adding Context Element Link for lField4'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f2b79483-75a9-4a44-8844-996adaa73ca6','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','2bce09d4-13ab-4750-b6c0-09dc4821097f',N'AND',72,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '335828b5-efd5-40c6-850c-9234b72bd50f')
	BEGIN
	    PRINT N'Adding Context Element for lField5'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('335828b5-efd5-40c6-850c-9234b72bd50f',NULL,N'Field',N'lField5',N'ProblemReportEx.lField5',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '00b11d67-e860-4a63-9182-aa84551f043c')
	BEGIN
	    PRINT N'Adding Context Element Link for lField5'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('00b11d67-e860-4a63-9182-aa84551f043c','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','335828b5-efd5-40c6-850c-9234b72bd50f',N'AND',73,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '441937a5-35d9-4a8a-988f-4ab465c82989')
	BEGIN
	    PRINT N'Adding Context Element for lField6'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('441937a5-35d9-4a8a-988f-4ab465c82989',NULL,N'Field',N'lField6',N'ProblemReportEx.lField6',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7d728ff5-f952-4f71-85a5-07b0d6f1539b')
	BEGIN
	    PRINT N'Adding Context Element Link for lField6'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('7d728ff5-f952-4f71-85a5-07b0d6f1539b','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','441937a5-35d9-4a8a-988f-4ab465c82989',N'AND',74,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '13aa3724-7651-4f1d-b37a-4abca124c838')
	BEGIN
	    PRINT N'Adding Context Element for lField7'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('13aa3724-7651-4f1d-b37a-4abca124c838',NULL,N'Field',N'lField7',N'ProblemReportEx.lField7',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5f13e767-7be9-4264-bb97-819f2a00b607')
	BEGIN
	    PRINT N'Adding Context Element Link for lField7'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('5f13e767-7be9-4264-bb97-819f2a00b607','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','13aa3724-7651-4f1d-b37a-4abca124c838',N'AND',75,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'bd0640f2-8cda-43ff-9798-186a750644ce')
	BEGIN
	    PRINT N'Adding Context Element for lField8'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('bd0640f2-8cda-43ff-9798-186a750644ce',NULL,N'Field',N'lField8',N'ProblemReportEx.lField8',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f9bffe6c-2663-40d4-a996-99e68d9a2221')
	BEGIN
	    PRINT N'Adding Context Element Link for lField8'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f9bffe6c-2663-40d4-a996-99e68d9a2221','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','bd0640f2-8cda-43ff-9798-186a750644ce',N'AND',76,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'b464541d-7e5c-40b6-9202-b3dbcf2e7b2b')
	BEGIN
	    PRINT N'Adding Context Element for lField9'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('b464541d-7e5c-40b6-9202-b3dbcf2e7b2b',NULL,N'Field',N'lField9',N'ProblemReportEx.lField9',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'a661fdf7-1920-47e6-a715-b7d3240aa9a0')
	BEGIN
	    PRINT N'Adding Context Element Link for lField9'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('a661fdf7-1920-47e6-a715-b7d3240aa9a0','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','b464541d-7e5c-40b6-9202-b3dbcf2e7b2b',N'AND',77,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '5464d2e3-96a6-452f-beac-4608e4d9f099')
	BEGIN
	    PRINT N'Adding Context Element for lField10'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('5464d2e3-96a6-452f-beac-4608e4d9f099',NULL,N'Field',N'lField10',N'ProblemReportEx.lField10',68,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'b45f7365-575a-464f-8efb-8b1198e8e668')
	BEGIN
	    PRINT N'Adding Context Element Link for lField10'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('b45f7365-575a-464f-8efb-8b1198e8e668','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','5464d2e3-96a6-452f-beac-4608e4d9f099',N'AND',78,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8626fb32-df7d-4ab3-9d10-f286c1fa863a')
	BEGIN
	    PRINT N'Adding Context Element for mField1'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8626fb32-df7d-4ab3-9d10-f286c1fa863a',NULL,N'Field',N'mField1',N'ProblemReportEx.mField1',68,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'd32b436a-231b-4703-8184-a5e670eb279e')
	BEGIN
	    PRINT N'Adding Context Element Link for mField1'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('d32b436a-231b-4703-8184-a5e670eb279e','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','8626fb32-df7d-4ab3-9d10-f286c1fa863a',N'AND',79,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '88ca2315-5ad8-4b84-a580-ecbdbdf77a5d')
	BEGIN
	    PRINT N'Adding Context Element for mField2'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('88ca2315-5ad8-4b84-a580-ecbdbdf77a5d',NULL,N'Field',N'mField2',N'ProblemReportEx.mField2',68,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8838d2c8-3c1a-4c03-b379-d4448b61d170')
	BEGIN
	    PRINT N'Adding Context Element Link for mField2'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('8838d2c8-3c1a-4c03-b379-d4448b61d170','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','88ca2315-5ad8-4b84-a580-ecbdbdf77a5d',N'AND',80,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210105 22:48:47.000','20210105 22:48:47.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


    -->>MTM-3340<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '046938DC-E95A-4521-A680-553D57852627' )
	BEGIN
		PRINT 'Adding translation entry: 046938DC-E95A-4521-A680-553D57852627'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('046938DC-E95A-4521-A680-553D57852627',3243,N'EN',N'DELETE_DATASHEET_CONFIRM',N'Warning! Are you sure you want to delete the selected Data Sheet?',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','20210127 22:37:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '3F7F65D7-5E74-423E-B20C-B5D9AD5A6173' )
	BEGIN
		PRINT 'Adding translation entry: 3F7F65D7-5E74-423E-B20C-B5D9AD5A6173'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3F7F65D7-5E74-423E-B20C-B5D9AD5A6173',3243,N'DE',N'DELETE_DATASHEET_CONFIRM',N'#DE# Warning! Are you sure you want to delete the selected Data Sheet?',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','20210127 22:37:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '0D4A03ED-4758-47C2-BE8C-1D5D2BD54936' )
	BEGIN
		PRINT 'Adding translation entry: 0D4A03ED-4758-47C2-BE8C-1D5D2BD54936'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('0D4A03ED-4758-47C2-BE8C-1D5D2BD54936',3243,N'RU',N'DELETE_DATASHEET_CONFIRM',N'#RU# Warning! Are you sure you want to delete the selected Data Sheet?',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','20210127 22:37:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F0EC54C8-5D12-424C-9288-7D6E63B46611' )
	BEGIN
		PRINT 'Adding translation entry: F0EC54C8-5D12-424C-9288-7D6E63B46611'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F0EC54C8-5D12-424C-9288-7D6E63B46611',3243,N'PT',N'DELETE_DATASHEET_CONFIRM',N'#PT# Warning! Are you sure you want to delete the selected Data Sheet?',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','20210127 22:37:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5D027AB9-7854-4267-8BE3-2C6B4958BEA5' )
	BEGIN
		PRINT 'Adding translation entry: 5D027AB9-7854-4267-8BE3-2C6B4958BEA5'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5D027AB9-7854-4267-8BE3-2C6B4958BEA5',3243,N'ZH',N'DELETE_DATASHEET_CONFIRM',N'#ZH# Warning! Are you sure you want to delete the selected Data Sheet?',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','20210127 22:37:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'CAEBB565-91DB-4DA0-8BAC-D51F1E8D0281' )
	BEGIN
		PRINT 'Adding translation entry: CAEBB565-91DB-4DA0-8BAC-D51F1E8D0281'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('CAEBB565-91DB-4DA0-8BAC-D51F1E8D0281',3243,N'JA',N'DELETE_DATASHEET_CONFIRM',N'#JA# Warning! Are you sure you want to delete the selected Data Sheet?',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','20210127 22:37:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '671336B8-6C80-4FDD-8693-E12314B3D3F0' )
	BEGIN
		PRINT 'Adding translation entry: 671336B8-6C80-4FDD-8693-E12314B3D3F0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('671336B8-6C80-4FDD-8693-E12314B3D3F0',3243,N'FR',N'DELETE_DATASHEET_CONFIRM',N'#FR# Warning! Are you sure you want to delete the selected Data Sheet?',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','20210127 22:37:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7087878D-48BA-4BFF-BBDF-FAC181908F70' )
	BEGIN
		PRINT 'Adding translation entry: 7087878D-48BA-4BFF-BBDF-FAC181908F70'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7087878D-48BA-4BFF-BBDF-FAC181908F70',3243,N'ES',N'DELETE_DATASHEET_CONFIRM',N'#ES# Warning! Are you sure you want to delete the selected Data Sheet?',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','20210127 22:37:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F22DDE62-5F58-4D01-B55C-068A9D58F7C9' )
	BEGIN
		PRINT 'Adding translation entry: F22DDE62-5F58-4D01-B55C-068A9D58F7C9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F22DDE62-5F58-4D01-B55C-068A9D58F7C9',3243,N'IT',N'DELETE_DATASHEET_CONFIRM',N'#IT# Warning! Are you sure you want to delete the selected Data Sheet?',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210127 22:37:34','20210127 22:37:34',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


    -->>MTM-3891<<--
	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_CallSheets' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_CallSheets]'

		DROP VIEW [dbo].[vw_CallSheets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[vw_CallSheets]', 'V') IS NULL
		BEGIN
			PRINT N'Creating [dbo].[vw_CallSheets]'

			EXEC sp_executesql N'
/******************************************************************************************************************************************
	vw_CallSheets

	(C) 2003-2021 Fluke Calibration
-------------------------------------------------------------------------------------------------------------------------------------------
	CHANGE HISTORY
	08/04/2003	Added notes section, fixed join for "Returned by" (rusr) to use cs.nReturnedByUID not cs.nQCApprovedByUID
	08/04/2003	Removed join to vw_Assets and added joins necessary to provide functionality.
	09/03/2003	Added ass.cPhysicalLocation to the results returned (needed by iPortal).
	11/13/2003	Updated based on changes to TypeProcedureDefaults (cStandardTimeUOM became nStandardPrice).
	08/23/2004	Added Join to Invoices so we can get Invoice number and date.
	04/28/2005	Modified join to Calendar to exclude deleted records.
	09/27/2005	Added nTypeUID to CallSheets so I modifed query to Join Types on new nTypeUID and return ass.nTypeUID AS [nAssetTypeUID]
	10/24/2005	EdW	Added notes fields Casted as Text to prevent Crystal truncation issue
	11/07/2005	EdW	Added Assets.cPartNumber AS [cAssetPartNumber]
	11-28-2011  JP	Added Owning Lab
	12-09-2011  JP  Added cTemperature UOM, cHumidityUOM, cPressureUOM
	11-08-2013  MM  Added recall rule (cDistrict)
	12-05-2013  MM  COALESCE NULL values in job numbers
	07-21-2014  MM  Fixed casts
	03-04-2015  MM  Added cParentBarcode
	07-14-2015  MM  Removed obsolete columns from Assets table, link to AssetServices
	02-12-2021  MM  Added nManufacturerUID
*******************************************************************************************************************************************/
CREATE VIEW [dbo].[vw_CallSheets]
AS SELECT
	cs.*,
	ass.[cID],
	ass.[cBarcode],
	ass.[cModelNumber],
	ass.[cSerialNumber],
	ass.[cDescription],
	ass.[cPhysicalLocation],
	ass.[nQuantity] AS [nAssetQuantity],
	vas.tNextMaintDate AS [tAssetNextMaintDate],
	vas.[cServiceName] AS [cNextMaintType],
	vas.cInterval AS [cAssetInterval],
	vas.cIntervalUOM AS [cAssetIntervalUOM],
	ass.[nTypeUID] AS [nAssetTypeUID],
	ass.[cPartNumber] AS [cAssetPartNumber],
	asspar.[cID] AS [cParentID],
	asspar.[cBarcode] AS [cParentBarcode],
	facm.[cFacilityName] AS [cManufacturer],
	typ.[cDescription] AS [cTyDescription],
	typ.[cAuthority] AS [cTyAuthority],
	fac.[cFacilityName],
	fac.[cFacilityNumber],
	fac.[cDistrict] AS [RecallRule],
	dep.[cFacilityName] AS [cDepartment],
	dep.[cFacilityNumber] AS [cDepartmentNumber],
	wfc.[cFacilityName] AS [cWorkingFacility],
	wfc.[cFacilityNumber] AS [cWorkingFacilityNumber],
	ofc.[cFacilityName] AS [cOwningLab],
	ofc.[cFacilityNumber] AS [cOwningLabNumber],
	cat.[cDescription] AS [cCategory],
	scat.[cDescription] AS [cSubCategory],
	pro.[cProcedureName],
	pro.[cProcedureNumber],
	pro.[cAuthority],
	tpd.[cInterval] AS [cTypeInterval],
	tpd.[cIntervalUOM] AS [cTypeIntervalUOM],
	tpd.[cMaintenanceType],
	tpd.[nStandardTime],
	tpd.[nStandardPrice],
	tpd.[nProcedureUID] AS [TPDnProcedureUID],
	ausr.[cFirstName] + '' '' + ausr.[cLastName] AS [cAssignedTech],
	usr.[cFirstName] + '' '' + usr.[cLastName] AS [cTechnician],
	QCusr.[cFirstName] + '' '' + QCusr.[cLastName] AS [cQCApprovedBy],
	rusr.[cFirstName] + '' '' + rusr.[cLastName] AS [cReturnedBy],
	sub.[cFacilityName] AS [cSubContractor],
	sub.[cFacilityNumber] AS [cSubContractorNumber],
	COALESCE(job.[cJobOrderNumber],'''') AS [cJobOrderNumber],
	job.[lLevelOfEffort],
	cal.[tTaskDueDate],
	csa.[cFileName],
	inv.[cInvoiceNo],
	inv.[tInvoicedate],
	CAST (cs.[mCallSheetNotes] AS NTEXT) AS [mCallSheetNotesText],
	CAST (cs.[mAccuracyNotes] AS NTEXT) AS [mAccuracyNotesText],
	CAST (cs.[mUncertaintyNotes] AS NTEXT) AS [mUncertaintyNotesText],
	CAST (cs.[mSubContractorNotes] AS NTEXT) AS [mSubContractorNotesText],
	CAST (cs.[mOOTNotes] AS NTEXT) AS [mOOTNotesText],
	CAST (cs.[mStickerNotes] AS NTEXT) AS [mStickerNotesText],
	ass.[nManufacturerUID]
FROM
	CallSheets cs
		INNER JOIN Assets ass ON ass.nAssetUID = cs.nAssetUID
		INNER JOIN Types typ ON cs.nTypeUID = typ.nTypeUID
		INNER JOIN Facilities fac ON cs.nFacilityUID = fac.nFacilityUID
		LEFT OUTER JOIN Facilities dep ON cs.nDepartmentUID = dep.nFacilityUID
		LEFT OUTER JOIN Facilities wfc ON cs.nWorkingFacilityUID = wfc.nFacilityUID
		LEFT OUTER JOIN Facilities ofc ON cs.nOwningLabUID = ofc.nFacilityUID
		LEFT OUTER JOIN Category cat ON cs.nCategoryUID = cat.nCategoryUID
		LEFT OUTER JOIN SubCategory scat ON cs.nSubCategoryUID = scat.nSubCategoryUID
		LEFT OUTER JOIN Procedures pro ON cs.nProcedureUID = pro.nProcedureUID
		LEFT OUTER JOIN TypeProcedureDefaults tpd ON cs.nTypeProcedureDefaultUID = tpd.nTypeProcedureDefaultUID
		LEFT OUTER JOIN Users ausr ON cs.nAssignedTechUID = ausr.nUserUID
		LEFT OUTER JOIN Users usr ON cs.nTechnicianUID = usr.nUserUID
		LEFT OUTER JOIN Users QCusr ON cs.nQCApprovedByUID = QCusr.nUserUID
		LEFT OUTER JOIN Users rusr ON cs.nReturnedByUID = rusr.nUserUID
		LEFT OUTER JOIN Facilities sub ON cs.nSubContractorUID = sub.nFacilityUID
		LEFT OUTER JOIN JobNumbers job ON cs.nJobNumberUID = job.nJobNumberUID
		LEFT OUTER JOIN Calendar cal ON cs.nCalendarUID = cal.nCalendarUID AND cal.lDeleted = 0
		LEFT OUTER JOIN CallSheetAttributes csa ON cs.nCallSheetAttributeUID = csa.nCallSheetAttributeUID
		LEFT OUTER JOIN Assets asspar ON ass.nParentUID = asspar.nAssetUID
		LEFT OUTER JOIN Facilities facm ON ass.nManufacturerUID = facm.nFacilityUID
		LEFT OUTER JOIN Invoices inv ON cs.nInvoiceUID = inv.nInvoiceUID
OUTER APPLY (SELECT TOP 1 tNextMaintDate, cInterval, cIntervalUOM, cServiceName
				FROM vw_AssetsWithServices
				WHERE nAssetUID = ass.[nAssetUID] AND ASV_lActive <> 0 AND ST_lActive <> 0 AND lRecalled <> 0
				ORDER BY ISNULL(tNextMaintDate, DATEADD(YYYY, 500, GETDATE())) ASC) vas
WHERE
	cs.lDeleted = 0
'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-1155<<--
	IF EXISTS (SELECT * FROM [dbo].[Validations] WHERE nValidationUID = 'ce5f16f3-a99d-4829-8e39-a1dd15e4e52b')
	BEGIN
		IF EXISTS (SELECT * FROM [dbo].[Validations] WHERE nValidationUID = 'ce5f16f3-a99d-4829-8e39-a1dd15e4e52b' AND cCode = N'// **********************************************************
// Author:   Fluke Calibration
// Title:    Contacts - Require Valid Email (v3)
// Date:     2020-10
//
// This data check will verify that the email entered on the
// Contacts page is valid and meets certain requirements:
//
// For an email address: name@domainname.domaintype
//
// - The minimum length allowed for ''name'' can be set by
//   changing the minNameLength value.
//
// - The minimum length allowed for ''domainname'' can be set by
//   changing the minDomainNameLength value.
//
// - The minimum length allowed for ''domaintype'' can be set by
//   changing the minDomainTypeLength value.
// **********************************************************

// These settings determine minimum requirements for the email address format
var minNameLength = 1;
var minDomainNameLength = 1;
var minDomainTypeLength = 1;

var minTotalLength = minNameLength + minDomainNameLength + minDomainTypeLength + 2;
var message = ''The email format does not seem to be correct'';

pass();

// Get the value entered into cEmail1
var mail1 = $.trim(DataCheck.SafeNull(Model.cEmail1));

// any email address must be more than 5 characters in length (i.e. a@b.c)
if (mail1.length >= minTotalLength) {
    // check for the ''@'' sign
    if (mail1.indexOf(''@'') < 0) {
        DataCheck.Alert(''Attention'', message);
        DataCheck.AddValidation(''cEmail1'', message);
        fail();

    } else {
        // split the email into name and domain
        var parts = mail1.split(''@'');

        // verify the name is at least one character long
        if (parts[0].length < minNameLength) {
            DataCheck.Alert(''Attention'', message);
            DataCheck.AddValidation(''cEmail1'', message);
            fail();

        }

        // verify the domain includes a "."
        if (parts[1].indexOf(''.'') < 0) {
            DataCheck.Alert(''Attention'', message);
            DataCheck.AddValidation(''cEmail1'', message);
            fail();

        } else {
            // split the domain into name and type
            var domain = parts[1].split(''.'');

            // verify the domain name is at least 1 character in length
            // and the domain type is at least 1 character in length
            if (domain[0].length < minDomainNameLength || domain[1].length < minDomainTypeLength) {
                DataCheck.Alert(''Attention'', message);
                DataCheck.AddValidation(''cEmail1'', message);
                fail();

            }
        }
    }

} else {
    DataCheck.Alert(''Attention'', message);
    DataCheck.AddValidation(''cEmail1'', message);
    fail();

}')
		BEGIN
			UPDATE [dbo].[Validations] SET cCode = N'// **********************************************************
// Author:   Fluke Calibration
// Title:    Contacts - Require Valid Email (v3)
// Date:     2020-10
//
// This data check will verify that the email entered on the
// Contacts page is valid and meets certain requirements:
//
// For an email address: name@domainname.domaintype
//
// - The minimum length allowed for ''name'' can be set by
//   changing the minNameLength value.
//
// - The minimum length allowed for ''domainname'' can be set by
//   changing the minDomainNameLength value.
//
// - The minimum length allowed for ''domaintype'' can be set by
//   changing the minDomainTypeLength value.
// **********************************************************

// These settings determine minimum requirements for the email address format
var minNameLength = 1;
var minDomainNameLength = 1;
var minDomainTypeLength = 1;

var minTotalLength = minNameLength + minDomainNameLength + minDomainTypeLength + 2;
var message = ''The email format does not seem to be correct'';

pass();

// Get the value entered into cEmail1
var mail1 = $.trim(DataCheck.SafeNull(Model.cEmail1));

// any email address must be more than 5 characters in length (i.e. a@b.c)
if (mail1.length >= minTotalLength) {
    // check for the ''@'' sign
    if (mail1.indexOf(''@'') < 0) {
        DataCheck.Alert(''Attention'', message);
        DataCheck.AddValidation(''cEmail1'', message);
        fail();

    } else {
        // split the email into name and domain
        var parts = mail1.split(''@'');

        // verify the name is at least one character long
        if (parts[0].length < minNameLength) {
            DataCheck.Alert(''Attention'', message);
            DataCheck.AddValidation(''cEmail1'', message);
            fail();

        }

        // verify the domain includes a "."
        if (parts[1].indexOf(''.'') < 0) {
            DataCheck.Alert(''Attention'', message);
            DataCheck.AddValidation(''cEmail1'', message);
            fail();

        } else {
            // split the domain into name and type
            var domain = parts[1].split(''.'');

            // verify the domain name is at least 1 character in length
            // and the domain type is at least 1 character in length
            if (domain[0].length < minDomainNameLength || domain[1].length < minDomainTypeLength) {
                DataCheck.Alert(''Attention'', message);
                DataCheck.AddValidation(''cEmail1'', message);
                fail();

            }
        }
    }

} else if (mail1.length > 0) {
    DataCheck.Alert(''Attention'', message);
    DataCheck.AddValidation(''cEmail1'', message);
    fail();

}'
			WHERE nValidationUID = 'ce5f16f3-a99d-4829-8e39-a1dd15e4e52b'

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END

	IF EXISTS (SELECT * FROM [dbo].[Validations] WHERE nValidationUID = '2062a102-bd48-4fdf-a369-d5b2cb28c12b')
	BEGIN
		IF EXISTS (SELECT * FROM [dbo].[Validations] WHERE nValidationUID = '2062a102-bd48-4fdf-a369-d5b2cb28c12b' AND cCode = N'// **********************************************************
// Author:   Fluke Calibration
// Title:    Users - Require Valid Email (v3)
// Date:     2020-10
//
// This Data Check will verify that the email entered on the
// Users page is valid and meets certain requirements:
//
// For an email address: name@domainname.domaintype
//
// - The minimum length allowed for ''name'' can be set by
//   changing the minNameLength value.
//
// - The minimum length allowed for ''domainname'' can be set by
//   changing the minDomainNameLength value.
//
// - The minimum length allowed for ''domaintype'' can be set by
//   changing the minDomainTypeLength value.
// **********************************************************

// These settings determine minimum requirements for the email address format
var minNameLength = 1;
var minDomainNameLength = 1;
var minDomainTypeLength = 1;

var minTotalLength = minNameLength + minDomainNameLength + minDomainTypeLength + 2;
var message = ''The email format does not seem to be correct'';

pass();

// Get the value entered into cEmail1
var mail1 = $.trim(DataCheck.SafeNull(Model.cEmail1));

// any email address must be more than 5 characters in length (i.e. a@b.c)
if (mail1.length >= minTotalLength) {
    // check for the ''@'' sign
    if (mail1.indexOf(''@'') < 0) {
        DataCheck.Alert(''Attention'', message);
        DataCheck.AddValidation(''cEmail1'', message);
        fail();

    } else {
        // split the email into name and domain
        var parts = mail1.split(''@'');

        // verify the name is at least one character long
        if (parts[0].length < minNameLength) {
            DataCheck.Alert(''Attention'', message);
            DataCheck.AddValidation(''cEmail1'', message);
            fail();

        }

        // verify the domain includes a "."
        if (parts[1].indexOf(''.'') < 0) {
            DataCheck.Alert(''Attention'', message);
            DataCheck.AddValidation(''cEmail1'', message);
            fail();

        } else {
            // split the domain into name and type
            var domain = parts[1].split(''.'');

            // verify the domain name is at least 1 character in length
            // and the domain type is at least 1 character in length
            if (domain[0].length < minDomainNameLength || domain[1].length < minDomainTypeLength) {
                DataCheck.Alert(''Attention'', message);
                DataCheck.AddValidation(''cEmail1'', message);
                fail();

            }
        }
    }

} else {
    DataCheck.Alert(''Attention'', message);
    DataCheck.AddValidation(''cEmail1'', message);
    fail();

}')
		BEGIN
			UPDATE [dbo].[Validations] SET cCode = N'// **********************************************************
// Author:   Fluke Calibration
// Title:    Users - Require Valid Email (v3)
// Date:     2020-10
//
// This Data Check will verify that the email entered on the
// Users page is valid and meets certain requirements:
//
// For an email address: name@domainname.domaintype
//
// - The minimum length allowed for ''name'' can be set by
//   changing the minNameLength value.
//
// - The minimum length allowed for ''domainname'' can be set by
//   changing the minDomainNameLength value.
//
// - The minimum length allowed for ''domaintype'' can be set by
//   changing the minDomainTypeLength value.
// **********************************************************

// These settings determine minimum requirements for the email address format
var minNameLength = 1;
var minDomainNameLength = 1;
var minDomainTypeLength = 1;

var minTotalLength = minNameLength + minDomainNameLength + minDomainTypeLength + 2;
var message = ''The email format does not seem to be correct'';

pass();

// Get the value entered into cEmail1
var mail1 = $.trim(DataCheck.SafeNull(Model.cEmail1));

// any email address must be more than 5 characters in length (i.e. a@b.c)
if (mail1.length >= minTotalLength) {
    // check for the ''@'' sign
    if (mail1.indexOf(''@'') < 0) {
        DataCheck.Alert(''Attention'', message);
        DataCheck.AddValidation(''cEmail1'', message);
        fail();

    } else {
        // split the email into name and domain
        var parts = mail1.split(''@'');

        // verify the name is at least one character long
        if (parts[0].length < minNameLength) {
            DataCheck.Alert(''Attention'', message);
            DataCheck.AddValidation(''cEmail1'', message);
            fail();

        }

        // verify the domain includes a "."
        if (parts[1].indexOf(''.'') < 0) {
            DataCheck.Alert(''Attention'', message);
            DataCheck.AddValidation(''cEmail1'', message);
            fail();

        } else {
            // split the domain into name and type
            var domain = parts[1].split(''.'');

            // verify the domain name is at least 1 character in length
            // and the domain type is at least 1 character in length
            if (domain[0].length < minDomainNameLength || domain[1].length < minDomainTypeLength) {
                DataCheck.Alert(''Attention'', message);
                DataCheck.AddValidation(''cEmail1'', message);
                fail();

            }
        }
    }

} else if (mail1.length > 0) {
    DataCheck.Alert(''Attention'', message);
    DataCheck.AddValidation(''cEmail1'', message);
    fail();

}'
			WHERE nValidationUID = '2062a102-bd48-4fdf-a369-d5b2cb28c12b'

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END


	-->>MTM-4073<<--
	IF NOT EXISTS(SELECT * FROM syscolumns sc JOIN sysobjects so ON sc.id = so.id WHERE sc.name = 'lUrl' AND so.name = 'Files')
	BEGIN

		IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE AuditColumnID = '333D6827-396B-4609-803E-DEBE0C5CEB90')
		BEGIN
			SET IDENTITY_INSERT [dbo].[AuditColumns] ON
			INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
			VALUES ('333D6827-396B-4609-803E-DEBE0C5CEB90', 30, 3053, N'lUrl', 1, 0, 0, 0, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20210308 18:44:52.840', 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20210308 18:44:52.840', '20210308 18:44:52.840', NULL, NULL)
			SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE AuditColumnID = '141A030D-A7B6-4228-A9ED-B0FF70328D50')
		BEGIN
			SET IDENTITY_INSERT [dbo].[AuditColumns] ON
			INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
			VALUES ('141A030D-A7B6-4228-A9ED-B0FF70328D50', 30, 3054, N'nCallSheetAttributeUID', 1, 0, 0, 0, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20210308 18:44:52.840', 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20210308 18:44:52.840', '20210308 18:44:52.840', NULL, NULL)
			SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lActive'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lActive'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lActive'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lAdded'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lAdded'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lApproved'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lApproved'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lDeleted'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lDeleted'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nAddFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nAddUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nAddUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nImportUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nImportUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nUpdateFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nUpdateUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tAddTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tAddTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tMobileTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tMobileTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tSystemUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Files_ManualTemplates]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Files]', 'U'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [FK_Files_ManualTemplates]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[Accreditations]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Accreditations_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Accreditations]', 'U'))
		ALTER TABLE [dbo].[Accreditations] DROP CONSTRAINT [FK_Accreditations_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[AssetFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssetFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[AssetFiles]', 'U'))
		ALTER TABLE [dbo].[AssetFiles] DROP CONSTRAINT [FK_AssetFiles_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[CallSheetAttributes]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetAttributes_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetAttributes]', 'U'))
		ALTER TABLE [dbo].[CallSheetAttributes] DROP CONSTRAINT [FK_CallSheetAttributes_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[CallSheetFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetFiles]', 'U'))
		ALTER TABLE [dbo].[CallSheetFiles] DROP CONSTRAINT [FK_CallSheetFiles_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [FK_CallSheetResults_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[FacilityFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_FacilityFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[FacilityFiles]', 'U'))
		ALTER TABLE [dbo].[FacilityFiles] DROP CONSTRAINT [FK_FacilityFiles_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[JobNumberFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_JobNumberFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[JobNumberFiles]', 'U'))
		ALTER TABLE [dbo].[JobNumberFiles] DROP CONSTRAINT [FK_JobNumberFiles_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[PartFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PartFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[PartFiles]', 'U'))
		ALTER TABLE [dbo].[PartFiles] DROP CONSTRAINT [FK_PartFiles_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[ProblemReportFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReportFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReportFiles]', 'U'))
		ALTER TABLE [dbo].[ProblemReportFiles] DROP CONSTRAINT [FK_ProblemReportFiles_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[ProcedureFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedureFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedureFiles]', 'U'))
		ALTER TABLE [dbo].[ProcedureFiles] DROP CONSTRAINT [FK_ProcedureFiles_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[TemplateItems]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_TemplateItems_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[TemplateItems]', 'U'))
		ALTER TABLE [dbo].[TemplateItems] DROP CONSTRAINT [FK_TemplateItems_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[ToolAssignmentFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ToolAssignmentFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ToolAssignmentFiles]', 'U'))
		ALTER TABLE [dbo].[ToolAssignmentFiles] DROP CONSTRAINT [FK_ToolAssignmentFiles_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[TypeFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_TypeFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[TypeFiles]', 'U'))
		ALTER TABLE [dbo].[TypeFiles] DROP CONSTRAINT [FK_TypeFiles_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[TypeProcedureDefaults]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_TypeProcedureDefaults_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[TypeProcedureDefaults]', 'U'))
		ALTER TABLE [dbo].[TypeProcedureDefaults] DROP CONSTRAINT [FK_TypeProcedureDefaults_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[Types]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Types_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Types]', 'U'))
		ALTER TABLE [dbo].[Types] DROP CONSTRAINT [FK_Types_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAccessLevel' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_nAccessLevel]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_nAccessLevel]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lCheckedOut' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_lCheckedOut]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_lCheckedOut]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lActive' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_lActive]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_lActive]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lDeleted' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_lDeleted]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_lDeleted]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lApproved' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_lApproved]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_lApproved]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lAdded' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_lAdded]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_lAdded]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_nAddFacilityUID]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_nAddFacilityUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddUserUID' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_nAddUserUID]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_nAddUserUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tAddTime' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_tAddTime]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_tAddTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_nUpdateFacilityUID]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_nUpdateFacilityUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateUserUID' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_nUpdateUserUID]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_nUpdateUserUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tUpdateTime' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_tUpdateTime]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_tUpdateTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tMobileTime' AND object_id = OBJECT_ID(N'[dbo].[Files]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Files_tMobileTime]', 'D'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [DF_Files_tMobileTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [FK_Procedures_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Files1]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [FK_Procedures_Files1]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PK_Files]', 'PK') AND parent_object_id = OBJECT_ID(N'[dbo].[Files]', 'U'))
		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [PK_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping index [IDX_Files_tAddTime] from [dbo].[Files]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Files_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[Files]'))
		DROP INDEX [IDX_Files_tAddTime] ON [dbo].[Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping trigger [dbo].[tr_kr_audit_Files_Del] from [dbo].[Files]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Del]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_Files_Del]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping trigger [dbo].[tr_kr_audit_Files_Ins] from [dbo].[Files]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Ins]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_Files_Ins]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping trigger [dbo].[tr_kr_audit_Files_Upd] from [dbo].[Files]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Upd]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_Files_Upd]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Del]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Files_Del] from [dbo].[Files]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_Files_Del]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


		PRINT N'Rebuilding [dbo].[Files]'
		CREATE TABLE [dbo].[RG_Recovery_2_Files]
		(
			[nFileUID] [uniqueidentifier] NOT NULL ROWGUIDCOL,
			[nManualTemplateUID] [uniqueidentifier] NULL,
			[nCallSheetAttributeUID] [uniqueidentifier] NULL,
			[cFileType] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cFileName] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cFilePath] [nvarchar] (4000) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cMd5] [nvarchar] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cAuthority] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[nAccessLevel] [tinyint] NOT NULL CONSTRAINT [DF_Files_nAccessLevel] DEFAULT ((0)),
			[iFile] [varbinary] (max) NULL,
			[mNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[lCheckedOut] [int] NOT NULL CONSTRAINT [DF_Files_lCheckedOut] DEFAULT ((0)),
			[lUrl] [int] NOT NULL CONSTRAINT [DF_Files_lUrl] DEFAULT ((0)),
			[lActive] [int] NOT NULL CONSTRAINT [DF_Files_lActive] DEFAULT ((-1)),
			[lDeleted] [int] NOT NULL CONSTRAINT [DF_Files_lDeleted] DEFAULT ((0)),
			[lApproved] [int] NOT NULL CONSTRAINT [DF_Files_lApproved] DEFAULT ((0)),
			[lAdded] [int] NOT NULL CONSTRAINT [DF_Files_lAdded] DEFAULT ((-1)),
			[nAddFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Files_nAddFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
			[nAddUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Files_nAddUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
			[tAddTime] [datetime] NOT NULL CONSTRAINT [DF_Files_tAddTime] DEFAULT (getutcdate()),
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Files_nUpdateFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
			[nUpdateUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Files_nUpdateUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
			[tUpdateTime] [datetime] NOT NULL CONSTRAINT [DF_Files_tUpdateTime] DEFAULT (getutcdate()),
			[tMobileTime] [datetime] NOT NULL CONSTRAINT [DF_Files_tMobileTime] DEFAULT (getutcdate()),
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
			CONSTRAINT [RG_Recovery_8b84_PK_Files] PRIMARY KEY NONCLUSTERED  ([nFileUID])
		)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		INSERT INTO [dbo].[RG_Recovery_2_Files]([nFileUID], [nManualTemplateUID], [cFileType], [cFileName], [cFilePath], [cMd5], [cAuthority], [nAccessLevel], [iFile], [mNotes], [lCheckedOut], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) SELECT [nFileUID], [nManualTemplateUID], [cFileType], [cFileName], [cFilePath], [cMd5], [cAuthority], [nAccessLevel], [iFile], [mNotes], [lCheckedOut], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID] FROM [dbo].[Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		DROP TABLE [dbo].[Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF (OBJECT_ID(N'[dbo].[RG_Recovery_2_Files]', 'U') IS NOT NULL) AND (OBJECT_ID(N'[dbo].[Files]', 'U') IS NULL)
		EXEC sp_rename N'[dbo].[RG_Recovery_2_Files]', N'Files', N'OBJECT'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		EXEC sp_rename N'[dbo].[Files].[RG_Recovery_8b84_PK_Files]', N'PK_Files', N'INDEX'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Creating index [IDX_Files_tAddTime] on [dbo].[Files]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Files_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[Files]'))
		CREATE CLUSTERED INDEX [IDX_Files_tAddTime] ON [dbo].[Files] ([tAddTime])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Del]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_Files_Del] on [dbo].[Files]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Files_Del] ON [dbo].[Files] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210308 22:51:55

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            898,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAuthority], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            899,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFileName], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            900,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFilePath], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            901,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFileType], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            2925,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cMd5], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            902,
            0,
            CONVERT( NVARCHAR(max), [iFile] )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            903,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            904,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            905,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            906,
            0,
            CONVERT(NVARCHAR, [lCheckedOut])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            907,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            3053,
            0,
            CONVERT(NVARCHAR, [lUrl])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            908,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            909,
            0,
            CONVERT(NVARCHAR, [nAccessLevel])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            910,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            911,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            3054,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetAttributeUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            912,
            0,
            CONVERT(NVARCHAR( 36 ), [nFileUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            913,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            914,
            0,
            CONVERT(NVARCHAR( 36 ), [nManualTemplateUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            915,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            916,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            917,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            918,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            919,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            920,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 30, @RowsAffected, ''D'', @AuditedUser
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Files_Del]', 'last', 'delete', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Ins]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Files_Ins] from [dbo].[Files]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_Files_Ins]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Ins]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_Files_Ins] on [dbo].[Files]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Files_Ins] ON [dbo].[Files] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210308 22:51:55

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            898,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAuthority], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            899,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFileName], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            900,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFilePath], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            901,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFileType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            2925,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cMd5], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            902,
            0,
            CONVERT( NVARCHAR(max), [iFile] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            903,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            904,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            905,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            906,
            0,
            CONVERT(NVARCHAR, [lCheckedOut])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            907,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            3053,
            0,
            CONVERT(NVARCHAR, [lUrl])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            908,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            909,
            0,
            CONVERT(NVARCHAR, [nAccessLevel])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            910,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            911,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            3054,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetAttributeUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            912,
            0,
            CONVERT(NVARCHAR( 36 ), [nFileUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            914,
            0,
            CONVERT(NVARCHAR( 36 ), [nManualTemplateUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            917,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 30, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Files_Ins]', 'last', 'insert', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Upd]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Files_Upd] from [dbo].[Files]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_Files_Upd]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Upd]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_Files_Upd] on [dbo].[Files]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Files_Upd] ON [dbo].[Files] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210308 22:51:55

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nFileUID] = i.[nFileUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cAuthority] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                898,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAuthority], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAuthority], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[cAuthority], '''') <> NULLIF(i.[cAuthority], '''') ) OR
                ( NULLIF(d.[cAuthority], '''') IS NULL AND NULLIF(i.[cAuthority], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAuthority], '''') IS NULL AND NULLIF(d.[cAuthority], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFileName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                899,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFileName], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFileName], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[cFileName], '''') <> NULLIF(i.[cFileName], '''') ) OR
                ( NULLIF(d.[cFileName], '''') IS NULL AND NULLIF(i.[cFileName], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFileName], '''') IS NULL AND NULLIF(d.[cFileName], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFilePath] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                900,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFilePath], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFilePath], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[cFilePath], '''') <> NULLIF(i.[cFilePath], '''') ) OR
                ( NULLIF(d.[cFilePath], '''') IS NULL AND NULLIF(i.[cFilePath], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFilePath], '''') IS NULL AND NULLIF(d.[cFilePath], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFileType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                901,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFileType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFileType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[cFileType], '''') <> NULLIF(i.[cFileType], '''') ) OR
                ( NULLIF(d.[cFileType], '''') IS NULL AND NULLIF(i.[cFileType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFileType], '''') IS NULL AND NULLIF(d.[cFileType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cMd5] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                2925,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cMd5], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cMd5], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[cMd5], '''') <> NULLIF(i.[cMd5], '''') ) OR
                ( NULLIF(d.[cMd5], '''') IS NULL AND NULLIF(i.[cMd5], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cMd5], '''') IS NULL AND NULLIF(d.[cMd5], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [iFile] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                902,
                0,
                CONVERT( NVARCHAR(max), d.[iFile] ),
                CONVERT( NVARCHAR(max), i.[iFile] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[iFile] <> i.[iFile] ) OR
                ( d.[iFile] IS NULL AND i.[iFile] IS NOT NULL ) OR
                ( i.[iFile] IS NULL AND d.[iFile] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                903,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                904,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                905,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lCheckedOut] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                906,
                0,
                CONVERT(NVARCHAR, d.[lCheckedOut]),
                CONVERT(NVARCHAR, i.[lCheckedOut])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lCheckedOut] <> i.[lCheckedOut] ) OR
                ( d.[lCheckedOut] IS NULL AND i.[lCheckedOut] IS NOT NULL ) OR
                ( i.[lCheckedOut] IS NULL AND d.[lCheckedOut] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                907,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lUrl] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                3053,
                0,
                CONVERT(NVARCHAR, d.[lUrl]),
                CONVERT(NVARCHAR, i.[lUrl])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lUrl] <> i.[lUrl] ) OR
                ( d.[lUrl] IS NULL AND i.[lUrl] IS NOT NULL ) OR
                ( i.[lUrl] IS NULL AND d.[lUrl] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                908,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAccessLevel] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                909,
                0,
                CONVERT(NVARCHAR, d.[nAccessLevel]),
                CONVERT(NVARCHAR, i.[nAccessLevel])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nAccessLevel] <> i.[nAccessLevel] ) OR
                ( d.[nAccessLevel] IS NULL AND i.[nAccessLevel] IS NOT NULL ) OR
                ( i.[nAccessLevel] IS NULL AND d.[nAccessLevel] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                910,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                911,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetAttributeUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                3054,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetAttributeUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetAttributeUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nCallSheetAttributeUID] <> i.[nCallSheetAttributeUID] ) OR
                ( d.[nCallSheetAttributeUID] IS NULL AND i.[nCallSheetAttributeUID] IS NOT NULL ) OR
                ( i.[nCallSheetAttributeUID] IS NULL AND d.[nCallSheetAttributeUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFileUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                912,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFileUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFileUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nFileUID] <> i.[nFileUID] ) OR
                ( d.[nFileUID] IS NULL AND i.[nFileUID] IS NOT NULL ) OR
                ( i.[nFileUID] IS NULL AND d.[nFileUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nManualTemplateUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                914,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nManualTemplateUID]),
                CONVERT(NVARCHAR( 36 ), i.[nManualTemplateUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nManualTemplateUID] <> i.[nManualTemplateUID] ) OR
                ( d.[nManualTemplateUID] IS NULL AND i.[nManualTemplateUID] IS NOT NULL ) OR
                ( i.[nManualTemplateUID] IS NULL AND d.[nManualTemplateUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                917,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 30, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Files_Upd]', 'last', 'update', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END



		PRINT N'Adding foreign keys to [dbo].[AssetFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssetFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[AssetFiles]', 'U'))
		ALTER TABLE [dbo].[AssetFiles] ADD CONSTRAINT [FK_AssetFiles_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[Files]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Files_ManualTemplates]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Files]', 'U'))
		ALTER TABLE [dbo].[Files] ADD CONSTRAINT [FK_Files_ManualTemplates] FOREIGN KEY ([nManualTemplateUID]) REFERENCES [dbo].[ManualTemplates] ([nManualTemplateUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[Accreditations]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Accreditations_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Accreditations]', 'U'))
		ALTER TABLE [dbo].[Accreditations] ADD CONSTRAINT [FK_Accreditations_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[CallSheetAttributes]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetAttributes_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetAttributes]', 'U'))
		ALTER TABLE [dbo].[CallSheetAttributes] ADD CONSTRAINT [FK_CallSheetAttributes_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[CallSheetFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetFiles]', 'U'))
		ALTER TABLE [dbo].[CallSheetFiles] ADD CONSTRAINT [FK_CallSheetFiles_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[CallSheetResults]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] ADD CONSTRAINT [FK_CallSheetResults_Files] FOREIGN KEY ([nAttTemplateUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[FacilityFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_FacilityFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[FacilityFiles]', 'U'))
		ALTER TABLE [dbo].[FacilityFiles] ADD CONSTRAINT [FK_FacilityFiles_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[JobNumberFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_JobNumberFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[JobNumberFiles]', 'U'))
		ALTER TABLE [dbo].[JobNumberFiles] ADD CONSTRAINT [FK_JobNumberFiles_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[PartFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PartFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[PartFiles]', 'U'))
		ALTER TABLE [dbo].[PartFiles] ADD CONSTRAINT [FK_PartFiles_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[ProblemReportFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReportFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReportFiles]', 'U'))
		ALTER TABLE [dbo].[ProblemReportFiles] ADD CONSTRAINT [FK_ProblemReportFiles_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[ProcedureFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedureFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedureFiles]', 'U'))
		ALTER TABLE [dbo].[ProcedureFiles] ADD CONSTRAINT [FK_ProcedureFiles_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedureFiles_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedureFiles]', 'U'))
		ALTER TABLE [dbo].[ProcedureFiles] ADD CONSTRAINT [FK_ProcedureFiles_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[Procedures]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] ADD CONSTRAINT [FK_Procedures_Files] FOREIGN KEY ([nAttTemplateUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Files1]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] ADD CONSTRAINT [FK_Procedures_Files1] FOREIGN KEY ([nProcedureFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		PRINT N'Adding foreign keys to [dbo].[TemplateItems]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_TemplateItems_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[TemplateItems]', 'U'))
		ALTER TABLE [dbo].[TemplateItems] ADD CONSTRAINT [FK_TemplateItems_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[ToolAssignmentFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ToolAssignmentFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ToolAssignmentFiles]', 'U'))
		ALTER TABLE [dbo].[ToolAssignmentFiles] ADD CONSTRAINT [FK_ToolAssignmentFiles_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[TypeFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_TypeFiles_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[TypeFiles]', 'U'))
		ALTER TABLE [dbo].[TypeFiles] ADD CONSTRAINT [FK_TypeFiles_Files] FOREIGN KEY ([nFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[TypeProcedureDefaults]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_TypeProcedureDefaults_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[TypeProcedureDefaults]', 'U'))
		ALTER TABLE [dbo].[TypeProcedureDefaults] ADD CONSTRAINT [FK_TypeProcedureDefaults_Files] FOREIGN KEY ([nAttTemplateUID]) REFERENCES [dbo].[Files] ([nFileUID])
		PRINT N'Adding foreign keys to [dbo].[Types]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Types_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Types]', 'U'))
		ALTER TABLE [dbo].[Types] ADD CONSTRAINT [FK_Types_Files] FOREIGN KEY ([nImageUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Creating extended properties'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lActive'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=inactive; -1 or 1=active', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lActive'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lAdded'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not added; -1 or 1=added', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lAdded'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lApproved'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not approved; -1 or 1=approved', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lApproved'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lDeleted'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not deleted; -1 or 1=deleted', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lDeleted'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that added the record', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nAddFacilityUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nAddUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the user that added the record', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nAddUserUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nImportUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'If imported, contains UID of the import record', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nImportUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that last updated the record', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nUpdateFacilityUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the last user to update the record', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'nUpdateUserUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tAddTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was added', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tAddTime'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tMobileTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for Mobile mode', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tMobileTime'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for the Warehouse', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tSystemUpdateTime'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'tUpdateTime'
	END


	-->>MTM-4028<<--
	IF NOT EXISTS(SELECT * FROM syscolumns sc JOIN sysobjects so ON sc.id = so.id WHERE sc.name = 'lLocked' AND so.name = 'Procedures')
	BEGIN
		IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE AuditColumnID = '04F1C4CF-36BC-4D62-8A04-9CE9FDD5803D')
		BEGIN
			SET IDENTITY_INSERT [dbo].[AuditColumns] ON
			INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
			VALUES ('04F1C4CF-36BC-4D62-8A04-9CE9FDD5803D', 47, 3055, N'lLocked', 1, 0, 0, 0, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20210308 18:44:52.840', 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20210308 18:44:52.840', '20210308 18:44:52.840', NULL, NULL)
			SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', NULL, NULL))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', NULL, NULL

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cAuthority'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cAuthority'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureName'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureName'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureNumber'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureNumber'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureType'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureType'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cRevision'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cRevision'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cVersion'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cVersion'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lActive'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lActive'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lAdded'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lAdded'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lApproved'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lApproved'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lDeleted'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lDeleted'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'mNotes'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'mNotes'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAddFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAddUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAddUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nApprovedByUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nApprovedByUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAttTemplateUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAttTemplateUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nCategoryUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nCategoryUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nImportUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nImportUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nProcedureFileUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nProcedureFileUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nProcedureUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nProcedureUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nUpdateFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nUpdateUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tAddTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tAddTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tMobileTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tMobileTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tProcedureDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tProcedureDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tRevisionDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tRevisionDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tSystemUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [FK_CallSheetResults_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedureFiles_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedureFiles]', 'U'))
		ALTER TABLE [dbo].[ProcedureFiles] DROP CONSTRAINT [FK_ProcedureFiles_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [FK_Procedures_Files]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Files1]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [FK_Procedures_Files1]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Category]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [FK_Procedures_Category]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Users]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [FK_Procedures_Users]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_TypeProcedureDefaults_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[TypeProcedureDefaults]', 'U'))
		ALTER TABLE [dbo].[TypeProcedureDefaults] DROP CONSTRAINT [FK_TypeProcedureDefaults_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[EstimateItems]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_EstimateItems_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[EstimateItems]', 'U'))
		ALTER TABLE [dbo].[EstimateItems] DROP CONSTRAINT [FK_EstimateItems_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [FK_ProblemReports_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[ProcedureEx]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedureEx_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedureEx]', 'U'))
		ALTER TABLE [dbo].[ProcedureEx] DROP CONSTRAINT [FK_ProcedureEx_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[ProcedurePartDefaults]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedurePartDefaults_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedurePartDefaults]', 'U'))
		ALTER TABLE [dbo].[ProcedurePartDefaults] DROP CONSTRAINT [FK_ProcedurePartDefaults_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping foreign keys from [dbo].[ProcedureStandards]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedureStandards_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedureStandards]', 'U'))
		ALTER TABLE [dbo].[ProcedureStandards] DROP CONSTRAINT [FK_ProcedureStandards_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PK_Procedures]', 'PK') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [PK_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lActive' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_lActive]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_lActive]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lDeleted' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_lDeleted]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_lDeleted]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lApproved' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_lApproved]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_lApproved]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lAdded' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_lAdded]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_lAdded]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_nAddFacilityUID]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_nAddFacilityUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddUserUID' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_nAddUserUID]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_nAddUserUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tAddTime' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_tAddTime]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_tAddTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_nUpdateFacilityUID]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_nUpdateFacilityUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateUserUID' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_nUpdateUserUID]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_nUpdateUserUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tUpdateTime' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_tUpdateTime]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_tUpdateTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping constraints from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tMobileTime' AND object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Procedures_tMobileTime]', 'D'))
		ALTER TABLE [dbo].[Procedures] DROP CONSTRAINT [DF_Procedures_tMobileTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping index [IDX_Procedures_05] from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Procedures_05' AND object_id = OBJECT_ID(N'[dbo].[Procedures]'))
		DROP INDEX [IDX_Procedures_05] ON [dbo].[Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping index [IDX_Procedures_cProcedureName] from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Procedures_cProcedureName' AND object_id = OBJECT_ID(N'[dbo].[Procedures]'))
		DROP INDEX [IDX_Procedures_cProcedureName] ON [dbo].[Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping index [IDX_Procedures_tAddTime] from [dbo].[Procedures]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Procedures_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[Procedures]'))
		DROP INDEX [IDX_Procedures_tAddTime] ON [dbo].[Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping trigger [dbo].[tr_kr_audit_Procedures_Del] from [dbo].[Procedures]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_Procedures_Del]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_Procedures_Del]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping trigger [dbo].[tr_kr_audit_Procedures_Ins] from [dbo].[Procedures]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_Procedures_Ins]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_Procedures_Ins]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Dropping trigger [dbo].[tr_kr_audit_Procedures_Upd] from [dbo].[Procedures]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_Procedures_Upd]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_Procedures_Upd]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Rebuilding [dbo].[Procedures]'

		CREATE TABLE [dbo].[RG_Recovery_1_Procedures]
		(
			[nProcedureUID] [uniqueidentifier] NOT NULL ROWGUIDCOL,
			[nCategoryUID] [uniqueidentifier] NULL,
			[nAttTemplateUID] [uniqueidentifier] NULL,
			[nProcedureFileUID] [uniqueidentifier] NULL,
			[nApprovedByUID] [uniqueidentifier] NULL,
			[cProcedureName] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cProcedureNumber] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cAuthority] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cProcedureType] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cVersion] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cRevision] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[tProcedureDate] [datetime] NULL,
			[tRevisionDate] [datetime] NULL,
			[mNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[lLocked] [int] NOT NULL CONSTRAINT [DF_Procedures_lLocked] DEFAULT ((0)),
			[lActive] [int] NOT NULL CONSTRAINT [DF_Procedures_lActive] DEFAULT ((-1)),
			[lDeleted] [int] NOT NULL CONSTRAINT [DF_Procedures_lDeleted] DEFAULT ((0)),
			[lApproved] [int] NOT NULL CONSTRAINT [DF_Procedures_lApproved] DEFAULT ((0)),
			[lAdded] [int] NOT NULL CONSTRAINT [DF_Procedures_lAdded] DEFAULT ((-1)),
			[nAddFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Procedures_nAddFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
			[nAddUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Procedures_nAddUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
			[tAddTime] [datetime] NOT NULL CONSTRAINT [DF_Procedures_tAddTime] DEFAULT (getutcdate()),
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Procedures_nUpdateFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
			[nUpdateUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Procedures_nUpdateUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
			[tUpdateTime] [datetime] NOT NULL CONSTRAINT [DF_Procedures_tUpdateTime] DEFAULT (getutcdate()),
			[tMobileTime] [datetime] NOT NULL CONSTRAINT [DF_Procedures_tMobileTime] DEFAULT (getutcdate()),
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
			CONSTRAINT [RG_Recovery_27bb_PK_Procedures] PRIMARY KEY NONCLUSTERED  ([nProcedureUID])
		)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		INSERT INTO [dbo].[RG_Recovery_1_Procedures]([nProcedureUID], [nCategoryUID], [nAttTemplateUID], [nProcedureFileUID], [nApprovedByUID], [cProcedureName], [cProcedureNumber], [cAuthority], [cProcedureType], [cVersion], [cRevision], [tProcedureDate], [tRevisionDate], [mNotes], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		SELECT [nProcedureUID], [nCategoryUID], [nAttTemplateUID], [nProcedureFileUID], [nApprovedByUID], [cProcedureName], [cProcedureNumber], [cAuthority], [cProcedureType], [cVersion], [cRevision], [tProcedureDate], [tRevisionDate], [mNotes], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID] FROM [dbo].[Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		DROP TABLE [dbo].[Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF (OBJECT_ID(N'[dbo].[RG_Recovery_1_Procedures]', 'U') IS NOT NULL) AND (OBJECT_ID(N'[dbo].[Procedures]', 'U') IS NULL)
		EXEC sp_rename N'[dbo].[RG_Recovery_1_Procedures]', N'Procedures', N'OBJECT'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		EXEC sp_rename N'[dbo].[Procedures].[RG_Recovery_27bb_PK_Procedures]', N'PK_Procedures', N'INDEX'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Creating index [IDX_Procedures_tAddTime] on [dbo].[Procedures]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Procedures_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[Procedures]'))
		CREATE CLUSTERED INDEX [IDX_Procedures_tAddTime] ON [dbo].[Procedures] ([tAddTime])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Creating index [IDX_Procedures_cProcedureName] on [dbo].[Procedures]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Procedures_cProcedureName' AND object_id = OBJECT_ID(N'[dbo].[Procedures]'))
		CREATE NONCLUSTERED INDEX [IDX_Procedures_cProcedureName] ON [dbo].[Procedures] ([cProcedureName])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Creating index [IDX_Procedures_05] on [dbo].[Procedures]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Procedures_05' AND object_id = OBJECT_ID(N'[dbo].[Procedures]'))
		CREATE NONCLUSTERED INDEX [IDX_Procedures_05] ON [dbo].[Procedures] ([cProcedureName], [lDeleted], [lActive], [tAddTime], [nProcedureUID]) INCLUDE ([cAuthority], [tRevisionDate], [tSystemUpdateTime], [tUpdateTime], [nImportUID], [nProcedureFileUID], [nUpdateFacilityUID], [nUpdateUserUID], [tMobileTime], [tProcedureDate], [mNotes], [nAddFacilityUID], [nAddUserUID], [nApprovedByUID], [nAttTemplateUID], [nCategoryUID], [cProcedureNumber], [cProcedureType], [cRevision], [cVersion], [lAdded], [lApproved])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Procedures_Del]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Procedures_Del] from [dbo].[Procedures]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_Procedures_Del]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Procedures_Del]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_Procedures_Del] on [dbo].[Procedures]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Procedures_Del] ON [dbo].[Procedures] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210308 22:53:31

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1412,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAuthority], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1413,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cProcedureName], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1414,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cProcedureNumber], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1415,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cProcedureType], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1416,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cRevision], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1417,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cVersion], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1418,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1419,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1420,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1421,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            3055,
            0,
            CONVERT(NVARCHAR, [lLocked])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1422,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1423,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1424,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1425,
            0,
            CONVERT(NVARCHAR( 36 ), [nApprovedByUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1426,
            0,
            CONVERT(NVARCHAR( 36 ), [nAttTemplateUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1427,
            0,
            CONVERT(NVARCHAR( 36 ), [nCategoryUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1428,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1429,
            0,
            CONVERT(NVARCHAR( 36 ), [nProcedureFileUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1430,
            0,
            CONVERT(NVARCHAR( 36 ), [nProcedureUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1431,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1432,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1433,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1434,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1435,
            0,
            CONVERT( NVARCHAR( 34 ), [tProcedureDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1436,
            0,
            CONVERT( NVARCHAR( 34 ), [tRevisionDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1437,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1438,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 47, @RowsAffected, ''D'', @AuditedUser
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Procedures_Del]', 'last', 'delete', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Procedures_Ins]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Procedures_Ins] from [dbo].[Procedures]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_Procedures_Ins]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Procedures_Ins]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_Procedures_Ins] on [dbo].[Procedures]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Procedures_Ins] ON [dbo].[Procedures] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210308 22:53:31

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1412,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAuthority], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1413,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cProcedureName], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1414,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cProcedureNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1415,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cProcedureType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1416,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cRevision], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1417,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cVersion], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1418,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1419,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1420,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1421,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            3055,
            0,
            CONVERT(NVARCHAR, [lLocked])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1422,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1423,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1424,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1425,
            0,
            CONVERT(NVARCHAR( 36 ), [nApprovedByUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1426,
            0,
            CONVERT(NVARCHAR( 36 ), [nAttTemplateUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1427,
            0,
            CONVERT(NVARCHAR( 36 ), [nCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1429,
            0,
            CONVERT(NVARCHAR( 36 ), [nProcedureFileUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1430,
            0,
            CONVERT(NVARCHAR( 36 ), [nProcedureUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1433,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1435,
            0,
            CONVERT( NVARCHAR( 34 ), [tProcedureDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), [nProcedureUID]),
            1436,
            0,
            CONVERT( NVARCHAR( 34 ), [tRevisionDate], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 47, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Procedures_Ins]', 'last', 'insert', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Procedures_Upd]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Procedures_Upd] from [dbo].[Procedures]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_Procedures_Upd]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Procedures_Upd]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_Procedures_Upd] on [dbo].[Procedures]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Procedures_Upd] ON [dbo].[Procedures] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210308 22:53:31

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cAuthority] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1412,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAuthority], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAuthority], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( NULLIF(d.[cAuthority], '''') <> NULLIF(i.[cAuthority], '''') ) OR
                ( NULLIF(d.[cAuthority], '''') IS NULL AND NULLIF(i.[cAuthority], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAuthority], '''') IS NULL AND NULLIF(d.[cAuthority], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cProcedureName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1413,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cProcedureName], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cProcedureName], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( NULLIF(d.[cProcedureName], '''') <> NULLIF(i.[cProcedureName], '''') ) OR
                ( NULLIF(d.[cProcedureName], '''') IS NULL AND NULLIF(i.[cProcedureName], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cProcedureName], '''') IS NULL AND NULLIF(d.[cProcedureName], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cProcedureNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1414,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cProcedureNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cProcedureNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( NULLIF(d.[cProcedureNumber], '''') <> NULLIF(i.[cProcedureNumber], '''') ) OR
                ( NULLIF(d.[cProcedureNumber], '''') IS NULL AND NULLIF(i.[cProcedureNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cProcedureNumber], '''') IS NULL AND NULLIF(d.[cProcedureNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cProcedureType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1415,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cProcedureType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cProcedureType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( NULLIF(d.[cProcedureType], '''') <> NULLIF(i.[cProcedureType], '''') ) OR
                ( NULLIF(d.[cProcedureType], '''') IS NULL AND NULLIF(i.[cProcedureType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cProcedureType], '''') IS NULL AND NULLIF(d.[cProcedureType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cRevision] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1416,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cRevision], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cRevision], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( NULLIF(d.[cRevision], '''') <> NULLIF(i.[cRevision], '''') ) OR
                ( NULLIF(d.[cRevision], '''') IS NULL AND NULLIF(i.[cRevision], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cRevision], '''') IS NULL AND NULLIF(d.[cRevision], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cVersion] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1417,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cVersion], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cVersion], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( NULLIF(d.[cVersion], '''') <> NULLIF(i.[cVersion], '''') ) OR
                ( NULLIF(d.[cVersion], '''') IS NULL AND NULLIF(i.[cVersion], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cVersion], '''') IS NULL AND NULLIF(d.[cVersion], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1418,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1419,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1420,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1421,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lLocked] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                3055,
                0,
                CONVERT(NVARCHAR, d.[lLocked]),
                CONVERT(NVARCHAR, i.[lLocked])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[lLocked] <> i.[lLocked] ) OR
                ( d.[lLocked] IS NULL AND i.[lLocked] IS NOT NULL ) OR
                ( i.[lLocked] IS NULL AND d.[lLocked] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1422,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1423,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1424,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nApprovedByUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1425,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nApprovedByUID]),
                CONVERT(NVARCHAR( 36 ), i.[nApprovedByUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[nApprovedByUID] <> i.[nApprovedByUID] ) OR
                ( d.[nApprovedByUID] IS NULL AND i.[nApprovedByUID] IS NOT NULL ) OR
                ( i.[nApprovedByUID] IS NULL AND d.[nApprovedByUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAttTemplateUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1426,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAttTemplateUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAttTemplateUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[nAttTemplateUID] <> i.[nAttTemplateUID] ) OR
                ( d.[nAttTemplateUID] IS NULL AND i.[nAttTemplateUID] IS NOT NULL ) OR
                ( i.[nAttTemplateUID] IS NULL AND d.[nAttTemplateUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1427,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[nCategoryUID] <> i.[nCategoryUID] ) OR
                ( d.[nCategoryUID] IS NULL AND i.[nCategoryUID] IS NOT NULL ) OR
                ( i.[nCategoryUID] IS NULL AND d.[nCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nProcedureFileUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1429,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nProcedureFileUID]),
                CONVERT(NVARCHAR( 36 ), i.[nProcedureFileUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[nProcedureFileUID] <> i.[nProcedureFileUID] ) OR
                ( d.[nProcedureFileUID] IS NULL AND i.[nProcedureFileUID] IS NOT NULL ) OR
                ( i.[nProcedureFileUID] IS NULL AND d.[nProcedureFileUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nProcedureUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1430,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nProcedureUID]),
                CONVERT(NVARCHAR( 36 ), i.[nProcedureUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[nProcedureUID] <> i.[nProcedureUID] ) OR
                ( d.[nProcedureUID] IS NULL AND i.[nProcedureUID] IS NOT NULL ) OR
                ( i.[nProcedureUID] IS NULL AND d.[nProcedureUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1433,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tProcedureDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1435,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tProcedureDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tProcedureDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[tProcedureDate] <> i.[tProcedureDate] ) OR
                ( d.[tProcedureDate] IS NULL AND i.[tProcedureDate] IS NOT NULL ) OR
                ( i.[tProcedureDate] IS NULL AND d.[tProcedureDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tRevisionDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProcedureUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProcedureUID], d.[nProcedureUID] )),
                1436,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tRevisionDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tRevisionDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProcedureUID] = i.[nProcedureUID] )
            WHERE
                ( d.[tRevisionDate] <> i.[tRevisionDate] ) OR
                ( d.[tRevisionDate] IS NULL AND i.[tRevisionDate] IS NOT NULL ) OR
                ( i.[tRevisionDate] IS NULL AND d.[tRevisionDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 47, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Procedures_Upd]', 'last', 'update', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedureFiles_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedureFiles]', 'U'))
		ALTER TABLE [dbo].[ProcedureFiles] ADD CONSTRAINT [FK_ProcedureFiles_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] ADD CONSTRAINT [FK_CallSheetResults_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[Procedures]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] ADD CONSTRAINT [FK_Procedures_Files] FOREIGN KEY ([nAttTemplateUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Files1]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] ADD CONSTRAINT [FK_Procedures_Files1] FOREIGN KEY ([nProcedureFileUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Category]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] ADD CONSTRAINT [FK_Procedures_Category] FOREIGN KEY ([nCategoryUID]) REFERENCES [dbo].[Category] ([nCategoryUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Procedures_Users]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Procedures]', 'U'))
		ALTER TABLE [dbo].[Procedures] ADD CONSTRAINT [FK_Procedures_Users] FOREIGN KEY ([nApprovedByUID]) REFERENCES [dbo].[Users] ([nUserUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_TypeProcedureDefaults_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[TypeProcedureDefaults]', 'U'))
		ALTER TABLE [dbo].[TypeProcedureDefaults] ADD CONSTRAINT [FK_TypeProcedureDefaults_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[CallSheets]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[EstimateItems]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_EstimateItems_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[EstimateItems]', 'U'))
		ALTER TABLE [dbo].[EstimateItems] ADD CONSTRAINT [FK_EstimateItems_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[ProblemReports]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] ADD CONSTRAINT [FK_ProblemReports_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[ProcedureEx]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedureEx_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedureEx]', 'U'))
		ALTER TABLE [dbo].[ProcedureEx] ADD CONSTRAINT [FK_ProcedureEx_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[ProcedurePartDefaults]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedurePartDefaults_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedurePartDefaults]', 'U'))
		ALTER TABLE [dbo].[ProcedurePartDefaults] ADD CONSTRAINT [FK_ProcedurePartDefaults_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Adding foreign keys to [dbo].[ProcedureStandards]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProcedureStandards_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProcedureStandards]', 'U'))
		ALTER TABLE [dbo].[ProcedureStandards] ADD CONSTRAINT [FK_ProcedureStandards_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', NULL, NULL))
		EXEC sp_addextendedproperty N'MS_Description', N'Contains procedure information ', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', NULL, NULL

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cAuthority'))
		EXEC sp_addextendedproperty N'MS_Description', N'Authority for the procedure', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cAuthority'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureName'))
		EXEC sp_addextendedproperty N'MS_Description', N'Name of procedure', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureName'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureNumber'))
		EXEC sp_addextendedproperty N'MS_Description', N'Number of the procedure', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureNumber'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureType'))
		EXEC sp_addextendedproperty N'MS_Description', N'Type of procedure (Cal, Repair,PM)', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cProcedureType'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cRevision'))
		EXEC sp_addextendedproperty N'MS_Description', N'Revision number', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cRevision'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cVersion'))
		EXEC sp_addextendedproperty N'MS_Description', N'Version number', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'cVersion'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lActive'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=inactive; -1 or 1=active', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lActive'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lAdded'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not added; -1 or 1=added', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lAdded'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lApproved'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not approved; -1 or 1=approved', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lApproved'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lDeleted'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not deleted; -1 or 1=deleted', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lDeleted'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'mNotes'))
		EXEC sp_addextendedproperty N'MS_Description', N'Notes on the procedure', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'mNotes'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that added the record', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAddFacilityUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAddUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the user that added the record', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAddUserUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nApprovedByUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates who approved', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nApprovedByUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAttTemplateUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the attribute template record', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nAttTemplateUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nCategoryUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Category indicator', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nCategoryUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nImportUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'If imported, contains UID of the import record', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nImportUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nProcedureFileUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the file used for procedure', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nProcedureFileUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nProcedureUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Unique system identifier used by the system', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nProcedureUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that last updated the record', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nUpdateFacilityUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the last user to update the record', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'nUpdateUserUID'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tAddTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was added', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tAddTime'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tMobileTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for Mobile mode', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tMobileTime'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tProcedureDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date of the procedure', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tProcedureDate'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tRevisionDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date of the revision', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tRevisionDate'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for the Warehouse', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tSystemUpdateTime'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'tUpdateTime'


	END

	-->>MTM-4073<<--
	IF OBJECT_ID(N'[dbo].[spl_Files_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Files_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_Files_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Files_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Files_RETRIEVE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Files_RETRIEVE
	Retrieves a single record by ID from the Files table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 3/8/2021 (R)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Files_RETRIEVE]

@nFileUID uniqueidentifier


AS
BEGIN

	SELECT
[nFileUID]
		,[nManualTemplateUID]
		,[nCallSheetAttributeUID]
		,[cFileType]
		,[cFileName]
		,[cFilePath]
		,[cMd5]
		,[cAuthority]
		,[nAccessLevel]
		,[iFile]
		,[mNotes]
		,[lCheckedOut]
		,[lUrl]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[Files]
	WHERE
[nFileUID] = @nFileUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Files_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Files_LIST]'
		DROP PROCEDURE [dbo].[spl_Files_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Files_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Files_LIST]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Files_LIST
	Retrieves all records from the Files table
	Optionally includes inactive records
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 3/8/2021 (L)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Files_LIST]

@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nFileUID]
		,[nManualTemplateUID]
		,[nCallSheetAttributeUID]
		,[cFileType]
		,[cFileName]
		,[cFilePath]
		,[cMd5]
		,[cAuthority]
		,[nAccessLevel]
		,[iFile]
		,[mNotes]
		,[lCheckedOut]
		,[lUrl]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[Files]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0

	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Files_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Files_INSERT]'
		DROP PROCEDURE [dbo].[spl_Files_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Files_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Files_INSERT]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Files_INSERT
	Inserts a new record into the Files table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 3/8/2021 (I)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Files_INSERT]

@nManualTemplateUID uniqueidentifier  = NULL
	,@nCallSheetAttributeUID uniqueidentifier  = NULL
	,@cFileType nvarchar(50)  = NULL
	,@cFileName nvarchar(150)  = NULL
	,@cFilePath nvarchar(4000)  = NULL
	,@cMd5 nvarchar(32)  = NULL
	,@cAuthority nvarchar(50)  = NULL
	,@nAccessLevel tinyint  = 0
	,@iFile varbinary(max)  = NULL
	,@mNotes nvarchar(max)  = NULL
	,@lCheckedOut int  = 0
	,@lUrl int  = 0
	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398''
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172''
	,@nImportUID uniqueidentifier  = NULL

	,@nFileUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[Files] (
		[nFileUID]
,[nManualTemplateUID]
		,[nCallSheetAttributeUID]
		,[cFileType]
		,[cFileName]
		,[cFilePath]
		,[cMd5]
		,[cAuthority]
		,[nAccessLevel]
		,[iFile]
		,[mNotes]
		,[lCheckedOut]
		,[lUrl]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@nManualTemplateUID
		,@nCallSheetAttributeUID
		,@cFileType
		,@cFileName
		,@cFilePath
		,@cMd5
		,@cAuthority
		,@nAccessLevel
		,@iFile
		,@mNotes
		,@lCheckedOut
		,@lUrl
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nFileUID = @ID

	-- Avoids warning in VS2010
	RETURN 1

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Files_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Files_DELETE]'
		DROP PROCEDURE [dbo].[spl_Files_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Files_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Files_DELETE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Files_DELETE
	Deletes a single record by ID from the Files table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 3/8/2021 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Files_DELETE]

	@nFileUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT

AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nFileUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID )

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''Files'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		'''',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT

	RETURN @retMsg

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[spl_Files_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Files_UPDATE]'
		DROP PROCEDURE [dbo].[spl_Files_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Files_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Files_UPDATE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Files_UPDATE
	Updates a single record by ID in the Files table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 3/8/2021 (U)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Files_UPDATE]

@nFileUID uniqueidentifier
	,@nManualTemplateUID uniqueidentifier
	,@nCallSheetAttributeUID uniqueidentifier
	,@cFileType nvarchar(50)
	,@cFileName nvarchar(150)
	,@cFilePath nvarchar(4000)
	,@cMd5 nvarchar(32)
	,@cAuthority nvarchar(50)
	,@nAccessLevel tinyint
	,@iFile varbinary(max)
	,@mNotes nvarchar(max)
	,@lCheckedOut int
	,@lUrl int
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[Files]
	SET
[nManualTemplateUID] = @nManualTemplateUID
		,[nCallSheetAttributeUID] = @nCallSheetAttributeUID
		,[cFileType] = @cFileType
		,[cFileName] = @cFileName
		,[cFilePath] = @cFilePath
		,[cMd5] = @cMd5
		,[cAuthority] = @cAuthority
		,[nAccessLevel] = @nAccessLevel
		,[iFile] = @iFile
		,[mNotes] = @mNotes
		,[lCheckedOut] = @lCheckedOut
		,[lUrl] = @lUrl
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nFileUID] = @nFileUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Procedures_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Procedures_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_Procedures_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Procedures_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Procedures_RETRIEVE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Procedures_RETRIEVE
	Retrieves a single record by ID from the Procedures table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 3/8/2021 (R)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Procedures_RETRIEVE]

@nProcedureUID uniqueidentifier


AS
BEGIN

	SELECT
[nProcedureUID]
		,[nCategoryUID]
		,[nAttTemplateUID]
		,[nProcedureFileUID]
		,[nApprovedByUID]
		,[cProcedureName]
		,[cProcedureNumber]
		,[cAuthority]
		,[cProcedureType]
		,[cVersion]
		,[cRevision]
		,[tProcedureDate]
		,[tRevisionDate]
		,[mNotes]
		,[lLocked]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[Procedures]
	WHERE
[nProcedureUID] = @nProcedureUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Procedures_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Procedures_LIST]'
		DROP PROCEDURE [dbo].[spl_Procedures_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Procedures_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Procedures_LIST]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Procedures_LIST
	Retrieves all records from the Procedures table
	Optionally includes inactive records
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 3/8/2021 (L)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Procedures_LIST]

@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nProcedureUID]
		,[nCategoryUID]
		,[nAttTemplateUID]
		,[nProcedureFileUID]
		,[nApprovedByUID]
		,[cProcedureName]
		,[cProcedureNumber]
		,[cAuthority]
		,[cProcedureType]
		,[cVersion]
		,[cRevision]
		,[tProcedureDate]
		,[tRevisionDate]
		,[mNotes]
		,[lLocked]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[Procedures]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0

	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Procedures_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Procedures_INSERT]'
		DROP PROCEDURE [dbo].[spl_Procedures_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Procedures_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Procedures_INSERT]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Procedures_INSERT
	Inserts a new record into the Procedures table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 3/8/2021 (I)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Procedures_INSERT]

@nCategoryUID uniqueidentifier  = NULL
	,@nAttTemplateUID uniqueidentifier  = NULL
	,@nProcedureFileUID uniqueidentifier  = NULL
	,@nApprovedByUID uniqueidentifier  = NULL
	,@cProcedureName nvarchar(150)  = NULL
	,@cProcedureNumber nvarchar(50)  = NULL
	,@cAuthority nvarchar(50)  = NULL
	,@cProcedureType nvarchar(50)  = NULL
	,@cVersion nvarchar(50)  = NULL
	,@cRevision nvarchar(100)  = NULL
	,@tProcedureDate datetime  = NULL
	,@tRevisionDate datetime  = NULL
	,@mNotes nvarchar(max)  = NULL
	,@lLocked int  = 0
	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398''
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172''
	,@nImportUID uniqueidentifier  = NULL

	,@nProcedureUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[Procedures] (
		[nProcedureUID]
,[nCategoryUID]
		,[nAttTemplateUID]
		,[nProcedureFileUID]
		,[nApprovedByUID]
		,[cProcedureName]
		,[cProcedureNumber]
		,[cAuthority]
		,[cProcedureType]
		,[cVersion]
		,[cRevision]
		,[tProcedureDate]
		,[tRevisionDate]
		,[mNotes]
		,[lLocked]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@nCategoryUID
		,@nAttTemplateUID
		,@nProcedureFileUID
		,@nApprovedByUID
		,@cProcedureName
		,@cProcedureNumber
		,@cAuthority
		,@cProcedureType
		,@cVersion
		,@cRevision
		,@tProcedureDate
		,@tRevisionDate
		,@mNotes
		,@lLocked
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nProcedureUID = @ID

	-- Avoids warning in VS2010
	RETURN 1

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Procedures_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Procedures_DELETE]'
		DROP PROCEDURE [dbo].[spl_Procedures_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Procedures_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Procedures_DELETE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Procedures_DELETE
	Deletes a single record by ID from the Procedures table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 3/8/2021 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Procedures_DELETE]

	@nProcedureUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT

AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nProcedureUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID )

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''Procedures'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		''ProcedureEx ProcedureFiles'',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT

	RETURN @retMsg

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[spl_Procedures_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Procedures_UPDATE]'
		DROP PROCEDURE [dbo].[spl_Procedures_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Procedures_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Procedures_UPDATE]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Procedures_UPDATE
	Updates a single record by ID in the Procedures table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 3/8/2021 (U)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Procedures_UPDATE]

@nProcedureUID uniqueidentifier
	,@nCategoryUID uniqueidentifier
	,@nAttTemplateUID uniqueidentifier
	,@nProcedureFileUID uniqueidentifier
	,@nApprovedByUID uniqueidentifier
	,@cProcedureName nvarchar(150)
	,@cProcedureNumber nvarchar(50)
	,@cAuthority nvarchar(50)
	,@cProcedureType nvarchar(50)
	,@cVersion nvarchar(50)
	,@cRevision nvarchar(100)
	,@tProcedureDate datetime
	,@tRevisionDate datetime
	,@mNotes nvarchar(max)
	,@lLocked int
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[Procedures]
	SET
[nCategoryUID] = @nCategoryUID
		,[nAttTemplateUID] = @nAttTemplateUID
		,[nProcedureFileUID] = @nProcedureFileUID
		,[nApprovedByUID] = @nApprovedByUID
		,[cProcedureName] = @cProcedureName
		,[cProcedureNumber] = @cProcedureNumber
		,[cAuthority] = @cAuthority
		,[cProcedureType] = @cProcedureType
		,[cVersion] = @cVersion
		,[cRevision] = @cRevision
		,[tProcedureDate] = @tProcedureDate
		,[tRevisionDate] = @tRevisionDate
		,[mNotes] = @mNotes
		,[lLocked] = @lLocked
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nProcedureUID] = @nProcedureUID


	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_Procedures' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_Procedures]'

		DROP VIEW [dbo].[vw_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[vw_Procedures]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_Procedures]'

		EXEC sp_executesql N'
/****************************************************************************************

	10/24/2005  EdW Added notes fields Casted as Text to prevent Crystal truncation issue
	07/21/2014  MM  Fixed cast and quoted identifiers
	03/08/2021  MM  Added lLocked

*****************************************************************************************/
CREATE VIEW [dbo].[vw_Procedures]
AS
SELECT
	pro.nProcedureUID,
	pro.nCategoryUID,
	pro.cProcedureName,
	pro.cProcedureNumber,
	pro.cAuthority,
	pro.cProcedureType,
	pro.cVersion,
	pro.cRevision,
	pro.tProcedureDate,
	pro.tRevisionDate,
	pro.mNotes,
	pro.lActive,
	pro.lDeleted,
	pro.lApproved,
	pro.lAdded,
	pro.nAddFacilityUID,
	pro.nAddUserUID,
	pro.tAddTime,
	pro.nUpdateFacilityUID,
	pro.nUpdateUserUID,
	pro.tUpdateTime,
	cat.cDescription AS [cCategory],
	CAST (pro.mNotes  AS NTEXT) AS [mNotesText],
	pro.lLocked
FROM
	[dbo].[Procedures] pro
LEFT OUTER JOIN
	[dbo].[Category] AS cat ON pro.nCategoryUID = cat.nCategoryUID
WHERE
	pro.lDeleted = 0
'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-3340<<--
		EXEC sp_executesql N'
	UPDATE
		[dbo].[Files]
	SET
		[nCallSheetAttributeUID] = CONVERT(UNIQUEIDENTIFIER, [cFilePath])
	WHERE
		TRY_CONVERT(UNIQUEIDENTIFIER, [cFilePath]) IS NOT NULL
'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sp_executesql N'
	UPDATE
		[dbo].[Files]
	SET
		[cFilePath] = NULL
	WHERE
		TRY_CONVERT(UNIQUEIDENTIFIER, [cFilePath]) IS NOT NULL
	AND
		[nCallSheetAttributeUID] IS NOT NULL
'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sp_executesql N'
	UPDATE
		[dbo].[Files]
	SET
		[lUrl] = -1
	WHERE
		LOWER(RTRIM(LTRIM([cFilePath]))) <> ''templates''
	AND
		LEN(RTRIM(LTRIM([cFilePath]))) > 4
	AND
		TRY_CONVERT(UNIQUEIDENTIFIER, [cFilePath]) IS NULL
'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-->>MTM-4028<<--
	IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Files_CallSheetAttributes]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Files]', 'U'))
	BEGIN

		ALTER TABLE [dbo].[Files] DROP CONSTRAINT [FK_Files_CallSheetAttributes]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[vw_METCONNECT_RESULTS]', 'V') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[vw_METCONNECT_RESULTS]'
		DROP VIEW [dbo].[vw_METCONNECT_RESULTS]
	END

	IF OBJECT_ID(N'[dbo].[vw_METCONNECT_RESULTS]', 'V') IS NULL
	BEGIN
	PRINT N'Creating [dbo].[vw_METCONNECT_RESULTS]'

		EXEC sp_executesql N'

	/****************************************************************
		vw_METCONNECT_RESULTS
		(C) 2019-21 Fluke Calibration
	-----------------------------------------------------------------
		CHANGE HISTORY
		11/06/2019  MM      Initial development
		11/25/2019  MM      Add cFunctionSelectCode
		11/23/2020  MM      Add Test Step
		02/23/2021  MM      Add Upper and Lower Limit
		03/05/2021  AC      Add FixedQuantity and VariableQuantity
		04/20/2021  MM      Add DUT Resolution
		04/22/2021  MM      Add Group Run Id and Tag Ordinal
	*****************************************************************/
	CREATE VIEW [dbo].[vw_METCONNECT_RESULTS]
	AS
		SELECT
			csr.nCallSheetResultUID AS [ResultKey],
			p.nPointUID AS [PointKey],
			p.nPointOrdinal AS [Ordinal],
			p.cPointDescription AS [Description],
			p.cFunctionSelectCode AS [FSC],
			p.cRemarks AS [Remarks],
			p.cPointPassFailStatus AS [Status],
			ISNULL([dbo].[udf_get_formattedValue](p.nCardinalPoint, p.nCardinalPointFormatUID),'''') AS [CardinalPoint],
			up3.cUnitSymbol AS [CardinalPointUnit],
			ISNULL([dbo].[udf_get_formattedValue](p.nReference, p.nReferenceFormatUID),'''') AS [Reference],
			up2.cUnitSymbol AS [ReferenceUnit],
			ISNULL([dbo].[udf_get_formattedValue](p.nUUT, p.nUUTFormatUID),'''') AS [Dut],
			up1.cUnitSymbol AS [DutUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nError, tol.nErrorFormatUID),'''') AS [Error],
			utol1.cUnitSymbol AS [ErrorUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID),'''') AS [ToleranceNegative],
			utol5.cUnitSymbol AS [ToleranceNegativeUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID),'''') AS [TolerancePositive],
			utol6.cUnitSymbol AS [TolerancePositiveUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID),'''') AS [GuardbandLowerLimit],
			upun18.cUnitSymbol AS [GuardbandLowerLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID),'''') AS [GuardbandUpperLimit],
			upun19.cUnitSymbol AS [GuardbandUpperLimitUnit],
			ISNULL(p.cPointPassFailStatus, '''') AS [PointPassFail],
			ISNULL([dbo].[udf_get_formattedValue](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID),'''') AS [ExpandedUncertainty],
			upun3.cUnitSymbol AS [ExpandedUncertaintyUnit],
			ISNULL(pes.cField009,'''') AS [TestStep],
			ISNULL([dbo].[udf_get_formattedValue](pun.nLowerLimit, pun.nLowerLimitFormatUID),'''') AS [LowerLimit],
			upun1.cUnitSymbol AS [LowerLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nUpperLimit, pun.nUpperLimitFormatUID),'''') AS [UpperLimit],
			upun2.cUnitSymbol AS [UpperLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField010, pen.nField010FormatUID),'''') AS [FixedQuantity],
			upen1.cUnitSymbol AS [FixedQuantityUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField029, pen.nField029FormatUID),'''') AS [VariableQuantity],
			upen2.cUnitSymbol AS [VariableQuantityUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField028, pen.nField028FormatUID),'''') AS [DutResolution],
			upen3.cUnitSymbol AS [DutResolutionUnit],
			ISNULL(csrx.cField049,'''') AS [ProcedureTagOrdinal],
			ISNULL(csrx.cField050,'''') AS [ProcedureRunId]
		FROM
			[dbo].[CallSheetResults] csr
			INNER JOIN [dbo].[Points] p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN [dbo].[CallSheetResultEx] csrx ON csrx.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN [dbo].[Units] up1 ON up1.nUnitUID = p.nUUTUnitUID
			LEFT JOIN [dbo].[Units] up2 ON up2.nUnitUID = p.nReferenceUnitUID
			LEFT JOIN [dbo].[Units] up3 ON up3.nUnitUID = p.nCardinalPointUnitUID
			LEFT JOIN [dbo].[PointExNumerics] pen ON pen.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] upen1 ON upen1.nUnitUID = pen.nField010UnitUID
			LEFT JOIN [dbo].[Units] upen2 ON upen2.nUnitUID = pen.nField029UnitUID
			LEFT JOIN [dbo].[Units] upen3 ON upen3.nUnitUID = pen.nField028UnitUID
			LEFT JOIN [dbo].[PointUncertainties] pun ON pun.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] upun1 ON upun1.nUnitUID = pun.nLowerLimitUnitUID
			LEFT JOIN [dbo].[Units] upun2 ON upun2.nUnitUID = pun.nUpperLimitUnitUID
			LEFT JOIN [dbo].[Units] upun3 ON upun3.nUnitUID = pun.nUncertaintyExpandedUnitUID
			LEFT JOIN [dbo].[Units] upun4 ON upun4.nUnitUID = pun.nUncertaintyStandardUnitUID
			LEFT JOIN [dbo].[Units] upun18 ON upun18.nUnitUID = pun.nGuardBandLowerUnitUID
			LEFT JOIN [dbo].[Units] upun19 ON upun19.nUnitUID = pun.nGuardBandUpperUnitUID
			LEFT JOIN [dbo].[PointTolerances] tol ON tol.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] utol1 ON utol1.nUnitUID = tol.nErrorUnitUID
			LEFT JOIN [dbo].[Units] utol5 ON utol5.nUnitUID = tol.nToleranceNegativeUnitUID
			LEFT JOIN [dbo].[Units] utol6 ON utol6.nUnitUID = tol.nTolerancePositiveUnitUID
			LEFT JOIN [dbo].[PointExStrings] pes ON pes.nPointUID = p.nPointUID
			WHERE
				p.lDeleted = 0
			AND
				p.lActive <> 0
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	-->>METCON-1975<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroups] WHERE [nSecurityGroupUID] = '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC')
	BEGIN

		DELETE FROM [dbo].[SecurityGroupMembers] WHERE [nUserUID] <> '915F9722-3175-4E4D-A571-4A478E8E5172'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		DELETE FROM [dbo].[SecurityGroupMembers] WHERE [nSecurityGroupUID] <> 'FD8E1F20-3E2F-4C7D-8D24-965F18A5A3E0'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		DELETE FROM [dbo].[SecurityGroupFieldLinks] WHERE [lActive] <> 0

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		DELETE FROM [dbo].[SecurityGroups] WHERE cGroupName <> N'Administrator'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		DELETE FROM [dbo].[UCIData] WHERE [nUCIDataUID] IN ('0FFB2F9C-1F22-4DD4-9364-535142D78C6E','21173A2F-8041-4089-9DE7-8EC7DE56A8AF','E63F5E56-6FD2-41B4-A25A-6BCC7B832160','7ABCC2CD-C9BD-4918-9208-6C045574BEFA','E98AAD08-DB83-42A4-B362-47ECDFBFCC4C','8094D75A-7DE1-471F-A60F-4E73EC4EE93F','1713EFD0-DEE3-4B36-8601-4E8F7F71EAB7','AA535F2B-B97D-4EED-B93B-5235BDB43867','C6B7FBFE-445F-49C5-8EDB-2957426CD24B','5E75279C-4C93-4DDA-A66B-365349F5F4FE','349D56FD-8BCE-4B71-97AD-376083B200BB','7D889EAD-E581-4077-B376-83E2F9D99DDE','401A838B-5EC8-44C7-9B1A-B92BCBBBEBB3','D4AFC292-A1B0-4EFD-B02C-F8B35D3CDC80','BB082A2C-4966-45AD-9EE0-F36B34A2C3AB','06072A52-29BE-4A39-8F2D-CA78726D9740','38CB1977-FC05-4638-8762-C453F7B027C0','9AA839B5-9862-4F6F-8563-6233FFB5C131','812EA28B-720C-455D-9F40-5FAE2808C5A6','8A4947C5-9349-4DB7-9DC8-63865673F231','8237F7D6-F4BE-49AC-8D4C-675B45B1F866','8FB2104B-427C-4F9E-A759-5EA8197C4D22','99728DFA-9231-43BB-9F1F-79A4BD802BE1','AA7E7CF4-9B10-479D-8001-6D900D5FC285','203D7106-0339-419A-96BD-41B893B5A33B','BAD904EB-1F8E-492B-91F6-3E0A85359E25','F10A7EFB-25E3-4912-AE66-4D654CC6A474','4A1AB616-15BE-4CEE-AA51-5556AE240A8E','FDF09CF1-EE87-42F4-A515-58B162C1CEE7','D86A103D-B99D-4A69-9C6E-2E24684EF7B2','6F9E8851-91C3-4A63-A09D-1FD56CE2A9C3','9F76F1F4-97AE-454C-9A75-237678E156BC','CFFF2A14-0AD2-4C30-B850-32E752188B11','94EBBD3C-79A7-4C6A-A97F-324563E89CB1','3E1353CA-8ECE-4CF4-905A-1BEC277C85E7','BA0F03EE-B005-4C26-AF13-1398D81FDE63','30D63BFA-4995-4F5A-95A1-046B59CF8AC8','3E7E8268-DC16-4BA7-9BF8-07AF51889262','6909A1E2-46DB-4689-8408-C5C58BCEF146','99969CF3-7315-4F04-8DC1-C6FF2D6A10B7','53A13EDA-BA7B-4950-BD37-D8864185DF36','2AEA10EA-CEA7-4319-85F8-D76FBDF86B6A','446EC437-40B3-4888-87CA-D592D7444485','6A1D2287-BF72-43C0-8F59-CE63179E5A56','93122D9E-7429-4363-B301-E60B802D4F07','3A94086C-4D35-41E7-A462-B03EA7101D9C','F930E60D-561C-41D0-AE87-A5FD21EFB7B7','918D3CFC-1630-407E-8593-B5AF493442C2','B248E2A2-27D8-4985-8C6B-B965B89B97C7','F738DDAA-A470-4501-B5C3-B9F53A1C5A16','B9103FD0-B33F-42D8-96DA-B38384759489','09AF0FA3-3118-46C9-B595-A090286B432E','9D4DC232-B0E3-45B8-A30B-9AFCAACDB37C','31AE1A57-A86D-42CD-9CEF-9AAF077DAD56','0C8C2AF7-E2A1-4C2B-9B72-828B767D7420','A8055667-C2BF-4E25-B421-8162DBA0D985','D4EA3907-AE2A-429A-AC7C-7B4B1A4A29DF','D042FADB-F963-4D66-A87D-7BBE819927EB','D23BD0E5-4CCE-4C77-921B-7F06607E4A6F','B487F811-3EF5-4829-8413-92A75CE6B6DC','BB6985D3-75A9-4914-A660-9505D674B9CD','3FBC5433-4D00-49F7-BEC9-8D08F548B48E','5B5BA840-FF86-4B39-B462-9306F5F98FB8','83DD1193-E8C6-4F2E-9452-91DFBB90620C','5CE213DB-C349-4C81-8841-D156AAD6E9B9','707C9DE4-5A4B-4560-9D62-D07520718DDB','4F3D734C-BC2E-403A-A151-0EACBBD7ED62','568E11D2-2A19-4F50-B626-3810607CC666')

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroups] WHERE [nSecurityGroupUID] = 'E319DC4D-C16F-43C7-AA75-97896B9CC8C1')
	BEGIN
		PRINT 'Adding security group'

		INSERT INTO [dbo].[SecurityGroups] ([nSecurityGroupUID], [cGroupName], [lSystemGroup], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('E319DC4D-C16F-43C7-AA75-97896B9CC8C1', N'Technician', -1, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroups] WHERE [nSecurityGroupUID] = '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC')
	BEGIN
		PRINT 'Adding security group'

		INSERT INTO [dbo].[SecurityGroups] ([nSecurityGroupUID], [cGroupName], [lSystemGroup], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', N'Metrologist', -1, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupMembers] WHERE [nSecurityGroupMemberUID] = '6599F071-64E8-4BF8-A030-8771BFB8475A')
	BEGIN
		PRINT 'Adding security group member'

		INSERT INTO [dbo].[SecurityGroupMembers] ([nSecurityGroupMemberUID], [nSecurityGroupUID], [nUserUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('6599F071-64E8-4BF8-A030-8771BFB8475A', 'E319DC4D-C16F-43C7-AA75-97896B9CC8C1', 'ABF8F215-1980-4E47-84DA-305699ECF5D5', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupMembers] WHERE [nSecurityGroupMemberUID] = '2CCEFB6D-1FA1-4DCC-B870-78B3B7743176')
	BEGIN
		PRINT 'Adding security group member'

		INSERT INTO [dbo].[SecurityGroupMembers] ([nSecurityGroupMemberUID], [nSecurityGroupUID], [nUserUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('2CCEFB6D-1FA1-4DCC-B870-78B3B7743176', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', 'ABF8F215-1980-4E47-84DA-305699ECF5D5', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'E233317E-9CCC-4726-AC4D-7E02CE2B3B9A')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('E233317E-9CCC-4726-AC4D-7E02CE2B3B9A', N'MET/CAL', N'Simulation Mode', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '1AFE9E5E-87E8-4938-B5F7-569588988B81')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('1AFE9E5E-87E8-4938-B5F7-569588988B81', 'E319DC4D-C16F-43C7-AA75-97896B9CC8C1', 'E233317E-9CCC-4726-AC4D-7E02CE2B3B9A', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'FF5AF3BB-CC7A-4320-BDA1-B4F1DDBBEA9F')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('FF5AF3BB-CC7A-4320-BDA1-B4F1DDBBEA9F', N'MET/CAL', N'Export Data', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '265B46DE-535B-4B76-9A21-7071717636B9')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('265B46DE-535B-4B76-9A21-7071717636B9', 'E319DC4D-C16F-43C7-AA75-97896B9CC8C1', 'FF5AF3BB-CC7A-4320-BDA1-B4F1DDBBEA9F', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'A2A9FD5D-7992-4670-A0D0-A4F2BA1AFAA1')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('A2A9FD5D-7992-4670-A0D0-A4F2BA1AFAA1', N'MET/CAL', N'Run Procedure', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '455E5C27-BD94-41B3-A170-48B0138898A7')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('455E5C27-BD94-41B3-A170-48B0138898A7', 'E319DC4D-C16F-43C7-AA75-97896B9CC8C1', 'A2A9FD5D-7992-4670-A0D0-A4F2BA1AFAA1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'ACC9A85B-2990-4E2C-AF04-24BABC746EA1')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('ACC9A85B-2990-4E2C-AF04-24BABC746EA1', N'MET/CAL', N'Configure View', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '15A0BA7F-34BE-46D8-9317-344667AE8404')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('15A0BA7F-34BE-46D8-9317-344667AE8404', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', 'ACC9A85B-2990-4E2C-AF04-24BABC746EA1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'BCBFF21E-2E70-4FEA-A635-4BD9507B1607')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('BCBFF21E-2E70-4FEA-A635-4BD9507B1607', N'MET/CAL', N'Configured Instruments', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = 'E562A34E-09EE-4423-BFC9-891097AFD010')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('E562A34E-09EE-4423-BFC9-891097AFD010', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', 'BCBFF21E-2E70-4FEA-A635-4BD9507B1607', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '2D22F3FE-55FC-418C-B51F-1C1DC01F8CF2')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('2D22F3FE-55FC-418C-B51F-1C1DC01F8CF2', N'MET/CAL', N'Instrument Control Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = 'D87B1DFD-57A6-4F23-9A92-630456EF0EA2')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('D87B1DFD-57A6-4F23-9A92-630456EF0EA2', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', '2D22F3FE-55FC-418C-B51F-1C1DC01F8CF2', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '6D667196-011E-4177-A1DD-86522E1C5273')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('6D667196-011E-4177-A1DD-86522E1C5273', N'MET/CAL', N'Instrument Configuration Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = 'C4DBDC13-1BB8-4E8D-B938-291B77CCC6B9')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('C4DBDC13-1BB8-4E8D-B938-291B77CCC6B9', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', '6D667196-011E-4177-A1DD-86522E1C5273', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'B782438A-7D5A-4B90-B40A-3063D70D6092')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('B782438A-7D5A-4B90-B40A-3063D70D6092', N'MET/CAL', N'Simulation Mode Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '48616C12-BE84-4928-8B7A-B5F1764E1E3A')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('48616C12-BE84-4928-8B7A-B5F1764E1E3A', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', 'B782438A-7D5A-4B90-B40A-3063D70D6092', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '6E13B8DE-D2FA-4E79-83F7-7E5631175459')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('6E13B8DE-D2FA-4E79-83F7-7E5631175459', N'MET/CAL', N'Files and Folders Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '2C2999DE-5AB4-45AB-B180-E47DA90FDD36')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('2C2999DE-5AB4-45AB-B180-E47DA90FDD36', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', '6E13B8DE-D2FA-4E79-83F7-7E5631175459', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '8CB87548-8FCE-4D0E-9561-CD624F2629DB')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('8CB87548-8FCE-4D0E-9561-CD624F2629DB', N'MET/CAL', N'Metrology Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '73420497-8628-493A-B7FE-2C201172C431')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('73420497-8628-493A-B7FE-2C201172C431', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', '8CB87548-8FCE-4D0E-9561-CD624F2629DB', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '7E171C58-1705-43DE-8625-67D568B8171E')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('7E171C58-1705-43DE-8625-67D568B8171E', N'MET/CAL', N'Post Test Dialog Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '0E70DD26-CE5F-471D-AC8D-D3BFA58D9E4E')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('0E70DD26-CE5F-471D-AC8D-D3BFA58D9E4E', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', '7E171C58-1705-43DE-8625-67D568B8171E', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'EF2C6C52-3373-4C70-ABD3-CCBB4AB754B4')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('EF2C6C52-3373-4C70-ABD3-CCBB4AB754B4', N'MET/CAL', N'Results Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '633936FF-0DB6-4DB1-B768-8E26EEE5F821')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('633936FF-0DB6-4DB1-B768-8E26EEE5F821', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', 'EF2C6C52-3373-4C70-ABD3-CCBB4AB754B4', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '21FE67A8-273E-4E9A-932F-F255AF0B48F8')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('21FE67A8-273E-4E9A-932F-F255AF0B48F8', N'MET/CAL', N'Runtime Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '0C848E5F-CA1D-4C1F-B981-E84011473209')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('0C848E5F-CA1D-4C1F-B981-E84011473209', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', '21FE67A8-273E-4E9A-932F-F255AF0B48F8', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '85E63216-CFB1-4D73-BD93-0B2AF9AB7911')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('85E63216-CFB1-4D73-BD93-0B2AF9AB7911', N'MET/CAL', N'Editor Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = 'C25923DA-BE59-4068-A2BC-BD276DE5260F')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('C25923DA-BE59-4068-A2BC-BD276DE5260F', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', '85E63216-CFB1-4D73-BD93-0B2AF9AB7911', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '94052247-98F5-427F-96B0-32E9B3E3351F')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('94052247-98F5-427F-96B0-32E9B3E3351F', N'MET/CAL', N'Safety Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '8B829FCD-767C-4BA9-A719-7CF456EB7ACC')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('8B829FCD-767C-4BA9-A719-7CF456EB7ACC', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', '94052247-98F5-427F-96B0-32E9B3E3351F', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '5F8D1597-55E3-4A20-AB71-69C5DC422A29')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('5F8D1597-55E3-4A20-AB71-69C5DC422A29', N'MET/CAL', N'Workstation Configuration Settings', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '2E00C2AB-3AD5-4F73-AAF1-3BC663DC1EED')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('2E00C2AB-3AD5-4F73-AAF1-3BC663DC1EED', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', '5F8D1597-55E3-4A20-AB71-69C5DC422A29', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '3092E262-C83E-4B6A-96D4-12D7A4150597')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('3092E262-C83E-4B6A-96D4-12D7A4150597', N'MET/CAL', N'Manage Users', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '340A7EA6-61CE-453C-8A9D-80F122887752')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('340A7EA6-61CE-453C-8A9D-80F122887752', 'FD8E1F20-3E2F-4C7D-8D24-965F18A5A3E0', '3092E262-C83E-4B6A-96D4-12D7A4150597', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '738B98DB-0C9D-49BE-8CFA-732E4B6B0FC6')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('738B98DB-0C9D-49BE-8CFA-732E4B6B0FC6', N'MET/CAL', N'Manage Licenses', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '21D818F6-89E3-4F59-B3EF-E3FFD12325A2')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('21D818F6-89E3-4F59-B3EF-E3FFD12325A2', 'FD8E1F20-3E2F-4C7D-8D24-965F18A5A3E0', '738B98DB-0C9D-49BE-8CFA-732E4B6B0FC6', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '8902A712-E97D-42B1-AEFF-4240165C885F')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('8902A712-E97D-42B1-AEFF-4240165C885F', N'MET/CAL', N'Manage Security Groups and Permissions', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '54D33839-260D-4C5A-B6A5-E1E2A93F2C57')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('54D33839-260D-4C5A-B6A5-E1E2A93F2C57', 'FD8E1F20-3E2F-4C7D-8D24-965F18A5A3E0', '8902A712-E97D-42B1-AEFF-4240165C885F', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '5B5126EC-17F8-4730-BC98-53F4993C19C2')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('5B5126EC-17F8-4730-BC98-53F4993C19C2', N'MET/CAL', N'Change Password', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '7FB0A61D-B200-495F-84A6-AC8636F09E22')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('7FB0A61D-B200-495F-84A6-AC8636F09E22', 'E319DC4D-C16F-43C7-AA75-97896B9CC8C1', '5B5126EC-17F8-4730-BC98-53F4993C19C2', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = 'F1FBCCA8-AE94-41FA-AC14-48C215F90F7C')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('F1FBCCA8-AE94-41FA-AC14-48C215F90F7C', 'FD8E1F20-3E2F-4C7D-8D24-965F18A5A3E0', '5B5126EC-17F8-4730-BC98-53F4993C19C2', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = 'D35E594C-1FFE-4CE4-A7B5-B353A2BE4A28')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('D35E594C-1FFE-4CE4-A7B5-B353A2BE4A28', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', '5B5126EC-17F8-4730-BC98-53F4993C19C2', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '6C2FDD45-2961-4000-9D64-19A60FF08927')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('6C2FDD45-2961-4000-9D64-19A60FF08927', N'MET/CAL', N'Mobile Check Out', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = '1E32177F-BF3D-409F-BC1D-46956593AB1F')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('1E32177F-BF3D-409F-BC1D-46956593AB1F', 'E319DC4D-C16F-43C7-AA75-97896B9CC8C1', '6C2FDD45-2961-4000-9D64-19A60FF08927', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'AF7C7CE5-35AF-437F-9483-D81492EC2C54')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('AF7C7CE5-35AF-437F-9483-D81492EC2C54', N'MET/CAL', N'Run Editor', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE [nSecurityGroupFieldLinkUID] = 'FDC16BC5-E48F-4F5C-BDC5-763694FBD251')
	BEGIN
		PRINT N'Inserting SecurityGroupFieldLink'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('FDC16BC5-E48F-4F5C-BDC5-763694FBD251', '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', 'AF7C7CE5-35AF-437F-9483-D81492EC2C54', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210317 23:46:27.403','20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>METCON-2231<<--
	IF OBJECT_ID(N'[dbo].[spl_Mobile_UndoCheckOut_Workstation]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_UndoCheckOut_Workstation]'
		DROP PROCEDURE [dbo].[spl_Mobile_UndoCheckOut_Workstation]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_UndoCheckOut_Workstation]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_UndoCheckOut_Workstation]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_UndoCheckOut_Workstation]
AS
BEGIN
	DELETE FROM [dbo].[PackageHistory] 
	WHERE lActive = -1
	
	TRUNCATE TABLE [dbo].[LicenseDetails]

	UPDATE [dbo].[Servers] 
	SET 
		mNotes=NULL, 
		cExportLocation=NULL

	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_UndoCheckOut_Server]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_UndoCheckOut_Server]'
		DROP PROCEDURE [dbo].[spl_Mobile_UndoCheckOut_Server]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_UndoCheckOut_Server]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_UndoCheckOut_Server]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_UndoCheckOut_Server]
	@cWorkstation nvarchar(50)
AS
BEGIN
	DELETE FROM [dbo].[LicenseDetails] 
	WHERE cWorkstation = @cWorkstation
	
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	-->>METCON-2140<<--
	IF OBJECT_ID(N'[dbo].[spl_Mobile_Assets_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Assets_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_Assets_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Assets_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Assets_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Assets_GetAllUIDs]
AS
BEGIN
	SELECT
		[nAssetUID]
	FROM
		[dbo].[Assets]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_AssetServices_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_AssetServices_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_AssetServices_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_AssetServices_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_AssetServices_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_AssetServices_GetAllUIDs]
AS
BEGIN
	SELECT
		[nAssetServiceUID]
	FROM
		[dbo].[AssetServices]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetEx_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetEx_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetEx_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetEx_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetEx_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetEx_GetAllUIDs]
AS
BEGIN
	SELECT
		[nCallSheetExUID]
	FROM
		[dbo].[CallSheetEx]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultEx_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResultEx_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResultEx_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultEx_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResultEx_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResultEx_GetAllUIDs]
AS
BEGIN
	SELECT
		[nCallSheetResultExUID]
	FROM
		[dbo].[CallSheetResultEx]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResults_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResults_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResults_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResults_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResults_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResults_GetAllUIDs]
AS
BEGIN
	SELECT
		[nCallSheetResultUID]
	FROM
		[dbo].[CallSheetResults]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheets_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheets_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheets_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheets_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheets_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheets_GetAllUIDs]
AS
BEGIN
	SELECT
		[nCallSheetUID]
	FROM
		[dbo].[CallSheets]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetStandardLink_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetStandardLink_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetStandardLink_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetStandardLink_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetStandardLink_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetStandardLink_GetAllUIDs]
AS
BEGIN
	SELECT
		[nCallSheetStandardLinkUID]
	FROM
		[dbo].[CallSheetStandardLink]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Labor_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Labor_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_Labor_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Labor_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Labor_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Labor_GetAllUIDs]
AS
BEGIN
	SELECT
		[nLaborUID]
	FROM
		[dbo].[Labor]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PackageHistory_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PackageHistory_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_PackageHistory_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PackageHistory_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PackageHistory_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PackageHistory_GetAllUIDs]
AS
BEGIN
	SELECT
		[nPackageHistoryUID]
	FROM
		[dbo].[PackageHistory]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExLogicals_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExLogicals_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExLogicals_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExLogicals_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExLogicals_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExLogicals_GetAllUIDs]
AS
BEGIN
	SELECT
		[nPointExLogicalUID]
	FROM
		[dbo].[PointExLogicals]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExNumerics_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExNumerics_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExNumerics_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExNumerics_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExNumerics_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExNumerics_GetAllUIDs]
AS
BEGIN
	SELECT
		[nPointExNumericUID]
	FROM
		[dbo].[PointExNumerics]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExStrings_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExStrings_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExStrings_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExStrings_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExStrings_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExStrings_GetAllUIDs]
AS
BEGIN
	SELECT
		[nPointExStringUID]
	FROM
		[dbo].[PointExStrings]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointReadings_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointReadings_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointReadings_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointReadings_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointReadings_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointReadings_GetAllUIDs]
AS
BEGIN
	SELECT
		[nPointReadingUID]
	FROM
		[dbo].[PointReadings]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Points_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Points_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_Points_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Points_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Points_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Points_GetAllUIDs]
AS
BEGIN
	SELECT
		[nPointUID]
	FROM
		[dbo].[Points]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointStatistics_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointStatistics_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointStatistics_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointStatistics_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointStatistics_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointStatistics_GetAllUIDs]
AS
BEGIN
	SELECT
		[nPointStatisticUID]
	FROM
		[dbo].[PointStatistics]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointTolerances_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointTolerances_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointTolerances_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointTolerances_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointTolerances_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointTolerances_GetAllUIDs]
AS
BEGIN
	SELECT
		[nPointToleranceUID]
	FROM
		[dbo].[PointTolerances]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointUncertainties_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointUncertainties_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointUncertainties_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointUncertainties_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointUncertainties_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointUncertainties_GetAllUIDs]
AS
BEGIN
	SELECT
		[nPointUncertaintyUID]
	FROM
		[dbo].[PointUncertainties]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Procedures_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Procedures_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_Procedures_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Procedures_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Procedures_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Procedures_GetAllUIDs]
AS
BEGIN
	SELECT
		[nProcedureUID]
	FROM
		[dbo].[Procedures]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUIDs]
AS
BEGIN
	SELECT
		[nSecurityGroupFieldLinkUID]
	FROM
		[dbo].[SecurityGroupFieldLinks]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupMembers_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroupMembers_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroupMembers_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupMembers_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroupMembers_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroupMembers_GetAllUIDs]
AS
BEGIN
	SELECT
		[nSecurityGroupMemberUID]
	FROM
		[dbo].[SecurityGroupMembers]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroups_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroups_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroups_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroups_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroups_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroups_GetAllUIDs]
AS
BEGIN
	SELECT
		[nSecurityGroupUID]
	FROM
		[dbo].[SecurityGroups]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_UCIData_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_UCIData_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_UCIData_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_UCIData_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_UCIData_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_UCIData_GetAllUIDs]
AS
BEGIN
	SELECT
		[nUCIDataUID]
	FROM
		[dbo].[UCIData]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Units_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Units_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_Units_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Units_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Units_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Units_GetAllUIDs]
AS
BEGIN
	SELECT
		[nUnitUID]
	FROM
		[dbo].[Units]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Users_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Users_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_Users_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Users_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Users_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Users_GetAllUIDs]
AS
BEGIN
	SELECT
		[nUserUID]
	FROM
		[dbo].[Users]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Workstations_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Workstations_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_Workstations_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Workstations_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Workstations_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Workstations_GetAllUIDs]
AS
BEGIN
	SELECT
		[nWorkstationUID]
	FROM
		[dbo].[Workstations]
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Assets_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Assets_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_Assets_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Assets_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Assets_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Assets_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nAssetUID]
		,[nFacilityUID]
		,[nTypeUID]
		,[cBarcode]
		,[cID]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[Assets]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_AssetServices_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_AssetServices_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_AssetServices_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_AssetServices_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_AssetServices_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_AssetServices_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nAssetServiceUID]
		,[nAssetUID]
		,[nServiceTypeUID]
		,[cInterval]
		,[cIntervalUOM]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[AssetServices]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetEx_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetEx_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetEx_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetEx_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetEx_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetEx_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nCallSheetExUID]
		,[nCallSheetUID]
		,[cField4]
		,[cField5]
		,[tField6]
		,[nField3]
		,[nField11]
		,[nField12]
		,[nField13]
		,[nField14]
		,[nField29]
		,[lField3]
		,[lField6]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[CallSheetEx]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultEx_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResultEx_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResultEx_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultEx_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResultEx_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResultEx_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nCallSheetResultExUID]
		,[nCallSheetResultUID]
		,[cField049]
		,[cField050]
		,[mField001]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[CallSheetResultEx]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResults_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResults_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResults_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResults_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResults_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResults_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nCallSheetResultUID]
		,[nCallSheetUID]
		,[nProcedureUID]
		,[nTechnicianUID]
		,[nRunAtFacilityUID]
		,[nCallSheetResultOrdinal]
		,[cWorkstationName]
		,[cDescription]
		,[cStatus]
		,[cDataOrigin]
		,[cCallSheetResultType]
		,[tStartTime]
		,[tEndTime]
		,[mNotes]
		,[lRun]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[CallSheetResults]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheets_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheets_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheets_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheets_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheets_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheets_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nCallSheetUID]
		,[nAssetUID]
		,[nTypeUID]
		,[nFacilityUID]
		,[nDepartmentUID]
		,[nWorkingFacilityUID]
		,[nOwningLabUID]
		,[nCategoryUID]
		,[nProcedureUID]
		,[nAssignedTechUID]
		,[nTechnicianUID]
		,[nQCApprovedByUID]
		,[nReturnedByUID]
		,[nSubContractorUID]
		,[cCallSheetType]
		,[cCallSheetStatus]
		,[cCallSheetNumber]
		,[cInterval]
		,[cIntervalUOM]
		,[cWorkOrderResults]
		,[tOpenDate]
		,[tMaintDate]
		,[tMaintNextDate]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[CallSheets]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetStandardLink_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetStandardLink_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetStandardLink_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetStandardLink_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetStandardLink_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetStandardLink_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nCallSheetStandardLinkUID]
		,[nCallSheetUID]
		,[nAssetUID]
		,[tMaintDate]
		,[tMaintNextDate]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[CallSheetStandardLink]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Labor_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Labor_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_Labor_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Labor_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Labor_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Labor_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nLaborUID]
		,[nCallSheetUID]
		,[nUserUID]
		,[nDuration]
		,[tStartTime]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[Labor]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PackageHistory_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PackageHistory_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_PackageHistory_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PackageHistory_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PackageHistory_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PackageHistory_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nPackageHistoryUID]
		,[nServerUID]
		,[nWorkstationUID]
 		,[nPackageNumber]
		,[cSourceName]
		,[nPackageType]
		,[tExportDate]
		,[tImportDate]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[PackageHistory]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExLogicals_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExLogicals_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExLogicals_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExLogicals_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExLogicals_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExLogicals_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nPointExLogicalUID]
		,[nPointUID]
		,[lField001]
		,[lField002]
		,[lField003]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[PointExLogicals]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExNumerics_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExNumerics_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExNumerics_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExNumerics_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExNumerics_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExNumerics_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nPointExNumericUID]
		,[nPointUID]
		,[nField001]
		,[nField001UnitUID]
		,[nField001FormatUID]
		,[nField002]
		,[nField002UnitUID]
		,[nField002FormatUID]
		,[nField003]
		,[nField003UnitUID]
		,[nField003FormatUID]
		,[nField004]
		,[nField004UnitUID]
		,[nField004FormatUID]
		,[nField005]
		,[nField005UnitUID]
		,[nField005FormatUID]
		,[nField006]
		,[nField006UnitUID]
		,[nField006FormatUID]
		,[nField007]
		,[nField007UnitUID]
		,[nField007FormatUID]
		,[nField008]
		,[nField008UnitUID]
		,[nField008FormatUID]
		,[nField009]
		,[nField009UnitUID]
		,[nField009FormatUID]
		,[nField010]
		,[nField010UnitUID]
		,[nField010FormatUID]
		,[nField011]
		,[nField011UnitUID]
		,[nField011FormatUID]
		,[nField012]
		,[nField012UnitUID]
		,[nField012FormatUID]
		,[nField013]
		,[nField013UnitUID]
		,[nField013FormatUID]
		,[nField014]
		,[nField014UnitUID]
		,[nField014FormatUID]
		,[nField015]
		,[nField015UnitUID]
		,[nField015FormatUID]
		,[nField016]
		,[nField016UnitUID]
		,[nField016FormatUID]
		,[nField017]
		,[nField017UnitUID]
		,[nField017FormatUID]
		,[nField018]
		,[nField018UnitUID]
		,[nField018FormatUID]
		,[nField019]
		,[nField019UnitUID]
		,[nField019FormatUID]
		,[nField020]
		,[nField020UnitUID]
		,[nField020FormatUID]
		,[nField021]
		,[nField021UnitUID]
		,[nField021FormatUID]
		,[nField022]
		,[nField022UnitUID]
		,[nField022FormatUID]
		,[nField023]
		,[nField023UnitUID]
		,[nField023FormatUID]
		,[nField024]
		,[nField024UnitUID]
		,[nField024FormatUID]
		,[nField025]
		,[nField025UnitUID]
		,[nField025FormatUID]
		,[nField026]
		,[nField026UnitUID]
		,[nField026FormatUID]
		,[nField027]
		,[nField027UnitUID]
		,[nField027FormatUID]
		,[nField028]
		,[nField028UnitUID]
		,[nField028FormatUID]
		,[nField029]
		,[nField029UnitUID]
		,[nField029FormatUID]
		,[nField030]
		,[nField030UnitUID]
		,[nField030FormatUID]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[PointExNumerics]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExStrings_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExStrings_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExStrings_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExStrings_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExStrings_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExStrings_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nPointExStringUID]
		,[nPointUID]
		,[cField001]
		,[cField002]
		,[cField003]
		,[cField004]
		,[cField005]
		,[cField006]
		,[cField007]
		,[cField008]
		,[cField009]
		,[cField010]
		,[cField011]
		,[cField012]
		,[cField013]
		,[cField014]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[PointExStrings]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointReadings_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointReadings_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointReadings_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointReadings_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointReadings_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointReadings_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nPointReadingUID]
		,[nPointUID]
		,[nAssetUID]
		,[nReadingUnitUID]
		,[nReadingFormatUID]
		,[tReadingDateTime]
		,[nReadingOrdinal]
		,[nReading]
		,[cReadingUnit]
		,[cReadingLabel]
		,[cReadingType]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[PointReadings]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Points_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Points_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_Points_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Points_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Points_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Points_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nPointUID]
		,[nCallSheetResultUID]
		,[nManualTemplateRowUID]
		,[nUUTUnitUID]
		,[nUUTFormatUID]
		,[nReferenceUnitUID]
		,[nReferenceFormatUID]
		,[nCardinalPointUnitUID]
		,[nCardinalPointFormatUID]
		,[nCorrectionUnitUID]
		,[nCorrectionFormatUID]
		,[nUUTRangeUnitUID]
		,[nUUTRangeFormatUID]
		,[nSystemAccuracyUnitUID]
		,[nSystemAccuracyFormatUID]
		,[nTemplateItemUID]
		,[nPointOrdinal]
		,[tPointDateTime]
		,[cPointLabel]
		,[cPointStatusFlags]
		,[cPointPassFailStatus]
		,[cFunctionSelectCode]
		,[nUUT]
		,[nReference]
		,[nCardinalPoint]
		,[nCorrection]
		,[cPointDescription]
		,[cRemarks]
		,[cOverrideRemarks]
		,[cDesignation]
		,[cTagId]
		,[nUUTRange]
		,[nSetTime]
		,[cCondition]
		,[nSystemAccuracy]
		,[nClaim]
		,[lAccredited]
		,[lPrinted]
		,[lUUTIsFixed]
		,[lOverride]
		,[lHeader]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[Points]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointStatistics_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointStatistics_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointStatistics_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointStatistics_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointStatistics_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointStatistics_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nPointStatisticUID]
		,[nPointUID]
		,[nMinimumUUTUnitUID]
		,[nMinimumUUTFormatUID]
		,[nMaximumUUTUnitUID]
		,[nMaximumUUTFormatUID]
		,[nMinimumReferenceUnitUID]
		,[nMinimumReferenceFormatUID]
		,[nMaximumReferenceUnitUID]
		,[nMaximumReferenceFormatUID]
		,[nUUTStandardDeviationUnitUID]
		,[nUUTStandardDeviationFormatUID]
		,[nUUTRawStandardDeviationUnitUID]
		,[nUUTRawStandardDeviationFormatUID]
		,[nReferenceStandardDeviationUnitUID]
		,[nReferenceStandardDeviationFormatUID]
		,[nReference2StandardDeviationUnitUID]
		,[nReference2StandardDeviationFormatUID]
		,[nReferenceRawStandardDeviationUnitUID]
		,[nReferenceRawStandardDeviationFormatUID]
		,[nReferenceRaw2StandardDeviationUnitUID]
		,[nReferenceRaw2StandardDeviationFormatUID]
		,[nSampleRateUnitUID]
		,[nSampleRateFormatUID]
		,[nMinimumUUT]
		,[nMaximumUUT]
		,[nMinimumReference]
		,[nMaximumReference]
		,[nUUTStandardDeviation]
		,[nUUTRawStandardDeviation]
		,[nReferenceStandardDeviation]
		,[nReference2StandardDeviation]
		,[nReferenceRawStandardDeviation]
		,[nReferenceRaw2StandardDeviation]
		,[nNumberOfSamplesReference]
		,[nNumberOfSamplesUUT]
		,[nNumberOfSamplesDiscarded]
		,[nSampleRate]
		,[nChiSquared]
		,[lNoisy]
		,[lReliable]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[PointStatistics]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointTolerances_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointTolerances_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointTolerances_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointTolerances_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointTolerances_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointTolerances_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nPointToleranceUID]
		,[nPointUID]
		,[nToleranceUnitUID]
		,[nToleranceFormatUID]
		,[nTolerancePositiveUnitUID]
		,[nTolerancePositiveFormatUID]
		,[nToleranceNegativeUnitUID]
		,[nToleranceNegativeFormatUID]
		,[nReferenceToleranceUnitUID]
		,[nReferenceToleranceFormatUID]
		,[nErrorUnitUID]
		,[nErrorFormatUID]
		,[nToleranceErrorUnitUID]
		,[nToleranceErrorFormatUID]
		,[nTolerance]
		,[nTolerancePositive]
		,[nToleranceNegative]
		,[cToleranceReference]
		,[nReferenceTolerance]
		,[nReadingErrorPercent]
		,[nReadingErrorReferencePercent]
		,[nFullScaleErrorPercent]
		,[nFullScaleErrorReferencePercent]
		,[nSetErrorPercent]
		,[nSetFullScaleErrorPercent]
		,[nToleranceErrorPercent]
		,[nError]
		,[nToleranceError]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[PointTolerances]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointUncertainties_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointUncertainties_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointUncertainties_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointUncertainties_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointUncertainties_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointUncertainties_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nPointUncertaintyUID]
		,[nPointUID]
		,[nGuardBandLowerUnitUID]
		,[nGuardBandLowerFormatUID]
		,[nGuardBandUpperUnitUID]
		,[nGuardBandUpperFormatUID]
		,[nUncertaintyUnitUID]
		,[nUncertaintyFormatUID]
		,[nUncertaintyExpandedUnitUID]
		,[nUncertaintyExpandedFormatUID]
		,[nUncertaintyDominantUnitUID]
		,[nUncertaintyDominantFormatUID]
		,[nUncertaintyStandardUnitUID]
		,[nUncertaintyStandardFormatUID]
		,[nLowerLimitUnitUID]
		,[nLowerLimitFormatUID]
		,[nUpperLimitUnitUID]
		,[nUpperLimitFormatUID]
		,[nUncertaintyParameter1UnitUID]
		,[nUncertaintyParameter1FormatUID]
		,[nUncertaintyParameter2UnitUID]
		,[nUncertaintyParameter2FormatUID]
		,[nUncertaintyParameter3UnitUID]
		,[nUncertaintyParameter3FormatUID]
		,[nUncertaintyParameter4UnitUID]
		,[nUncertaintyParameter4FormatUID]
		,[nUncertaintyParameter5UnitUID]
		,[nUncertaintyParameter5FormatUID]
		,[nUncertaintyParameter6UnitUID]
		,[nUncertaintyParameter6FormatUID]
		,[nUncertaintyParameter7UnitUID]
		,[nUncertaintyParameter7FormatUID]
		,[nUncertaintyParameter8UnitUID]
		,[nUncertaintyParameter8FormatUID]
		,[nUncertaintyParameter9UnitUID]
		,[nUncertaintyParameter9FormatUID]
		,[nUncertaintyParameter10UnitUID]
		,[nUncertaintyParameter10FormatUID]
		,[nModifier1UnitUID]
		,[nModifier1FormatUID]
		,[nModifier2UnitUID]
		,[nModifier2FormatUID]
		,[nS1UnitUID]
		,[nS1FormatUID]
		,[nS2UnitUID]
		,[nS2FormatUID]
		,[cGuardBandMethod]
		,[nGuardBandLower]
		,[nGuardBandUpper]
		,[cUncertaintyMethod]
		,[nUncertainty]
		,[nUncertaintyExpanded]
		,[nUncertaintyDominant]
		,[nUncertaintyStandard]
		,[nLowerLimit]
		,[nUpperLimit]
		,[nCoverageFactor]
		,[nSystemCoverageFactor]
		,[nConfidenceLevel]
		,[cStudentsT]
		,[nUncertaintyParameter1]
		,[nUncertaintyParameter2]
		,[nUncertaintyParameter3]
		,[nUncertaintyParameter4]
		,[nUncertaintyParameter5]
		,[nUncertaintyParameter6]
		,[nUncertaintyParameter7]
		,[nUncertaintyParameter8]
		,[nUncertaintyParameter9]
		,[nUncertaintyParameter10]
		,[cSensitivity1]
		,[cSensitivity2]
		,[cSensitivity3]
		,[cSensitivity4]
		,[cSensitivity5]
		,[cSensitivity6]
		,[cSensitivity7]
		,[cSensitivity8]
		,[cSensitivity9]
		,[cSensitivity10]
		,[cDegreesOfFreedom1]
		,[cDegreesOfFreedom2]
		,[cDegreesOfFreedom3]
		,[cDegreesOfFreedom4]
		,[cDegreesOfFreedom5]
		,[cDegreesOfFreedom6]
		,[cDegreesOfFreedom7]
		,[cDegreesOfFreedom8]
		,[cDegreesOfFreedom9]
		,[cDegreesOfFreedom10]
		,[nModifier1]
		,[nModifier2]
		,[nS1]
		,[nS2]
		,[cEquilibrationParameters]
		,[lStudentsT]
		,[lDominant]
		,[lWelchSatterthwaite]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[PointUncertainties]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Procedures_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Procedures_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_Procedures_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Procedures_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Procedures_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Procedures_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nProcedureUID]
		,[nCategoryUID]
		,[cProcedureName]
		,[cProcedureType]
		,[cRevision]
		,[tProcedureDate]
		,[tRevisionDate]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[Procedures]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroupFieldLinks_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nSecurityGroupFieldLinkUID]
		,[nSecurityGroupUID]
		,[nUCIDataUID]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[SecurityGroupFieldLinks]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupMembers_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroupMembers_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroupMembers_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupMembers_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroupMembers_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroupMembers_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nSecurityGroupMemberUID]
		,[nSecurityGroupUID]
		,[nUserUID]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[SecurityGroupMembers]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroups_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroups_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroups_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroups_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroups_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroups_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nSecurityGroupUID]
		,[cGroupName]
		,[lSystemGroup]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[SecurityGroups]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_UCIData_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_UCIData_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_UCIData_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_UCIData_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_UCIData_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_UCIData_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nUCIDataUID]
		,[cModel]
		,[cField]
		,[cProperty]
		,[cValue]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[UCIData]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Units_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Units_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_Units_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Units_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Units_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Units_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nUnitUID]
		,[nUnitType]
		,[cUnitSymbol]
		,[cBaseUnit]
		,[cPrefix]
		,[cAtTemperature]
		,[cReferenceImpedence]
		,[nCode]
		,[nConversionFactor]
		,[nScale]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[Units]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Users_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Users_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_Users_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Users_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Users_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Users_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nUserUID]
		,[cFirstName]
		,[cLastName]
		,[cInitials]
		,[cUsername]
		,[cPassword]
		,[tLastLogin]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[Users]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Workstations_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Workstations_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_Workstations_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Workstations_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Workstations_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Workstations_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nWorkstationUID]
		,[cWorkstationName]
		,[cWorkstationId]
		,[cUserName]
		,[cMobileId]
		,[cRemoteServer]
		,[cMode]
		,[tLoginDate]
		,[tLastLogin]
		,[tMobileLoginDate]
		,[tCheckoutDate]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[Workstations]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Assets_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Assets_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_Assets_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Assets_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Assets_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Assets_Insert]
    @nAssetUID uniqueidentifier
	,@nFacilityUID uniqueidentifier
	,@nTypeUID uniqueidentifier
	,@cBarcode nvarchar(100)  = NULL
	,@cID nvarchar(100)  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime

AS
BEGIN
	INSERT INTO [dbo].[Assets] (
		[nAssetUID]
		,[nFacilityUID]
		,[nTypeUID]
		,[cBarcode]
		,[cID]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nAssetUID
		,@nFacilityUID
		,@nTypeUID
		,@cBarcode
		,@cID

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_AssetServices_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_AssetServices_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_AssetServices_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_AssetServices_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_AssetServices_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_AssetServices_Insert]
	@nAssetServiceUID uniqueidentifier
	,@nAssetUID uniqueidentifier
	,@nServiceTypeUID uniqueidentifier
	,@cInterval nvarchar(50)  = NULL
	,@cIntervalUOM nvarchar(50)  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[AssetServices] (
		[nAssetServiceUID]
		,[nAssetUID]
		,[nServiceTypeUID]
		,[cInterval]
		,[cIntervalUOM]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nAssetServiceUID
		,@nAssetUID
		,@nServiceTypeUID
		,@cInterval
		,@cIntervalUOM

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetEx_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetEx_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetEx_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetEx_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetEx_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetEx_Insert]
	@nCallSheetExUID uniqueidentifier
	,@nCallSheetUID uniqueidentifier
	,@cField4 nvarchar(50)  = NULL
	,@cField5 nvarchar(50)  = NULL
	,@tField6 datetime  = NULL
	,@nField3 numeric(18, 2)  = NULL
	,@nField11 numeric(18, 2)  = NULL
	,@nField12 numeric(18, 2)  = NULL
	,@nField13 numeric(18, 2)  = NULL
	,@nField14 numeric(18, 2)  = NULL
	,@nField29 numeric(18, 2)  = NULL
	,@lField3 int  = NULL
	,@lField6 int  = NULL


	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[CallSheetEx] (
		[nCallSheetExUID]
		,[nCallSheetUID]
		,[cField4]
		,[cField5]
		,[tField6]
		,[nField3]
		,[nField11]
		,[nField12]
		,[nField13]
		,[nField14]
		,[nField29]
		,[lField3]
		,[lField6]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nCallSheetExUID
		,@nCallSheetUID
		,@cField4
		,@cField5
		,@tField6
		,@nField3
		,@nField11
		,@nField12
		,@nField13
		,@nField14
		,@nField29
		,@lField3
		,@lField6

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultEx_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResultEx_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResultEx_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultEx_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResultEx_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResultEx_Insert]
	@nCallSheetResultExUID uniqueidentifier
	,@nCallSheetResultUID uniqueidentifier
	,@cField049 nvarchar(255)  = NULL
	,@cField050 nvarchar(255)  = NULL
	,@mField001 nvarchar(max)  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[CallSheetResultEx] (
		[nCallSheetResultExUID]
		,[nCallSheetResultUID]
		,[cField049]
		,[cField050]
		,[mField001]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nCallSheetResultExUID
		,@nCallSheetResultUID
		,@cField049
		,@cField050
		,@mField001

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResults_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResults_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResults_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResults_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResults_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResults_Insert]
	@nCallSheetResultUID uniqueidentifier
	,@nCallSheetUID uniqueidentifier
	,@nProcedureUID uniqueidentifier  = NULL
	,@nTechnicianUID uniqueidentifier  = NULL
	,@nRunAtFacilityUID uniqueidentifier = NULL
	,@nCallSheetResultOrdinal numeric(18, 0)
	,@cWorkstationName nvarchar(50)  = NULL
	,@cDescription nvarchar(300)  = NULL
	,@cStatus nvarchar(50)  = NULL
	,@cDataOrigin nvarchar(50)  = NULL
	,@cCallSheetResultType nvarchar(50)  = NULL
	,@tStartTime datetime  = NULL
	,@tEndTime datetime  = NULL
	,@mNotes nvarchar(max) = NULL
	,@lRun int  = 0

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[CallSheetResults] (
		[nCallSheetResultUID]
		,[nCallSheetUID]
		,[nProcedureUID]
		,[nTechnicianUID]
		,[nRunAtFacilityUID]
		,[nCallSheetResultOrdinal]
		,[cWorkstationName]
		,[cDescription]
		,[cStatus]
		,[cDataOrigin]
		,[cCallSheetResultType]
		,[tStartTime]
		,[tEndTime]
		,[mNotes]
		,[lRun]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nCallSheetResultUID
		,@nCallSheetUID
		,@nProcedureUID
		,@nTechnicianUID
		,@nRunAtFacilityUID
		,@nCallSheetResultOrdinal
		,@cWorkstationName
		,@cDescription
		,@cStatus
		,@cDataOrigin
		,@cCallSheetResultType
		,@tStartTime
		,@tEndTime
		,@mNotes
		,@lRun

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheets_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheets_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheets_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheets_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheets_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheets_Insert]
	@nCallSheetUID uniqueidentifier
	,@nAssetUID uniqueidentifier = NULL
	,@nTypeUID uniqueidentifier = NULL
	,@nFacilityUID uniqueidentifier = NULL
	,@nDepartmentUID uniqueidentifier = NULL
	,@nWorkingFacilityUID uniqueidentifier = NULL
	,@nOwningLabUID uniqueidentifier = NULL
	,@nCategoryUID uniqueidentifier = NULL
	,@nProcedureUID uniqueidentifier  = NULL
	,@nAssignedTechUID uniqueidentifier  = NULL
	,@nTechnicianUID uniqueidentifier  = NULL
	,@nQCApprovedByUID uniqueidentifier  = NULL
	,@nReturnedByUID uniqueidentifier  = NULL
	,@nSubContractorUID uniqueidentifier  = NULL
	,@cCallSheetType nvarchar(50)  = NULL
	,@cCallSheetStatus nvarchar(50) = NULL
	,@cCallSheetNumber nvarchar(50)  = NULL
	,@cInterval nvarchar(50)  = NULL
	,@cIntervalUOM nvarchar(50)  = NULL
	,@cWorkOrderResults nvarchar(50)  = NULL
	,@tOpenDate datetime  = NULL
	,@tMaintDate datetime  = NULL
	,@tMaintNextDate datetime  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[CallSheets] (
		[nCallSheetUID]
		,[nAssetUID]
		,[nTypeUID]
		,[nFacilityUID]
		,[nDepartmentUID]
		,[nWorkingFacilityUID]
		,[nOwningLabUID]
		,[nCategoryUID]
		,[nProcedureUID]
		,[nAssignedTechUID]
		,[nTechnicianUID]
		,[nQCApprovedByUID]
		,[nReturnedByUID]
		,[nSubContractorUID]
		,[cCallSheetType]
		,[cCallSheetStatus]
		,[cCallSheetNumber]
		,[cInterval]
		,[cIntervalUOM]
		,[cWorkOrderResults]
		,[tOpenDate]
		,[tMaintDate]
		,[tMaintNextDate]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nCallSheetUID
		,@nAssetUID
		,@nTypeUID
		,@nFacilityUID
		,@nDepartmentUID
		,@nWorkingFacilityUID
		,@nOwningLabUID
		,@nCategoryUID
		,@nProcedureUID
		,@nAssignedTechUID
		,@nTechnicianUID
		,@nQCApprovedByUID
		,@nReturnedByUID
		,@nSubContractorUID
		,@cCallSheetType
		,@cCallSheetStatus
		,@cCallSheetNumber
		,@cInterval
		,@cIntervalUOM
		,@cWorkOrderResults
		,@tOpenDate
		,@tMaintDate
		,@tMaintNextDate

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetStandardLink_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetStandardLink_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetStandardLink_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetStandardLink_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetStandardLink_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetStandardLink_Insert]
	@nCallSheetStandardLinkUID uniqueidentifier
	,@nCallSheetUID uniqueidentifier  = NULL
	,@nAssetUID uniqueidentifier  = NULL
	,@tMaintDate datetime  = NULL
	,@tMaintNextDate datetime  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[CallSheetStandardLink] (
		[nCallSheetStandardLinkUID]
		,[nCallSheetUID]
		,[nAssetUID]
		,[tMaintDate]
		,[tMaintNextDate]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nCallSheetStandardLinkUID
		,@nCallSheetUID
		,@nAssetUID
		,@tMaintDate
		,@tMaintNextDate

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Labor_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Labor_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_Labor_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Labor_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Labor_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Labor_Insert]
	@nLaborUID uniqueidentifier
	,@nCallSheetUID uniqueidentifier  = NULL
	,@nUserUID uniqueidentifier
	,@nDuration numeric(18, 2)  = 0
	,@tStartTime datetime  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[Labor] (
		[nLaborUID]
		,[nCallSheetUID]
		,[nUserUID]
		,[nDuration]
		,[tStartTime]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nLaborUID
		,@nCallSheetUID
		,@nUserUID
		,@nDuration
		,@tStartTime

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PackageHistory_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PackageHistory_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_PackageHistory_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PackageHistory_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PackageHistory_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PackageHistory_Insert]
	@nPackageHistoryUID uniqueidentifier
	,@nServerUID uniqueidentifier
	,@nWorkstationUID uniqueidentifier  = NULL
	,@nPackageNumber int  = NULL
	,@cSourceName nvarchar(50)  = NULL
	,@nPackageType tinyint
	,@tExportDate datetime  = NULL
	,@tImportDate datetime  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[PackageHistory] (
		[nPackageHistoryUID]
		,[nServerUID]
		,[nWorkstationUID]
		,[nPackageNumber]
		,[cSourceName]
		,[nPackageType]
		,[tExportDate]
		,[tImportDate]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nPackageHistoryUID
		,@nServerUID
		,@nWorkstationUID
		,@nPackageNumber
		,@cSourceName
		,@nPackageType
		,@tExportDate
		,@tImportDate

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExLogicals_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExLogicals_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExLogicals_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExLogicals_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExLogicals_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExLogicals_Insert]
	@nPointExLogicalUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@lField001 int  = NULL
	,@lField002 int  = NULL
	,@lField003 int  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[PointExLogicals] (
		[nPointExLogicalUID]
		,[nPointUID]
		,[lField001]
		,[lField002]
		,[lField003]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nPointExLogicalUID
		,@nPointUID
		,@lField001
		,@lField002
		,@lField003

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExNumerics_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExNumerics_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExNumerics_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExNumerics_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExNumerics_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExNumerics_Insert]
	@nPointExNumericUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@nField001 float  = NULL
	,@nField001UnitUID uniqueidentifier  = NULL
	,@nField001FormatUID uniqueidentifier  = NULL
	,@nField002 float  = NULL
	,@nField002UnitUID uniqueidentifier  = NULL
	,@nField002FormatUID uniqueidentifier  = NULL
	,@nField003 float  = NULL
	,@nField003UnitUID uniqueidentifier  = NULL
	,@nField003FormatUID uniqueidentifier  = NULL
	,@nField004 float  = NULL
	,@nField004UnitUID uniqueidentifier  = NULL
	,@nField004FormatUID uniqueidentifier  = NULL
	,@nField005 float  = NULL
	,@nField005UnitUID uniqueidentifier  = NULL
	,@nField005FormatUID uniqueidentifier  = NULL
	,@nField006 float  = NULL
	,@nField006UnitUID uniqueidentifier  = NULL
	,@nField006FormatUID uniqueidentifier  = NULL
	,@nField007 float  = NULL
	,@nField007UnitUID uniqueidentifier  = NULL
	,@nField007FormatUID uniqueidentifier  = NULL
	,@nField008 float  = NULL
	,@nField008UnitUID uniqueidentifier  = NULL
	,@nField008FormatUID uniqueidentifier  = NULL
	,@nField009 float  = NULL
	,@nField009UnitUID uniqueidentifier  = NULL
	,@nField009FormatUID uniqueidentifier  = NULL
	,@nField010 float  = NULL
	,@nField010UnitUID uniqueidentifier  = NULL
	,@nField010FormatUID uniqueidentifier  = NULL
	,@nField011 float  = NULL
	,@nField011UnitUID uniqueidentifier  = NULL
	,@nField011FormatUID uniqueidentifier  = NULL
	,@nField012 float  = NULL
	,@nField012UnitUID uniqueidentifier  = NULL
	,@nField012FormatUID uniqueidentifier  = NULL
	,@nField013 float  = NULL
	,@nField013UnitUID uniqueidentifier  = NULL
	,@nField013FormatUID uniqueidentifier  = NULL
	,@nField014 float  = NULL
	,@nField014UnitUID uniqueidentifier  = NULL
	,@nField014FormatUID uniqueidentifier  = NULL
	,@nField015 float  = NULL
	,@nField015UnitUID uniqueidentifier  = NULL
	,@nField015FormatUID uniqueidentifier  = NULL
	,@nField016 float  = NULL
	,@nField016UnitUID uniqueidentifier  = NULL
	,@nField016FormatUID uniqueidentifier  = NULL
	,@nField017 float  = NULL
	,@nField017UnitUID uniqueidentifier  = NULL
	,@nField017FormatUID uniqueidentifier  = NULL
	,@nField018 float  = NULL
	,@nField018UnitUID uniqueidentifier  = NULL
	,@nField018FormatUID uniqueidentifier  = NULL
	,@nField019 float  = NULL
	,@nField019UnitUID uniqueidentifier  = NULL
	,@nField019FormatUID uniqueidentifier  = NULL
	,@nField020 float  = NULL
	,@nField020UnitUID uniqueidentifier  = NULL
	,@nField020FormatUID uniqueidentifier  = NULL
	,@nField021 float  = NULL
	,@nField021UnitUID uniqueidentifier  = NULL
	,@nField021FormatUID uniqueidentifier  = NULL
	,@nField022 float  = NULL
	,@nField022UnitUID uniqueidentifier  = NULL
	,@nField022FormatUID uniqueidentifier  = NULL
	,@nField023 float  = NULL
	,@nField023UnitUID uniqueidentifier  = NULL
	,@nField023FormatUID uniqueidentifier  = NULL
	,@nField024 float  = NULL
	,@nField024UnitUID uniqueidentifier  = NULL
	,@nField024FormatUID uniqueidentifier  = NULL
	,@nField025 float  = NULL
	,@nField025UnitUID uniqueidentifier  = NULL
	,@nField025FormatUID uniqueidentifier  = NULL
	,@nField026 float  = NULL
	,@nField026UnitUID uniqueidentifier  = NULL
	,@nField026FormatUID uniqueidentifier  = NULL
	,@nField027 float  = NULL
	,@nField027UnitUID uniqueidentifier  = NULL
	,@nField027FormatUID uniqueidentifier  = NULL
	,@nField028 float  = NULL
	,@nField028UnitUID uniqueidentifier  = NULL
	,@nField028FormatUID uniqueidentifier  = NULL
	,@nField029 float  = NULL
	,@nField029UnitUID uniqueidentifier  = NULL
	,@nField029FormatUID uniqueidentifier  = NULL
	,@nField030 float  = NULL
	,@nField030UnitUID uniqueidentifier  = NULL
	,@nField030FormatUID uniqueidentifier  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[PointExNumerics] (
		[nPointExNumericUID]
		,[nPointUID]
		,[nField001]
		,[nField001UnitUID]
		,[nField001FormatUID]
		,[nField002]
		,[nField002UnitUID]
		,[nField002FormatUID]
		,[nField003]
		,[nField003UnitUID]
		,[nField003FormatUID]
		,[nField004]
		,[nField004UnitUID]
		,[nField004FormatUID]
		,[nField005]
		,[nField005UnitUID]
		,[nField005FormatUID]
		,[nField006]
		,[nField006UnitUID]
		,[nField006FormatUID]
		,[nField007]
		,[nField007UnitUID]
		,[nField007FormatUID]
		,[nField008]
		,[nField008UnitUID]
		,[nField008FormatUID]
		,[nField009]
		,[nField009UnitUID]
		,[nField009FormatUID]
		,[nField010]
		,[nField010UnitUID]
		,[nField010FormatUID]
		,[nField011]
		,[nField011UnitUID]
		,[nField011FormatUID]
		,[nField012]
		,[nField012UnitUID]
		,[nField012FormatUID]
		,[nField013]
		,[nField013UnitUID]
		,[nField013FormatUID]
		,[nField014]
		,[nField014UnitUID]
		,[nField014FormatUID]
		,[nField015]
		,[nField015UnitUID]
		,[nField015FormatUID]
		,[nField016]
		,[nField016UnitUID]
		,[nField016FormatUID]
		,[nField017]
		,[nField017UnitUID]
		,[nField017FormatUID]
		,[nField018]
		,[nField018UnitUID]
		,[nField018FormatUID]
		,[nField019]
		,[nField019UnitUID]
		,[nField019FormatUID]
		,[nField020]
		,[nField020UnitUID]
		,[nField020FormatUID]
		,[nField021]
		,[nField021UnitUID]
		,[nField021FormatUID]
		,[nField022]
		,[nField022UnitUID]
		,[nField022FormatUID]
		,[nField023]
		,[nField023UnitUID]
		,[nField023FormatUID]
		,[nField024]
		,[nField024UnitUID]
		,[nField024FormatUID]
		,[nField025]
		,[nField025UnitUID]
		,[nField025FormatUID]
		,[nField026]
		,[nField026UnitUID]
		,[nField026FormatUID]
		,[nField027]
		,[nField027UnitUID]
		,[nField027FormatUID]
		,[nField028]
		,[nField028UnitUID]
		,[nField028FormatUID]
		,[nField029]
		,[nField029UnitUID]
		,[nField029FormatUID]
		,[nField030]
		,[nField030UnitUID]
		,[nField030FormatUID]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nPointExNumericUID
		,@nPointUID
		,@nField001
		,@nField001UnitUID
		,@nField001FormatUID
		,@nField002
		,@nField002UnitUID
		,@nField002FormatUID
		,@nField003
		,@nField003UnitUID
		,@nField003FormatUID
		,@nField004
		,@nField004UnitUID
		,@nField004FormatUID
		,@nField005
		,@nField005UnitUID
		,@nField005FormatUID
		,@nField006
		,@nField006UnitUID
		,@nField006FormatUID
		,@nField007
		,@nField007UnitUID
		,@nField007FormatUID
		,@nField008
		,@nField008UnitUID
		,@nField008FormatUID
		,@nField009
		,@nField009UnitUID
		,@nField009FormatUID
		,@nField010
		,@nField010UnitUID
		,@nField010FormatUID
		,@nField011
		,@nField011UnitUID
		,@nField011FormatUID
		,@nField012
		,@nField012UnitUID
		,@nField012FormatUID
		,@nField013
		,@nField013UnitUID
		,@nField013FormatUID
		,@nField014
		,@nField014UnitUID
		,@nField014FormatUID
		,@nField015
		,@nField015UnitUID
		,@nField015FormatUID
		,@nField016
		,@nField016UnitUID
		,@nField016FormatUID
		,@nField017
		,@nField017UnitUID
		,@nField017FormatUID
		,@nField018
		,@nField018UnitUID
		,@nField018FormatUID
		,@nField019
		,@nField019UnitUID
		,@nField019FormatUID
		,@nField020
		,@nField020UnitUID
		,@nField020FormatUID
		,@nField021
		,@nField021UnitUID
		,@nField021FormatUID
		,@nField022
		,@nField022UnitUID
		,@nField022FormatUID
		,@nField023
		,@nField023UnitUID
		,@nField023FormatUID
		,@nField024
		,@nField024UnitUID
		,@nField024FormatUID
		,@nField025
		,@nField025UnitUID
		,@nField025FormatUID
		,@nField026
		,@nField026UnitUID
		,@nField026FormatUID
		,@nField027
		,@nField027UnitUID
		,@nField027FormatUID
		,@nField028
		,@nField028UnitUID
		,@nField028FormatUID
		,@nField029
		,@nField029UnitUID
		,@nField029FormatUID
		,@nField030
		,@nField030UnitUID
		,@nField030FormatUID

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExStrings_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExStrings_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExStrings_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExStrings_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExStrings_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExStrings_Insert]
	@nPointExStringUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@cField001 nvarchar(255)  = NULL
	,@cField002 nvarchar(255)  = NULL
	,@cField003 nvarchar(255)  = NULL
	,@cField004 nvarchar(255)  = NULL
	,@cField005 nvarchar(255)  = NULL
	,@cField006 nvarchar(255)  = NULL
	,@cField007 nvarchar(255)  = NULL
	,@cField008 nvarchar(255)  = NULL
	,@cField009 nvarchar(255)  = NULL
	,@cField010 nvarchar(255)  = NULL
	,@cField011 nvarchar(255)  = NULL
	,@cField012 nvarchar(255)  = NULL
	,@cField013 nvarchar(255)  = NULL
	,@cField014 nvarchar(255)  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[PointExStrings] (
		[nPointExStringUID]
		,[nPointUID]
		,[cField001]
		,[cField002]
		,[cField003]
		,[cField004]
		,[cField005]
		,[cField006]
		,[cField007]
		,[cField008]
		,[cField009]
		,[cField010]
		,[cField011]
		,[cField012]
		,[cField013]
		,[cField014]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nPointExStringUID
		,@nPointUID
		,@cField001
		,@cField002
		,@cField003
		,@cField004
		,@cField005
		,@cField006
		,@cField007
		,@cField008
		,@cField009
		,@cField010
		,@cField011
		,@cField012
		,@cField013
		,@cField014

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointReadings_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointReadings_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointReadings_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointReadings_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointReadings_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointReadings_Insert]
	@nPointReadingUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@nAssetUID uniqueidentifier
	,@nReadingUnitUID uniqueidentifier  = NULL
	,@nReadingFormatUID uniqueidentifier  = NULL
	,@tReadingDateTime datetime  = NULL
	,@nReadingOrdinal int  = NULL
	,@nReading float  = NULL
	,@cReadingUnit nvarchar(50)  = NULL
	,@cReadingLabel nvarchar(50)  = NULL
	,@cReadingType nvarchar(50)  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[PointReadings] (
		[nPointReadingUID]
		,[nPointUID]
		,[nAssetUID]
		,[nReadingUnitUID]
		,[nReadingFormatUID]
		,[tReadingDateTime]
		,[nReadingOrdinal]
		,[nReading]
		,[cReadingUnit]
		,[cReadingLabel]
		,[cReadingType]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nPointReadingUID
		,@nPointUID
		,@nAssetUID
		,@nReadingUnitUID
		,@nReadingFormatUID
		,@tReadingDateTime
		,@nReadingOrdinal
		,@nReading
		,@cReadingUnit
		,@cReadingLabel
		,@cReadingType

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Points_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Points_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_Points_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Points_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Points_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Points_Insert]
	@nPointUID uniqueidentifier
	,@nCallSheetResultUID uniqueidentifier
	,@nManualTemplateRowUID uniqueidentifier  = NULL
	,@nUUTUnitUID uniqueidentifier  = NULL
	,@nUUTFormatUID uniqueidentifier  = NULL
	,@nReferenceUnitUID uniqueidentifier  = NULL
	,@nReferenceFormatUID uniqueidentifier  = NULL
	,@nCardinalPointUnitUID uniqueidentifier  = NULL
	,@nCardinalPointFormatUID uniqueidentifier  = NULL
	,@nCorrectionUnitUID uniqueidentifier  = NULL
	,@nCorrectionFormatUID uniqueidentifier  = NULL
	,@nUUTRangeUnitUID uniqueidentifier  = NULL
	,@nUUTRangeFormatUID uniqueidentifier  = NULL
	,@nSystemAccuracyUnitUID uniqueidentifier  = NULL
	,@nSystemAccuracyFormatUID uniqueidentifier  = NULL
	,@nTemplateItemUID uniqueidentifier  = NULL
	,@nPointOrdinal int  = NULL
	,@tPointDateTime datetime  = NULL
	,@cPointLabel nvarchar(150)  = NULL
	,@cPointStatusFlags nvarchar(50)  = NULL
	,@cPointPassFailStatus nvarchar(50)  = NULL
	,@cFunctionSelectCode nvarchar(50)  = NULL
	,@nUUT float  = NULL
	,@nReference float  = NULL
	,@nCardinalPoint float  = NULL
	,@nCorrection float  = NULL
	,@cPointDescription nvarchar(300)  = NULL
	,@cRemarks nvarchar(300)  = NULL
	,@cOverrideRemarks nvarchar(300)  = NULL
	,@cDesignation nvarchar(10)  = NULL
	,@cTagId nvarchar(50)  = NULL
	,@nUUTRange float  = NULL
	,@nSetTime float  = NULL
	,@cCondition nvarchar(50)  = NULL
	,@nSystemAccuracy float  = NULL
	,@nClaim numeric(18, 0)  = NULL
	,@lAccredited int
	,@lPrinted int
	,@lUUTIsFixed int
	,@lOverride int
	,@lHeader int  = 0

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[Points] (
		[nPointUID]
		,[nCallSheetResultUID]
		,[nManualTemplateRowUID]
		,[nUUTUnitUID]
		,[nUUTFormatUID]
		,[nReferenceUnitUID]
		,[nReferenceFormatUID]
		,[nCardinalPointUnitUID]
		,[nCardinalPointFormatUID]
		,[nCorrectionUnitUID]
		,[nCorrectionFormatUID]
		,[nUUTRangeUnitUID]
		,[nUUTRangeFormatUID]
		,[nSystemAccuracyUnitUID]
		,[nSystemAccuracyFormatUID]
		,[nTemplateItemUID]
		,[nPointOrdinal]
		,[tPointDateTime]
		,[cPointLabel]
		,[cPointStatusFlags]
		,[cPointPassFailStatus]
		,[cFunctionSelectCode]
		,[nUUT]
		,[nReference]
		,[nCardinalPoint]
		,[nCorrection]
		,[cPointDescription]
		,[cRemarks]
		,[cOverrideRemarks]
		,[cDesignation]
		,[cTagId]
		,[nUUTRange]
		,[nSetTime]
		,[cCondition]
		,[nSystemAccuracy]
		,[nClaim]
		,[lAccredited]
		,[lPrinted]
		,[lUUTIsFixed]
		,[lOverride]
		,[lHeader]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nPointUID
		,@nCallSheetResultUID
		,@nManualTemplateRowUID
		,@nUUTUnitUID
		,@nUUTFormatUID
		,@nReferenceUnitUID
		,@nReferenceFormatUID
		,@nCardinalPointUnitUID
		,@nCardinalPointFormatUID
		,@nCorrectionUnitUID
		,@nCorrectionFormatUID
		,@nUUTRangeUnitUID
		,@nUUTRangeFormatUID
		,@nSystemAccuracyUnitUID
		,@nSystemAccuracyFormatUID
		,@nTemplateItemUID
		,@nPointOrdinal
		,@tPointDateTime
		,@cPointLabel
		,@cPointStatusFlags
		,@cPointPassFailStatus
		,@cFunctionSelectCode
		,@nUUT
		,@nReference
		,@nCardinalPoint
		,@nCorrection
		,@cPointDescription
		,@cRemarks
		,@cOverrideRemarks
		,@cDesignation
		,@cTagId
		,@nUUTRange
		,@nSetTime
		,@cCondition
		,@nSystemAccuracy
		,@nClaim
		,@lAccredited
		,@lPrinted
		,@lUUTIsFixed
		,@lOverride
		,@lHeader

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointStatistics_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointStatistics_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointStatistics_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointStatistics_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointStatistics_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointStatistics_Insert]
	@nPointStatisticUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@nMinimumUUTUnitUID uniqueidentifier  = NULL
	,@nMinimumUUTFormatUID uniqueidentifier  = NULL
	,@nMaximumUUTUnitUID uniqueidentifier  = NULL
	,@nMaximumUUTFormatUID uniqueidentifier  = NULL
	,@nMinimumReferenceUnitUID uniqueidentifier  = NULL
	,@nMinimumReferenceFormatUID uniqueidentifier  = NULL
	,@nMaximumReferenceUnitUID uniqueidentifier  = NULL
	,@nMaximumReferenceFormatUID uniqueidentifier  = NULL
	,@nUUTStandardDeviationUnitUID uniqueidentifier  = NULL
	,@nUUTStandardDeviationFormatUID uniqueidentifier  = NULL
	,@nUUTRawStandardDeviationUnitUID uniqueidentifier  = NULL
	,@nUUTRawStandardDeviationFormatUID uniqueidentifier  = NULL
	,@nReferenceStandardDeviationUnitUID uniqueidentifier  = NULL
	,@nReferenceStandardDeviationFormatUID uniqueidentifier  = NULL
	,@nReference2StandardDeviationUnitUID uniqueidentifier  = NULL
	,@nReference2StandardDeviationFormatUID uniqueidentifier  = NULL
	,@nReferenceRawStandardDeviationUnitUID uniqueidentifier  = NULL
	,@nReferenceRawStandardDeviationFormatUID uniqueidentifier  = NULL
	,@nReferenceRaw2StandardDeviationUnitUID uniqueidentifier  = NULL
	,@nReferenceRaw2StandardDeviationFormatUID uniqueidentifier  = NULL
	,@nSampleRateUnitUID uniqueidentifier  = NULL
	,@nSampleRateFormatUID uniqueidentifier  = NULL
	,@nMinimumUUT float  = NULL
	,@nMaximumUUT float  = NULL
	,@nMinimumReference float  = NULL
	,@nMaximumReference float  = NULL
	,@nUUTStandardDeviation float  = NULL
	,@nUUTRawStandardDeviation float  = NULL
	,@nReferenceStandardDeviation float  = NULL
	,@nReference2StandardDeviation float  = NULL
	,@nReferenceRawStandardDeviation float  = NULL
	,@nReferenceRaw2StandardDeviation float  = NULL
	,@nNumberOfSamplesReference int  = NULL
	,@nNumberOfSamplesUUT int  = 1
	,@nNumberOfSamplesDiscarded int  = 0
	,@nSampleRate float  = NULL
	,@nChiSquared float  = NULL
	,@lNoisy int
	,@lReliable int

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[PointStatistics] (
		[nPointStatisticUID]
		,[nPointUID]
		,[nMinimumUUTUnitUID]
		,[nMinimumUUTFormatUID]
		,[nMaximumUUTUnitUID]
		,[nMaximumUUTFormatUID]
		,[nMinimumReferenceUnitUID]
		,[nMinimumReferenceFormatUID]
		,[nMaximumReferenceUnitUID]
		,[nMaximumReferenceFormatUID]
		,[nUUTStandardDeviationUnitUID]
		,[nUUTStandardDeviationFormatUID]
		,[nUUTRawStandardDeviationUnitUID]
		,[nUUTRawStandardDeviationFormatUID]
		,[nReferenceStandardDeviationUnitUID]
		,[nReferenceStandardDeviationFormatUID]
		,[nReference2StandardDeviationUnitUID]
		,[nReference2StandardDeviationFormatUID]
		,[nReferenceRawStandardDeviationUnitUID]
		,[nReferenceRawStandardDeviationFormatUID]
		,[nReferenceRaw2StandardDeviationUnitUID]
		,[nReferenceRaw2StandardDeviationFormatUID]
		,[nSampleRateUnitUID]
		,[nSampleRateFormatUID]
		,[nMinimumUUT]
		,[nMaximumUUT]
		,[nMinimumReference]
		,[nMaximumReference]
		,[nUUTStandardDeviation]
		,[nUUTRawStandardDeviation]
		,[nReferenceStandardDeviation]
		,[nReference2StandardDeviation]
		,[nReferenceRawStandardDeviation]
		,[nReferenceRaw2StandardDeviation]
		,[nNumberOfSamplesReference]
		,[nNumberOfSamplesUUT]
		,[nNumberOfSamplesDiscarded]
		,[nSampleRate]
		,[nChiSquared]
		,[lNoisy]
		,[lReliable]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nPointStatisticUID
		,@nPointUID
		,@nMinimumUUTUnitUID
		,@nMinimumUUTFormatUID
		,@nMaximumUUTUnitUID
		,@nMaximumUUTFormatUID
		,@nMinimumReferenceUnitUID
		,@nMinimumReferenceFormatUID
		,@nMaximumReferenceUnitUID
		,@nMaximumReferenceFormatUID
		,@nUUTStandardDeviationUnitUID
		,@nUUTStandardDeviationFormatUID
		,@nUUTRawStandardDeviationUnitUID
		,@nUUTRawStandardDeviationFormatUID
		,@nReferenceStandardDeviationUnitUID
		,@nReferenceStandardDeviationFormatUID
		,@nReference2StandardDeviationUnitUID
		,@nReference2StandardDeviationFormatUID
		,@nReferenceRawStandardDeviationUnitUID
		,@nReferenceRawStandardDeviationFormatUID
		,@nReferenceRaw2StandardDeviationUnitUID
		,@nReferenceRaw2StandardDeviationFormatUID
		,@nSampleRateUnitUID
		,@nSampleRateFormatUID
		,@nMinimumUUT
		,@nMaximumUUT
		,@nMinimumReference
		,@nMaximumReference
		,@nUUTStandardDeviation
		,@nUUTRawStandardDeviation
		,@nReferenceStandardDeviation
		,@nReference2StandardDeviation
		,@nReferenceRawStandardDeviation
		,@nReferenceRaw2StandardDeviation
		,@nNumberOfSamplesReference
		,@nNumberOfSamplesUUT
		,@nNumberOfSamplesDiscarded
		,@nSampleRate
		,@nChiSquared
		,@lNoisy
		,@lReliable

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointTolerances_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointTolerances_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointTolerances_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointTolerances_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointTolerances_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointTolerances_Insert]
	@nPointToleranceUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@nToleranceUnitUID uniqueidentifier  = NULL
	,@nToleranceFormatUID uniqueidentifier  = NULL
	,@nTolerancePositiveUnitUID uniqueidentifier  = NULL
	,@nTolerancePositiveFormatUID uniqueidentifier  = NULL
	,@nToleranceNegativeUnitUID uniqueidentifier  = NULL
	,@nToleranceNegativeFormatUID uniqueidentifier  = NULL
	,@nReferenceToleranceUnitUID uniqueidentifier  = NULL
	,@nReferenceToleranceFormatUID uniqueidentifier  = NULL
	,@nErrorUnitUID uniqueidentifier  = NULL
	,@nErrorFormatUID uniqueidentifier  = NULL
	,@nToleranceErrorUnitUID uniqueidentifier  = NULL
	,@nToleranceErrorFormatUID uniqueidentifier  = NULL
	,@nTolerance float  = NULL
	,@nTolerancePositive float  = NULL
	,@nToleranceNegative float  = NULL
	,@cToleranceReference nvarchar(50)  = NULL
	,@nReferenceTolerance float  = NULL
	,@nReadingErrorPercent float  = NULL
	,@nReadingErrorReferencePercent float  = NULL
	,@nFullScaleErrorPercent float  = NULL
	,@nFullScaleErrorReferencePercent float  = NULL
	,@nSetErrorPercent float  = NULL
	,@nSetFullScaleErrorPercent float  = NULL
	,@nToleranceErrorPercent float  = NULL
	,@nError float  = NULL
	,@nToleranceError float  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[PointTolerances] (
		[nPointToleranceUID]
		,[nPointUID]
		,[nToleranceUnitUID]
		,[nToleranceFormatUID]
		,[nTolerancePositiveUnitUID]
		,[nTolerancePositiveFormatUID]
		,[nToleranceNegativeUnitUID]
		,[nToleranceNegativeFormatUID]
		,[nReferenceToleranceUnitUID]
		,[nReferenceToleranceFormatUID]
		,[nErrorUnitUID]
		,[nErrorFormatUID]
		,[nToleranceErrorUnitUID]
		,[nToleranceErrorFormatUID]
		,[nTolerance]
		,[nTolerancePositive]
		,[nToleranceNegative]
		,[cToleranceReference]
		,[nReferenceTolerance]
		,[nReadingErrorPercent]
		,[nReadingErrorReferencePercent]
		,[nFullScaleErrorPercent]
		,[nFullScaleErrorReferencePercent]
		,[nSetErrorPercent]
		,[nSetFullScaleErrorPercent]
		,[nToleranceErrorPercent]
		,[nError]
		,[nToleranceError]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nPointToleranceUID
		,@nPointUID
		,@nToleranceUnitUID
		,@nToleranceFormatUID
		,@nTolerancePositiveUnitUID
		,@nTolerancePositiveFormatUID
		,@nToleranceNegativeUnitUID
		,@nToleranceNegativeFormatUID
		,@nReferenceToleranceUnitUID
		,@nReferenceToleranceFormatUID
		,@nErrorUnitUID
		,@nErrorFormatUID
		,@nToleranceErrorUnitUID
		,@nToleranceErrorFormatUID
		,@nTolerance
		,@nTolerancePositive
		,@nToleranceNegative
		,@cToleranceReference
		,@nReferenceTolerance
		,@nReadingErrorPercent
		,@nReadingErrorReferencePercent
		,@nFullScaleErrorPercent
		,@nFullScaleErrorReferencePercent
		,@nSetErrorPercent
		,@nSetFullScaleErrorPercent
		,@nToleranceErrorPercent
		,@nError
		,@nToleranceError

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointUncertainties_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointUncertainties_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointUncertainties_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointUncertainties_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointUncertainties_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointUncertainties_Insert]
	@nPointUncertaintyUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@nGuardBandLowerUnitUID uniqueidentifier  = NULL
	,@nGuardBandLowerFormatUID uniqueidentifier  = NULL
	,@nGuardBandUpperUnitUID uniqueidentifier  = NULL
	,@nGuardBandUpperFormatUID uniqueidentifier  = NULL
	,@nUncertaintyUnitUID uniqueidentifier  = NULL
	,@nUncertaintyFormatUID uniqueidentifier  = NULL
	,@nUncertaintyExpandedUnitUID uniqueidentifier  = NULL
	,@nUncertaintyExpandedFormatUID uniqueidentifier  = NULL
	,@nUncertaintyDominantUnitUID uniqueidentifier  = NULL
	,@nUncertaintyDominantFormatUID uniqueidentifier  = NULL
	,@nUncertaintyStandardUnitUID uniqueidentifier  = NULL
	,@nUncertaintyStandardFormatUID uniqueidentifier  = NULL
	,@nLowerLimitUnitUID uniqueidentifier  = NULL
	,@nLowerLimitFormatUID uniqueidentifier  = NULL
	,@nUpperLimitUnitUID uniqueidentifier  = NULL
	,@nUpperLimitFormatUID uniqueidentifier  = NULL
	,@nUncertaintyParameter1UnitUID uniqueidentifier  = NULL
	,@nUncertaintyParameter1FormatUID uniqueidentifier  = NULL
	,@nUncertaintyParameter2UnitUID uniqueidentifier  = NULL
	,@nUncertaintyParameter2FormatUID uniqueidentifier  = NULL
	,@nUncertaintyParameter3UnitUID uniqueidentifier  = NULL
	,@nUncertaintyParameter3FormatUID uniqueidentifier  = NULL
	,@nUncertaintyParameter4UnitUID uniqueidentifier  = NULL
	,@nUncertaintyParameter4FormatUID uniqueidentifier  = NULL
	,@nUncertaintyParameter5UnitUID uniqueidentifier  = NULL
	,@nUncertaintyParameter5FormatUID uniqueidentifier  = NULL
	,@nUncertaintyParameter6UnitUID uniqueidentifier  = NULL
	,@nUncertaintyParameter6FormatUID uniqueidentifier  = NULL
	,@nUncertaintyParameter7UnitUID uniqueidentifier  = NULL
	,@nUncertaintyParameter7FormatUID uniqueidentifier  = NULL
	,@nUncertaintyParameter8UnitUID uniqueidentifier  = NULL
	,@nUncertaintyParameter8FormatUID uniqueidentifier  = NULL
	,@nUncertaintyParameter9UnitUID uniqueidentifier  = NULL
	,@nUncertaintyParameter9FormatUID uniqueidentifier  = NULL
	,@nUncertaintyParameter10UnitUID uniqueidentifier  = NULL
	,@nUncertaintyParameter10FormatUID uniqueidentifier  = NULL
	,@nModifier1UnitUID uniqueidentifier  = NULL
	,@nModifier1FormatUID uniqueidentifier  = NULL
	,@nModifier2UnitUID uniqueidentifier  = NULL
	,@nModifier2FormatUID uniqueidentifier  = NULL
	,@nS1UnitUID uniqueidentifier  = NULL
	,@nS1FormatUID uniqueidentifier  = NULL
	,@nS2UnitUID uniqueidentifier  = NULL
	,@nS2FormatUID uniqueidentifier  = NULL
	,@cGuardBandMethod nvarchar(32)  = NULL
	,@nGuardBandLower float  = NULL
	,@nGuardBandUpper float  = NULL
	,@cUncertaintyMethod nvarchar(50)  = NULL
	,@nUncertainty float  = NULL
	,@nUncertaintyExpanded float  = NULL
	,@nUncertaintyDominant float  = NULL
	,@nUncertaintyStandard float  = NULL
	,@nLowerLimit float  = NULL
	,@nUpperLimit float  = NULL
	,@nCoverageFactor float  = NULL
	,@nSystemCoverageFactor float  = NULL
	,@nConfidenceLevel float  = NULL
	,@cStudentsT nvarchar(32)  = NULL
	,@nUncertaintyParameter1 float  = NULL
	,@nUncertaintyParameter2 float  = NULL
	,@nUncertaintyParameter3 float  = NULL
	,@nUncertaintyParameter4 float  = NULL
	,@nUncertaintyParameter5 float  = NULL
	,@nUncertaintyParameter6 float  = NULL
	,@nUncertaintyParameter7 float  = NULL
	,@nUncertaintyParameter8 float  = NULL
	,@nUncertaintyParameter9 float  = NULL
	,@nUncertaintyParameter10 float  = NULL
	,@cSensitivity1 nvarchar(32)  = NULL
	,@cSensitivity2 nvarchar(32)  = NULL
	,@cSensitivity3 nvarchar(32)  = NULL
	,@cSensitivity4 nvarchar(32)  = NULL
	,@cSensitivity5 nvarchar(32)  = NULL
	,@cSensitivity6 nvarchar(32)  = NULL
	,@cSensitivity7 nvarchar(32)  = NULL
	,@cSensitivity8 nvarchar(32)  = NULL
	,@cSensitivity9 nvarchar(32)  = NULL
	,@cSensitivity10 nvarchar(32)  = NULL
	,@cDegreesOfFreedom1 nvarchar(16)  = NULL
	,@cDegreesOfFreedom2 nvarchar(16)  = NULL
	,@cDegreesOfFreedom3 nvarchar(16)  = NULL
	,@cDegreesOfFreedom4 nvarchar(16)  = NULL
	,@cDegreesOfFreedom5 nvarchar(16)  = NULL
	,@cDegreesOfFreedom6 nvarchar(16)  = NULL
	,@cDegreesOfFreedom7 nvarchar(16)  = NULL
	,@cDegreesOfFreedom8 nvarchar(16)  = NULL
	,@cDegreesOfFreedom9 nvarchar(16)  = NULL
	,@cDegreesOfFreedom10 nvarchar(16)  = NULL
	,@nModifier1 float  = NULL
	,@nModifier2 float  = NULL
	,@nS1 float  = NULL
	,@nS2 float  = NULL
	,@cEquilibrationParameters nvarchar(50)  = NULL
	,@lStudentsT int
	,@lDominant int
	,@lWelchSatterthwaite int  = 0

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[PointUncertainties] (
		[nPointUncertaintyUID]
		,[nPointUID]
		,[nGuardBandLowerUnitUID]
		,[nGuardBandLowerFormatUID]
		,[nGuardBandUpperUnitUID]
		,[nGuardBandUpperFormatUID]
		,[nUncertaintyUnitUID]
		,[nUncertaintyFormatUID]
		,[nUncertaintyExpandedUnitUID]
		,[nUncertaintyExpandedFormatUID]
		,[nUncertaintyDominantUnitUID]
		,[nUncertaintyDominantFormatUID]
		,[nUncertaintyStandardUnitUID]
		,[nUncertaintyStandardFormatUID]
		,[nLowerLimitUnitUID]
		,[nLowerLimitFormatUID]
		,[nUpperLimitUnitUID]
		,[nUpperLimitFormatUID]
		,[nUncertaintyParameter1UnitUID]
		,[nUncertaintyParameter1FormatUID]
		,[nUncertaintyParameter2UnitUID]
		,[nUncertaintyParameter2FormatUID]
		,[nUncertaintyParameter3UnitUID]
		,[nUncertaintyParameter3FormatUID]
		,[nUncertaintyParameter4UnitUID]
		,[nUncertaintyParameter4FormatUID]
		,[nUncertaintyParameter5UnitUID]
		,[nUncertaintyParameter5FormatUID]
		,[nUncertaintyParameter6UnitUID]
		,[nUncertaintyParameter6FormatUID]
		,[nUncertaintyParameter7UnitUID]
		,[nUncertaintyParameter7FormatUID]
		,[nUncertaintyParameter8UnitUID]
		,[nUncertaintyParameter8FormatUID]
		,[nUncertaintyParameter9UnitUID]
		,[nUncertaintyParameter9FormatUID]
		,[nUncertaintyParameter10UnitUID]
		,[nUncertaintyParameter10FormatUID]
		,[nModifier1UnitUID]
		,[nModifier1FormatUID]
		,[nModifier2UnitUID]
		,[nModifier2FormatUID]
		,[nS1UnitUID]
		,[nS1FormatUID]
		,[nS2UnitUID]
		,[nS2FormatUID]
		,[cGuardBandMethod]
		,[nGuardBandLower]
		,[nGuardBandUpper]
		,[cUncertaintyMethod]
		,[nUncertainty]
		,[nUncertaintyExpanded]
		,[nUncertaintyDominant]
		,[nUncertaintyStandard]
		,[nLowerLimit]
		,[nUpperLimit]
		,[nCoverageFactor]
		,[nSystemCoverageFactor]
		,[nConfidenceLevel]
		,[cStudentsT]
		,[nUncertaintyParameter1]
		,[nUncertaintyParameter2]
		,[nUncertaintyParameter3]
		,[nUncertaintyParameter4]
		,[nUncertaintyParameter5]
		,[nUncertaintyParameter6]
		,[nUncertaintyParameter7]
		,[nUncertaintyParameter8]
		,[nUncertaintyParameter9]
		,[nUncertaintyParameter10]
		,[cSensitivity1]
		,[cSensitivity2]
		,[cSensitivity3]
		,[cSensitivity4]
		,[cSensitivity5]
		,[cSensitivity6]
		,[cSensitivity7]
		,[cSensitivity8]
		,[cSensitivity9]
		,[cSensitivity10]
		,[cDegreesOfFreedom1]
		,[cDegreesOfFreedom2]
		,[cDegreesOfFreedom3]
		,[cDegreesOfFreedom4]
		,[cDegreesOfFreedom5]
		,[cDegreesOfFreedom6]
		,[cDegreesOfFreedom7]
		,[cDegreesOfFreedom8]
		,[cDegreesOfFreedom9]
		,[cDegreesOfFreedom10]
		,[nModifier1]
		,[nModifier2]
		,[nS1]
		,[nS2]
		,[cEquilibrationParameters]
		,[lStudentsT]
		,[lDominant]
		,[lWelchSatterthwaite]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nPointUncertaintyUID
		,@nPointUID
		,@nGuardBandLowerUnitUID
		,@nGuardBandLowerFormatUID
		,@nGuardBandUpperUnitUID
		,@nGuardBandUpperFormatUID
		,@nUncertaintyUnitUID
		,@nUncertaintyFormatUID
		,@nUncertaintyExpandedUnitUID
		,@nUncertaintyExpandedFormatUID
		,@nUncertaintyDominantUnitUID
		,@nUncertaintyDominantFormatUID
		,@nUncertaintyStandardUnitUID
		,@nUncertaintyStandardFormatUID
		,@nLowerLimitUnitUID
		,@nLowerLimitFormatUID
		,@nUpperLimitUnitUID
		,@nUpperLimitFormatUID
		,@nUncertaintyParameter1UnitUID
		,@nUncertaintyParameter1FormatUID
		,@nUncertaintyParameter2UnitUID
		,@nUncertaintyParameter2FormatUID
		,@nUncertaintyParameter3UnitUID
		,@nUncertaintyParameter3FormatUID
		,@nUncertaintyParameter4UnitUID
		,@nUncertaintyParameter4FormatUID
		,@nUncertaintyParameter5UnitUID
		,@nUncertaintyParameter5FormatUID
		,@nUncertaintyParameter6UnitUID
		,@nUncertaintyParameter6FormatUID
		,@nUncertaintyParameter7UnitUID
		,@nUncertaintyParameter7FormatUID
		,@nUncertaintyParameter8UnitUID
		,@nUncertaintyParameter8FormatUID
		,@nUncertaintyParameter9UnitUID
		,@nUncertaintyParameter9FormatUID
		,@nUncertaintyParameter10UnitUID
		,@nUncertaintyParameter10FormatUID
		,@nModifier1UnitUID
		,@nModifier1FormatUID
		,@nModifier2UnitUID
		,@nModifier2FormatUID
		,@nS1UnitUID
		,@nS1FormatUID
		,@nS2UnitUID
		,@nS2FormatUID
		,@cGuardBandMethod
		,@nGuardBandLower
		,@nGuardBandUpper
		,@cUncertaintyMethod
		,@nUncertainty
		,@nUncertaintyExpanded
		,@nUncertaintyDominant
		,@nUncertaintyStandard
		,@nLowerLimit
		,@nUpperLimit
		,@nCoverageFactor
		,@nSystemCoverageFactor
		,@nConfidenceLevel
		,@cStudentsT
		,@nUncertaintyParameter1
		,@nUncertaintyParameter2
		,@nUncertaintyParameter3
		,@nUncertaintyParameter4
		,@nUncertaintyParameter5
		,@nUncertaintyParameter6
		,@nUncertaintyParameter7
		,@nUncertaintyParameter8
		,@nUncertaintyParameter9
		,@nUncertaintyParameter10
		,@cSensitivity1
		,@cSensitivity2
		,@cSensitivity3
		,@cSensitivity4
		,@cSensitivity5
		,@cSensitivity6
		,@cSensitivity7
		,@cSensitivity8
		,@cSensitivity9
		,@cSensitivity10
		,@cDegreesOfFreedom1
		,@cDegreesOfFreedom2
		,@cDegreesOfFreedom3
		,@cDegreesOfFreedom4
		,@cDegreesOfFreedom5
		,@cDegreesOfFreedom6
		,@cDegreesOfFreedom7
		,@cDegreesOfFreedom8
		,@cDegreesOfFreedom9
		,@cDegreesOfFreedom10
		,@nModifier1
		,@nModifier2
		,@nS1
		,@nS2
		,@cEquilibrationParameters
		,@lStudentsT
		,@lDominant
		,@lWelchSatterthwaite

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Procedures_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Procedures_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_Procedures_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Procedures_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Procedures_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Procedures_Insert]
	@nProcedureUID uniqueidentifier
	,@nCategoryUID uniqueidentifier  = NULL
	,@cProcedureName nvarchar(150)  = NULL
	,@cProcedureType nvarchar(50)  = NULL
	,@cRevision nvarchar(100)  = NULL
	,@tProcedureDate datetime  = NULL
	,@tRevisionDate datetime  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[Procedures] (
		[nProcedureUID]
		,[nCategoryUID]
		,[cProcedureName]
		,[cProcedureType]
		,[cRevision]
		,[tProcedureDate]
		,[tRevisionDate]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nProcedureUID
		,@nCategoryUID
		,@cProcedureName
		,@cProcedureType
		,@cRevision
		,@tProcedureDate
		,@tRevisionDate

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupFieldLinks_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroupFieldLinks_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroupFieldLinks_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupFieldLinks_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroupFieldLinks_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroupFieldLinks_Insert]
	@nSecurityGroupFieldLinkUID uniqueidentifier
	,@nSecurityGroupUID uniqueidentifier
	,@nUCIDataUID uniqueidentifier

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[SecurityGroupFieldLinks] (
		[nSecurityGroupFieldLinkUID]
		,[nSecurityGroupUID]
		,[nUCIDataUID]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nSecurityGroupFieldLinkUID
		,@nSecurityGroupUID
		,@nUCIDataUID

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupMembers_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroupMembers_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroupMembers_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupMembers_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroupMembers_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroupMembers_Insert]
	@nSecurityGroupMemberUID uniqueidentifier
	,@nSecurityGroupUID uniqueidentifier
	,@nUserUID uniqueidentifier

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[SecurityGroupMembers] (
		[nSecurityGroupMemberUID]
		,[nSecurityGroupUID]
		,[nUserUID]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nSecurityGroupMemberUID
		,@nSecurityGroupUID
		,@nUserUID

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroups_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroups_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroups_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroups_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroups_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroups_Insert]
	@nSecurityGroupUID uniqueidentifier
	,@cGroupName nvarchar(50)  = NULL
	,@lSystemGroup int  = 0

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[SecurityGroups] (
		[nSecurityGroupUID]
		,[cGroupName]
		,[lSystemGroup]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nSecurityGroupUID
		,@cGroupName
		,@lSystemGroup

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_UCIData_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_UCIData_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_UCIData_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_UCIData_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_UCIData_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_UCIData_Insert]
	@nUCIDataUID uniqueidentifier
	,@cModel nvarchar(150)  = NULL
	,@cField nvarchar(50)  = NULL
	,@cProperty nvarchar(50)  = NULL
	,@cValue nvarchar(150)  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[UCIData] (
		[nUCIDataUID]
		,[cModel]
		,[cField]
		,[cProperty]
		,[cValue]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nUCIDataUID
		,@cModel
		,@cField
		,@cProperty
		,@cValue

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Units_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Units_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_Units_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Units_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Units_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Units_Insert]
	@nUnitUID uniqueidentifier
	,@nUnitType numeric(18, 0)
	,@cUnitSymbol nvarchar(50)
	,@cBaseUnit nvarchar(50)
	,@cPrefix nchar(1)  = NULL
	,@cAtTemperature nvarchar(50)  = NULL
	,@cReferenceImpedence nvarchar(50)  = NULL
	,@nCode int  = 0
	,@nConversionFactor numeric(25, 6)  = 1
	,@nScale numeric(18, 6)  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[Units] (
		[nUnitUID]
		,[nUnitType]
		,[cUnitSymbol]
		,[cBaseUnit]
		,[cPrefix]
		,[cAtTemperature]
		,[cReferenceImpedence]
		,[nCode]
		,[nConversionFactor]
		,[nScale]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nUnitUID
		,@nUnitType
		,@cUnitSymbol
		,@cBaseUnit
		,@cPrefix
		,@cAtTemperature
		,@cReferenceImpedence
		,@nCode
		,@nConversionFactor
		,@nScale

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Users_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Users_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_Users_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Users_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Users_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Users_Insert]
	@nUserUID uniqueidentifier
	,@cFirstName nvarchar(50)  = NULL
	,@cLastName nvarchar(50)  = NULL
	,@cInitials nvarchar(50)  = NULL
	,@cUsername nvarchar(50)
	,@cPassword nvarchar(100)
	,@tLastLogin datetime  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[Users] (
		[nUserUID]
		,[cFirstName]
		,[cLastName]
		,[cInitials]
		,[cUsername]
		,[cPassword]
		,[tLastLogin]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nUserUID
		,@cFirstName
		,@cLastName
		,@cInitials
		,@cUsername
		,@cPassword
		,@tLastLogin

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Workstations_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Workstations_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_Workstations_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Workstations_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Workstations_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Workstations_Insert]
	@nWorkstationUID uniqueidentifier
	,@cWorkstationName nvarchar(50)
	,@cWorkstationId nvarchar(50)  = NULL
	,@cUserName nvarchar(50)  = NULL
	,@cMobileId nvarchar(5)  = NULL
	,@cRemoteServer nvarchar(100)  = NULL
	,@cMode nvarchar(20)  = NULL
	,@tLoginDate datetime  = NULL
	,@tLastLogin datetime  = NULL
	,@tMobileLoginDate datetime  = NULL
	,@tCheckoutDate datetime  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[Workstations] (
		[nWorkstationUID]
		,[cWorkstationName]
		,[cWorkstationId]
		,[cUserName]
		,[cMobileId]
		,[cRemoteServer]
		,[cMode]
		,[tLoginDate]
		,[tLastLogin]
		,[tMobileLoginDate]
		,[tCheckoutDate]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nWorkstationUID
		,@cWorkstationName
		,@cWorkstationId
		,@cUserName
		,@cMobileId
		,@cRemoteServer
		,@cMode
		,@tLoginDate
		,@tLastLogin
		,@tMobileLoginDate
		,@tCheckoutDate

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Assets_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Assets_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_Assets_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Assets_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Assets_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Assets_Update]
	@nAssetUID uniqueidentifier
	,@nFacilityUID uniqueidentifier
	,@nTypeUID uniqueidentifier
	,@cBarcode nvarchar(100)  = NULL
	,@cID nvarchar(100)  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[Assets]
	SET
		[nFacilityUID] = @nFacilityUID
		,[nTypeUID] = @nTypeUID
		,[cBarcode] = @cBarcode
		,[cID] = @cID

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nAssetUID] = @nAssetUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_AssetServices_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_AssetServices_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_AssetServices_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_AssetServices_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_AssetServices_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_AssetServices_Update]
	@nAssetServiceUID uniqueidentifier
	,@nAssetUID uniqueidentifier
	,@nServiceTypeUID uniqueidentifier
	,@cInterval nvarchar(50)
	,@cIntervalUOM nvarchar(50)

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[AssetServices]
	SET
		[nAssetUID] = @nAssetUID
		,[nServiceTypeUID] = @nServiceTypeUID
		,[cInterval] = @cInterval
		,[cIntervalUOM] = @cIntervalUOM

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nAssetServiceUID] = @nAssetServiceUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetEx_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetEx_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetEx_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetEx_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetEx_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetEx_Update]
	@nCallSheetExUID uniqueidentifier
	,@nCallSheetUID uniqueidentifier
	,@cField4 nvarchar(50)
	,@cField5 nvarchar(50)
	,@tField6 datetime
	,@nField3 numeric(18, 2)
	,@nField11 numeric(18, 2)
	,@nField12 numeric(18, 2)
	,@nField13 numeric(18, 2)
	,@nField14 numeric(18, 2)
	,@nField29 numeric(18, 2)
	,@lField3 int
	,@lField6 int

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[CallSheetEx]
	SET
		[nCallSheetUID] = @nCallSheetUID
		,[cField4] = @cField4
		,[cField5] = @cField5
		,[tField6] = @tField6
		,[nField3] = @nField3
		,[nField11] = @nField11
		,[nField12] = @nField12
		,[nField13] = @nField13
		,[nField14] = @nField14
		,[nField29] = @nField29
		,[lField3] = @lField3
		,[lField6] = @lField6

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nCallSheetExUID] = @nCallSheetExUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultEx_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResultEx_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResultEx_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultEx_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResultEx_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResultEx_Update]
	@nCallSheetResultExUID uniqueidentifier
	,@nCallSheetResultUID uniqueidentifier
	,@cField049 nvarchar(255)
	,@cField050 nvarchar(255)
	,@mField001 nvarchar(max)

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[CallSheetResultEx]
	SET
		[nCallSheetResultUID] = @nCallSheetResultUID
		,[cField049] = @cField049
		,[cField050] = @cField050
		,[mField001] = @mField001

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nCallSheetResultExUID] = @nCallSheetResultExUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResults_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResults_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResults_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResults_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResults_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResults_Update]
	@nCallSheetResultUID uniqueidentifier
	,@nCallSheetUID uniqueidentifier
	,@nProcedureUID uniqueidentifier
	,@nTechnicianUID uniqueidentifier
	,@nRunAtFacilityUID uniqueidentifier
	,@nCallSheetResultOrdinal numeric(18, 0)
	,@cWorkstationName nvarchar(50)
	,@cDescription nvarchar(300)
	,@cStatus nvarchar(50)
	,@cDataOrigin nvarchar(50)
	,@cCallSheetResultType nvarchar(50)
	,@tStartTime datetime
	,@tEndTime datetime
	,@mNotes nvarchar(max)
	,@lRun int

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[CallSheetResults]
	SET
		[nCallSheetUID] = @nCallSheetUID
		,[nProcedureUID] = @nProcedureUID
		,[nTechnicianUID] = @nTechnicianUID
		,[nRunAtFacilityUID] = @nRunAtFacilityUID
		,[nCallSheetResultOrdinal] = @nCallSheetResultOrdinal
		,[cWorkstationName] = @cWorkstationName
		,[cDescription] = @cDescription
		,[cStatus] = @cStatus
		,[cDataOrigin] = @cDataOrigin
		,[cCallSheetResultType] = @cCallSheetResultType
		,[tStartTime] = @tStartTime
		,[tEndTime] = @tEndTime
		,[mNotes] = @mNotes
		,[lRun] = @lRun

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nCallSheetResultUID] = @nCallSheetResultUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheets_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheets_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheets_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheets_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheets_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheets_Update]
	@nCallSheetUID uniqueidentifier
	,@nAssetUID uniqueidentifier
	,@nTypeUID uniqueidentifier
	,@nFacilityUID uniqueidentifier
	,@nDepartmentUID uniqueidentifier
	,@nWorkingFacilityUID uniqueidentifier
	,@nOwningLabUID uniqueidentifier
	,@nCategoryUID uniqueidentifier
	,@nProcedureUID uniqueidentifier
	,@nAssignedTechUID uniqueidentifier
	,@nTechnicianUID uniqueidentifier
	,@nQCApprovedByUID uniqueidentifier
	,@nReturnedByUID uniqueidentifier
	,@nSubContractorUID uniqueidentifier
	,@cCallSheetType nvarchar(50)
	,@cCallSheetStatus nvarchar(50)
	,@cCallSheetNumber nvarchar(50)
	,@cInterval nvarchar(50)
	,@cIntervalUOM nvarchar(50)
	,@cWorkOrderResults nvarchar(50)
	,@tOpenDate datetime
	,@tMaintDate datetime
	,@tMaintNextDate datetime

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[CallSheets]
	SET
		[nAssetUID] = @nAssetUID
		,[nTypeUID] = @nTypeUID
		,[nFacilityUID] = @nFacilityUID
		,[nDepartmentUID] = @nDepartmentUID
		,[nWorkingFacilityUID] = @nWorkingFacilityUID
		,[nOwningLabUID] = @nOwningLabUID
		,[nCategoryUID] = @nCategoryUID
		,[nProcedureUID] = @nProcedureUID
		,[nAssignedTechUID] = @nAssignedTechUID
		,[nTechnicianUID] = @nTechnicianUID
		,[nQCApprovedByUID] = @nQCApprovedByUID
		,[nReturnedByUID] = @nReturnedByUID
		,[nSubContractorUID] = @nSubContractorUID
		,[cCallSheetType] = @cCallSheetType
		,[cCallSheetStatus] = @cCallSheetStatus
		,[cCallSheetNumber] = @cCallSheetNumber
		,[cInterval] = @cInterval
		,[cIntervalUOM] = @cIntervalUOM
		,[cWorkOrderResults] = @cWorkOrderResults
		,[tOpenDate] = @tOpenDate
		,[tMaintDate] = @tMaintDate
		,[tMaintNextDate] = @tMaintNextDate

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nCallSheetUID] = @nCallSheetUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetStandardLink_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetStandardLink_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetStandardLink_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetStandardLink_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetStandardLink_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetStandardLink_Update]
	@nCallSheetStandardLinkUID uniqueidentifier
	,@nCallSheetUID uniqueidentifier
	,@nAssetUID uniqueidentifier
	,@tMaintDate datetime
	,@tMaintNextDate datetime

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[CallSheetStandardLink]
	SET
		[nCallSheetUID] = @nCallSheetUID
		,[nAssetUID] = @nAssetUID
		,[tMaintDate] = @tMaintDate
		,[tMaintNextDate] = @tMaintNextDate

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nCallSheetStandardLinkUID] = @nCallSheetStandardLinkUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Labor_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Labor_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_Labor_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Labor_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Labor_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Labor_Update]
	@nLaborUID uniqueidentifier
	,@nCallSheetUID uniqueidentifier
	,@nUserUID uniqueidentifier
	,@nDuration numeric(18, 2)
	,@tStartTime datetime

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[Labor]
	SET
		[nCallSheetUID] = @nCallSheetUID
		,[nUserUID] = @nUserUID
		,[nDuration] = @nDuration
		,[tStartTime] = @tStartTime

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nLaborUID] = @nLaborUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PackageHistory_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PackageHistory_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_PackageHistory_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PackageHistory_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PackageHistory_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PackageHistory_Update]
	@nPackageHistoryUID uniqueidentifier
	,@nServerUID uniqueidentifier
	,@nWorkstationUID uniqueidentifier
	,@nPackageNumber int
	,@cSourceName nvarchar(50)
	,@nPackageType tinyint
	,@tExportDate datetime
	,@tImportDate datetime

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[PackageHistory]
	SET
		[nServerUID] = @nServerUID
		,[nWorkstationUID] = @nWorkstationUID
		,[nPackageNumber] = @nPackageNumber
		,[cSourceName] = @cSourceName
		,[nPackageType] = @nPackageType
		,[tExportDate] = @tExportDate
		,[tImportDate] = @tImportDate

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nPackageHistoryUID] = @nPackageHistoryUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExLogicals_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExLogicals_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExLogicals_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExLogicals_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExLogicals_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExLogicals_Update]
	@nPointExLogicalUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@lField001 int
	,@lField002 int
	,@lField003 int

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[PointExLogicals]
	SET
		[nPointUID] = @nPointUID
		,[lField001] = @lField001
		,[lField002] = @lField002
		,[lField003] = @lField003

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nPointExLogicalUID] = @nPointExLogicalUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExNumerics_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExNumerics_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExNumerics_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExNumerics_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExNumerics_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExNumerics_Update]
	@nPointExNumericUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@nField001 float
	,@nField001UnitUID uniqueidentifier
	,@nField001FormatUID uniqueidentifier
	,@nField002 float
	,@nField002UnitUID uniqueidentifier
	,@nField002FormatUID uniqueidentifier
	,@nField003 float
	,@nField003UnitUID uniqueidentifier
	,@nField003FormatUID uniqueidentifier
	,@nField004 float
	,@nField004UnitUID uniqueidentifier
	,@nField004FormatUID uniqueidentifier
	,@nField005 float
	,@nField005UnitUID uniqueidentifier
	,@nField005FormatUID uniqueidentifier
	,@nField006 float
	,@nField006UnitUID uniqueidentifier
	,@nField006FormatUID uniqueidentifier
	,@nField007 float
	,@nField007UnitUID uniqueidentifier
	,@nField007FormatUID uniqueidentifier
	,@nField008 float
	,@nField008UnitUID uniqueidentifier
	,@nField008FormatUID uniqueidentifier
	,@nField009 float
	,@nField009UnitUID uniqueidentifier
	,@nField009FormatUID uniqueidentifier
	,@nField010 float
	,@nField010UnitUID uniqueidentifier
	,@nField010FormatUID uniqueidentifier
	,@nField011 float
	,@nField011UnitUID uniqueidentifier
	,@nField011FormatUID uniqueidentifier
	,@nField012 float
	,@nField012UnitUID uniqueidentifier
	,@nField012FormatUID uniqueidentifier
	,@nField013 float
	,@nField013UnitUID uniqueidentifier
	,@nField013FormatUID uniqueidentifier
	,@nField014 float
	,@nField014UnitUID uniqueidentifier
	,@nField014FormatUID uniqueidentifier
	,@nField015 float
	,@nField015UnitUID uniqueidentifier
	,@nField015FormatUID uniqueidentifier
	,@nField016 float
	,@nField016UnitUID uniqueidentifier
	,@nField016FormatUID uniqueidentifier
	,@nField017 float
	,@nField017UnitUID uniqueidentifier
	,@nField017FormatUID uniqueidentifier
	,@nField018 float
	,@nField018UnitUID uniqueidentifier
	,@nField018FormatUID uniqueidentifier
	,@nField019 float
	,@nField019UnitUID uniqueidentifier
	,@nField019FormatUID uniqueidentifier
	,@nField020 float
	,@nField020UnitUID uniqueidentifier
	,@nField020FormatUID uniqueidentifier
	,@nField021 float
	,@nField021UnitUID uniqueidentifier
	,@nField021FormatUID uniqueidentifier
	,@nField022 float
	,@nField022UnitUID uniqueidentifier
	,@nField022FormatUID uniqueidentifier
	,@nField023 float
	,@nField023UnitUID uniqueidentifier
	,@nField023FormatUID uniqueidentifier
	,@nField024 float
	,@nField024UnitUID uniqueidentifier
	,@nField024FormatUID uniqueidentifier
	,@nField025 float
	,@nField025UnitUID uniqueidentifier
	,@nField025FormatUID uniqueidentifier
	,@nField026 float
	,@nField026UnitUID uniqueidentifier
	,@nField026FormatUID uniqueidentifier
	,@nField027 float
	,@nField027UnitUID uniqueidentifier
	,@nField027FormatUID uniqueidentifier
	,@nField028 float
	,@nField028UnitUID uniqueidentifier
	,@nField028FormatUID uniqueidentifier
	,@nField029 float
	,@nField029UnitUID uniqueidentifier
	,@nField029FormatUID uniqueidentifier
	,@nField030 float
	,@nField030UnitUID uniqueidentifier
	,@nField030FormatUID uniqueidentifier

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[PointExNumerics]
	SET
		[nPointUID] = @nPointUID
		,[nField001] = @nField001
		,[nField001UnitUID] = @nField001UnitUID
		,[nField001FormatUID] = @nField001FormatUID
		,[nField002] = @nField002
		,[nField002UnitUID] = @nField002UnitUID
		,[nField002FormatUID] = @nField002FormatUID
		,[nField003] = @nField003
		,[nField003UnitUID] = @nField003UnitUID
		,[nField003FormatUID] = @nField003FormatUID
		,[nField004] = @nField004
		,[nField004UnitUID] = @nField004UnitUID
		,[nField004FormatUID] = @nField004FormatUID
		,[nField005] = @nField005
		,[nField005UnitUID] = @nField005UnitUID
		,[nField005FormatUID] = @nField005FormatUID
		,[nField006] = @nField006
		,[nField006UnitUID] = @nField006UnitUID
		,[nField006FormatUID] = @nField006FormatUID
		,[nField007] = @nField007
		,[nField007UnitUID] = @nField007UnitUID
		,[nField007FormatUID] = @nField007FormatUID
		,[nField008] = @nField008
		,[nField008UnitUID] = @nField008UnitUID
		,[nField008FormatUID] = @nField008FormatUID
		,[nField009] = @nField009
		,[nField009UnitUID] = @nField009UnitUID
		,[nField009FormatUID] = @nField009FormatUID
		,[nField010] = @nField010
		,[nField010UnitUID] = @nField010UnitUID
		,[nField010FormatUID] = @nField010FormatUID
		,[nField011] = @nField011
		,[nField011UnitUID] = @nField011UnitUID
		,[nField011FormatUID] = @nField011FormatUID
		,[nField012] = @nField012
		,[nField012UnitUID] = @nField012UnitUID
		,[nField012FormatUID] = @nField012FormatUID
		,[nField013] = @nField013
		,[nField013UnitUID] = @nField013UnitUID
		,[nField013FormatUID] = @nField013FormatUID
		,[nField014] = @nField014
		,[nField014UnitUID] = @nField014UnitUID
		,[nField014FormatUID] = @nField014FormatUID
		,[nField015] = @nField015
		,[nField015UnitUID] = @nField015UnitUID
		,[nField015FormatUID] = @nField015FormatUID
		,[nField016] = @nField016
		,[nField016UnitUID] = @nField016UnitUID
		,[nField016FormatUID] = @nField016FormatUID
		,[nField017] = @nField017
		,[nField017UnitUID] = @nField017UnitUID
		,[nField017FormatUID] = @nField017FormatUID
		,[nField018] = @nField018
		,[nField018UnitUID] = @nField018UnitUID
		,[nField018FormatUID] = @nField018FormatUID
		,[nField019] = @nField019
		,[nField019UnitUID] = @nField019UnitUID
		,[nField019FormatUID] = @nField019FormatUID
		,[nField020] = @nField020
		,[nField020UnitUID] = @nField020UnitUID
		,[nField020FormatUID] = @nField020FormatUID
		,[nField021] = @nField021
		,[nField021UnitUID] = @nField021UnitUID
		,[nField021FormatUID] = @nField021FormatUID
		,[nField022] = @nField022
		,[nField022UnitUID] = @nField022UnitUID
		,[nField022FormatUID] = @nField022FormatUID
		,[nField023] = @nField023
		,[nField023UnitUID] = @nField023UnitUID
		,[nField023FormatUID] = @nField023FormatUID
		,[nField024] = @nField024
		,[nField024UnitUID] = @nField024UnitUID
		,[nField024FormatUID] = @nField024FormatUID
		,[nField025] = @nField025
		,[nField025UnitUID] = @nField025UnitUID
		,[nField025FormatUID] = @nField025FormatUID
		,[nField026] = @nField026
		,[nField026UnitUID] = @nField026UnitUID
		,[nField026FormatUID] = @nField026FormatUID
		,[nField027] = @nField027
		,[nField027UnitUID] = @nField027UnitUID
		,[nField027FormatUID] = @nField027FormatUID
		,[nField028] = @nField028
		,[nField028UnitUID] = @nField028UnitUID
		,[nField028FormatUID] = @nField028FormatUID
		,[nField029] = @nField029
		,[nField029UnitUID] = @nField029UnitUID
		,[nField029FormatUID] = @nField029FormatUID
		,[nField030] = @nField030
		,[nField030UnitUID] = @nField030UnitUID
		,[nField030FormatUID] = @nField030FormatUID

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nPointExNumericUID] = @nPointExNumericUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExStrings_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointExStrings_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointExStrings_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointExStrings_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointExStrings_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointExStrings_Update]
	@nPointExStringUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@cField001 nvarchar(255)
	,@cField002 nvarchar(255)
	,@cField003 nvarchar(255)
	,@cField004 nvarchar(255)
	,@cField005 nvarchar(255)
	,@cField006 nvarchar(255)
	,@cField007 nvarchar(255)
	,@cField008 nvarchar(255)
	,@cField009 nvarchar(255)
	,@cField010 nvarchar(255)
	,@cField011 nvarchar(255)
	,@cField012 nvarchar(255)
	,@cField013 nvarchar(255)
	,@cField014 nvarchar(255)

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[PointExStrings]
	SET
		[nPointUID] = @nPointUID
		,[cField001] = @cField001
		,[cField002] = @cField002
		,[cField003] = @cField003
		,[cField004] = @cField004
		,[cField005] = @cField005
		,[cField006] = @cField006
		,[cField007] = @cField007
		,[cField008] = @cField008
		,[cField009] = @cField009
		,[cField010] = @cField010
		,[cField011] = @cField011
		,[cField012] = @cField012
		,[cField013] = @cField013
		,[cField014] = @cField014

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nPointExStringUID] = @nPointExStringUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointReadings_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointReadings_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointReadings_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointReadings_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointReadings_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointReadings_Update]
	@nPointReadingUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@nAssetUID uniqueidentifier
	,@nReadingUnitUID uniqueidentifier
	,@nReadingFormatUID uniqueidentifier
	,@tReadingDateTime datetime
	,@nReadingOrdinal int
	,@nReading float
	,@cReadingUnit nvarchar(50)
	,@cReadingLabel nvarchar(50)
	,@cReadingType nvarchar(50)

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[PointReadings]
	SET
		[nPointUID] = @nPointUID
		,[nAssetUID] = @nAssetUID
		,[nReadingUnitUID] = @nReadingUnitUID
		,[nReadingFormatUID] = @nReadingFormatUID
		,[tReadingDateTime] = @tReadingDateTime
		,[nReadingOrdinal] = @nReadingOrdinal
		,[nReading] = @nReading
		,[cReadingUnit] = @cReadingUnit
		,[cReadingLabel] = @cReadingLabel
		,[cReadingType] = @cReadingType

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nPointReadingUID] = @nPointReadingUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Points_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Points_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_Points_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Points_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Points_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Points_Update]
	@nPointUID uniqueidentifier
	,@nCallSheetResultUID uniqueidentifier
	,@nManualTemplateRowUID uniqueidentifier
	,@nUUTUnitUID uniqueidentifier
	,@nUUTFormatUID uniqueidentifier
	,@nReferenceUnitUID uniqueidentifier
	,@nReferenceFormatUID uniqueidentifier
	,@nCardinalPointUnitUID uniqueidentifier
	,@nCardinalPointFormatUID uniqueidentifier
	,@nCorrectionUnitUID uniqueidentifier
	,@nCorrectionFormatUID uniqueidentifier
	,@nUUTRangeUnitUID uniqueidentifier
	,@nUUTRangeFormatUID uniqueidentifier
	,@nSystemAccuracyUnitUID uniqueidentifier
	,@nSystemAccuracyFormatUID uniqueidentifier
	,@nTemplateItemUID uniqueidentifier
	,@nPointOrdinal int
	,@tPointDateTime datetime
	,@cPointLabel nvarchar(150)
	,@cPointStatusFlags nvarchar(50)
	,@cPointPassFailStatus nvarchar(50)
	,@cFunctionSelectCode nvarchar(50)
	,@nUUT float
	,@nReference float
	,@nCardinalPoint float
	,@nCorrection float
	,@cPointDescription nvarchar(300)
	,@cRemarks nvarchar(300)
	,@cOverrideRemarks nvarchar(300)
	,@cDesignation nvarchar(10)
	,@cTagId nvarchar(50)
	,@nUUTRange float
	,@nSetTime float
	,@cCondition nvarchar(50)
	,@nSystemAccuracy float
	,@nClaim numeric(18, 0)
	,@lAccredited int
	,@lPrinted int
	,@lUUTIsFixed int
	,@lOverride int
	,@lHeader int

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[Points]
	SET
		[nCallSheetResultUID] = @nCallSheetResultUID
		,[nManualTemplateRowUID] = @nManualTemplateRowUID
		,[nUUTUnitUID] = @nUUTUnitUID
		,[nUUTFormatUID] = @nUUTFormatUID
		,[nReferenceUnitUID] = @nReferenceUnitUID
		,[nReferenceFormatUID] = @nReferenceFormatUID
		,[nCardinalPointUnitUID] = @nCardinalPointUnitUID
		,[nCardinalPointFormatUID] = @nCardinalPointFormatUID
		,[nCorrectionUnitUID] = @nCorrectionUnitUID
		,[nCorrectionFormatUID] = @nCorrectionFormatUID
		,[nUUTRangeUnitUID] = @nUUTRangeUnitUID
		,[nUUTRangeFormatUID] = @nUUTRangeFormatUID
		,[nSystemAccuracyUnitUID] = @nSystemAccuracyUnitUID
		,[nSystemAccuracyFormatUID] = @nSystemAccuracyFormatUID
		,[nTemplateItemUID] = @nTemplateItemUID
		,[nPointOrdinal] = @nPointOrdinal
		,[tPointDateTime] = @tPointDateTime
		,[cPointLabel] = @cPointLabel
		,[cPointStatusFlags] = @cPointStatusFlags
		,[cPointPassFailStatus] = @cPointPassFailStatus
		,[cFunctionSelectCode] = @cFunctionSelectCode
		,[nUUT] = @nUUT
		,[nReference] = @nReference
		,[nCardinalPoint] = @nCardinalPoint
		,[nCorrection] = @nCorrection
		,[cPointDescription] = @cPointDescription
		,[cRemarks] = @cRemarks
		,[cOverrideRemarks] = @cOverrideRemarks
		,[cDesignation] = @cDesignation
		,[cTagId] = @cTagId
		,[nUUTRange] = @nUUTRange
		,[nSetTime] = @nSetTime
		,[cCondition] = @cCondition
		,[nSystemAccuracy] = @nSystemAccuracy
		,[nClaim] = @nClaim
		,[lAccredited] = @lAccredited
		,[lPrinted] = @lPrinted
		,[lUUTIsFixed] = @lUUTIsFixed
		,[lOverride] = @lOverride
		,[lHeader] = @lHeader

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nPointUID] = @nPointUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointStatistics_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointStatistics_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointStatistics_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointStatistics_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointStatistics_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointStatistics_Update]
	@nPointStatisticUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@nMinimumUUTUnitUID uniqueidentifier
	,@nMinimumUUTFormatUID uniqueidentifier
	,@nMaximumUUTUnitUID uniqueidentifier
	,@nMaximumUUTFormatUID uniqueidentifier
	,@nMinimumReferenceUnitUID uniqueidentifier
	,@nMinimumReferenceFormatUID uniqueidentifier
	,@nMaximumReferenceUnitUID uniqueidentifier
	,@nMaximumReferenceFormatUID uniqueidentifier
	,@nUUTStandardDeviationUnitUID uniqueidentifier
	,@nUUTStandardDeviationFormatUID uniqueidentifier
	,@nUUTRawStandardDeviationUnitUID uniqueidentifier
	,@nUUTRawStandardDeviationFormatUID uniqueidentifier
	,@nReferenceStandardDeviationUnitUID uniqueidentifier
	,@nReferenceStandardDeviationFormatUID uniqueidentifier
	,@nReference2StandardDeviationUnitUID uniqueidentifier
	,@nReference2StandardDeviationFormatUID uniqueidentifier
	,@nReferenceRawStandardDeviationUnitUID uniqueidentifier
	,@nReferenceRawStandardDeviationFormatUID uniqueidentifier
	,@nReferenceRaw2StandardDeviationUnitUID uniqueidentifier
	,@nReferenceRaw2StandardDeviationFormatUID uniqueidentifier
	,@nSampleRateUnitUID uniqueidentifier
	,@nSampleRateFormatUID uniqueidentifier
	,@nMinimumUUT float
	,@nMaximumUUT float
	,@nMinimumReference float
	,@nMaximumReference float
	,@nUUTStandardDeviation float
	,@nUUTRawStandardDeviation float
	,@nReferenceStandardDeviation float
	,@nReference2StandardDeviation float
	,@nReferenceRawStandardDeviation float
	,@nReferenceRaw2StandardDeviation float
	,@nNumberOfSamplesReference int
	,@nNumberOfSamplesUUT int
	,@nNumberOfSamplesDiscarded int
	,@nSampleRate float
	,@nChiSquared float
	,@lNoisy int
	,@lReliable int

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[PointStatistics]
	SET
		[nPointUID] = @nPointUID
		,[nMinimumUUTUnitUID] = @nMinimumUUTUnitUID
		,[nMinimumUUTFormatUID] = @nMinimumUUTFormatUID
		,[nMaximumUUTUnitUID] = @nMaximumUUTUnitUID
		,[nMaximumUUTFormatUID] = @nMaximumUUTFormatUID
		,[nMinimumReferenceUnitUID] = @nMinimumReferenceUnitUID
		,[nMinimumReferenceFormatUID] = @nMinimumReferenceFormatUID
		,[nMaximumReferenceUnitUID] = @nMaximumReferenceUnitUID
		,[nMaximumReferenceFormatUID] = @nMaximumReferenceFormatUID
		,[nUUTStandardDeviationUnitUID] = @nUUTStandardDeviationUnitUID
		,[nUUTStandardDeviationFormatUID] = @nUUTStandardDeviationFormatUID
		,[nUUTRawStandardDeviationUnitUID] = @nUUTRawStandardDeviationUnitUID
		,[nUUTRawStandardDeviationFormatUID] = @nUUTRawStandardDeviationFormatUID
		,[nReferenceStandardDeviationUnitUID] = @nReferenceStandardDeviationUnitUID
		,[nReferenceStandardDeviationFormatUID] = @nReferenceStandardDeviationFormatUID
		,[nReference2StandardDeviationUnitUID] = @nReference2StandardDeviationUnitUID
		,[nReference2StandardDeviationFormatUID] = @nReference2StandardDeviationFormatUID
		,[nReferenceRawStandardDeviationUnitUID] = @nReferenceRawStandardDeviationUnitUID
		,[nReferenceRawStandardDeviationFormatUID] = @nReferenceRawStandardDeviationFormatUID
		,[nReferenceRaw2StandardDeviationUnitUID] = @nReferenceRaw2StandardDeviationUnitUID
		,[nReferenceRaw2StandardDeviationFormatUID] = @nReferenceRaw2StandardDeviationFormatUID
		,[nSampleRateUnitUID] = @nSampleRateUnitUID
		,[nSampleRateFormatUID] = @nSampleRateFormatUID
		,[nMinimumUUT] = @nMinimumUUT
		,[nMaximumUUT] = @nMaximumUUT
		,[nMinimumReference] = @nMinimumReference
		,[nMaximumReference] = @nMaximumReference
		,[nUUTStandardDeviation] = @nUUTStandardDeviation
		,[nUUTRawStandardDeviation] = @nUUTRawStandardDeviation
		,[nReferenceStandardDeviation] = @nReferenceStandardDeviation
		,[nReference2StandardDeviation] = @nReference2StandardDeviation
		,[nReferenceRawStandardDeviation] = @nReferenceRawStandardDeviation
		,[nReferenceRaw2StandardDeviation] = @nReferenceRaw2StandardDeviation
		,[nNumberOfSamplesReference] = @nNumberOfSamplesReference
		,[nNumberOfSamplesUUT] = @nNumberOfSamplesUUT
		,[nNumberOfSamplesDiscarded] = @nNumberOfSamplesDiscarded
		,[nSampleRate] = @nSampleRate
		,[nChiSquared] = @nChiSquared
		,[lNoisy] = @lNoisy
		,[lReliable] = @lReliable

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nPointStatisticUID] = @nPointStatisticUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointTolerances_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointTolerances_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointTolerances_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointTolerances_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointTolerances_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointTolerances_Update]
	@nPointToleranceUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@nToleranceUnitUID uniqueidentifier
	,@nToleranceFormatUID uniqueidentifier
	,@nTolerancePositiveUnitUID uniqueidentifier
	,@nTolerancePositiveFormatUID uniqueidentifier
	,@nToleranceNegativeUnitUID uniqueidentifier
	,@nToleranceNegativeFormatUID uniqueidentifier
	,@nReferenceToleranceUnitUID uniqueidentifier
	,@nReferenceToleranceFormatUID uniqueidentifier
	,@nErrorUnitUID uniqueidentifier
	,@nErrorFormatUID uniqueidentifier
	,@nToleranceErrorUnitUID uniqueidentifier
	,@nToleranceErrorFormatUID uniqueidentifier
	,@nTolerance float
	,@nTolerancePositive float
	,@nToleranceNegative float
	,@cToleranceReference nvarchar(50)
	,@nReferenceTolerance float
	,@nReadingErrorPercent float
	,@nReadingErrorReferencePercent float
	,@nFullScaleErrorPercent float
	,@nFullScaleErrorReferencePercent float
	,@nSetErrorPercent float
	,@nSetFullScaleErrorPercent float
	,@nToleranceErrorPercent float
	,@nError float
	,@nToleranceError float

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[PointTolerances]
	SET
		[nPointUID] = @nPointUID
		,[nToleranceUnitUID] = @nToleranceUnitUID
		,[nToleranceFormatUID] = @nToleranceFormatUID
		,[nTolerancePositiveUnitUID] = @nTolerancePositiveUnitUID
		,[nTolerancePositiveFormatUID] = @nTolerancePositiveFormatUID
		,[nToleranceNegativeUnitUID] = @nToleranceNegativeUnitUID
		,[nToleranceNegativeFormatUID] = @nToleranceNegativeFormatUID
		,[nReferenceToleranceUnitUID] = @nReferenceToleranceUnitUID
		,[nReferenceToleranceFormatUID] = @nReferenceToleranceFormatUID
		,[nErrorUnitUID] = @nErrorUnitUID
		,[nErrorFormatUID] = @nErrorFormatUID
		,[nToleranceErrorUnitUID] = @nToleranceErrorUnitUID
		,[nToleranceErrorFormatUID] = @nToleranceErrorFormatUID
		,[nTolerance] = @nTolerance
		,[nTolerancePositive] = @nTolerancePositive
		,[nToleranceNegative] = @nToleranceNegative
		,[cToleranceReference] = @cToleranceReference
		,[nReferenceTolerance] = @nReferenceTolerance
		,[nReadingErrorPercent] = @nReadingErrorPercent
		,[nReadingErrorReferencePercent] = @nReadingErrorReferencePercent
		,[nFullScaleErrorPercent] = @nFullScaleErrorPercent
		,[nFullScaleErrorReferencePercent] = @nFullScaleErrorReferencePercent
		,[nSetErrorPercent] = @nSetErrorPercent
		,[nSetFullScaleErrorPercent] = @nSetFullScaleErrorPercent
		,[nToleranceErrorPercent] = @nToleranceErrorPercent
		,[nError] = @nError
		,[nToleranceError] = @nToleranceError

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nPointToleranceUID] = @nPointToleranceUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointUncertainties_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_PointUncertainties_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_PointUncertainties_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_PointUncertainties_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_PointUncertainties_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_PointUncertainties_Update]
	@nPointUncertaintyUID uniqueidentifier
	,@nPointUID uniqueidentifier
	,@nGuardBandLowerUnitUID uniqueidentifier
	,@nGuardBandLowerFormatUID uniqueidentifier
	,@nGuardBandUpperUnitUID uniqueidentifier
	,@nGuardBandUpperFormatUID uniqueidentifier
	,@nUncertaintyUnitUID uniqueidentifier
	,@nUncertaintyFormatUID uniqueidentifier
	,@nUncertaintyExpandedUnitUID uniqueidentifier
	,@nUncertaintyExpandedFormatUID uniqueidentifier
	,@nUncertaintyDominantUnitUID uniqueidentifier
	,@nUncertaintyDominantFormatUID uniqueidentifier
	,@nUncertaintyStandardUnitUID uniqueidentifier
	,@nUncertaintyStandardFormatUID uniqueidentifier
	,@nLowerLimitUnitUID uniqueidentifier
	,@nLowerLimitFormatUID uniqueidentifier
	,@nUpperLimitUnitUID uniqueidentifier
	,@nUpperLimitFormatUID uniqueidentifier
	,@nUncertaintyParameter1UnitUID uniqueidentifier
	,@nUncertaintyParameter1FormatUID uniqueidentifier
	,@nUncertaintyParameter2UnitUID uniqueidentifier
	,@nUncertaintyParameter2FormatUID uniqueidentifier
	,@nUncertaintyParameter3UnitUID uniqueidentifier
	,@nUncertaintyParameter3FormatUID uniqueidentifier
	,@nUncertaintyParameter4UnitUID uniqueidentifier
	,@nUncertaintyParameter4FormatUID uniqueidentifier
	,@nUncertaintyParameter5UnitUID uniqueidentifier
	,@nUncertaintyParameter5FormatUID uniqueidentifier
	,@nUncertaintyParameter6UnitUID uniqueidentifier
	,@nUncertaintyParameter6FormatUID uniqueidentifier
	,@nUncertaintyParameter7UnitUID uniqueidentifier
	,@nUncertaintyParameter7FormatUID uniqueidentifier
	,@nUncertaintyParameter8UnitUID uniqueidentifier
	,@nUncertaintyParameter8FormatUID uniqueidentifier
	,@nUncertaintyParameter9UnitUID uniqueidentifier
	,@nUncertaintyParameter9FormatUID uniqueidentifier
	,@nUncertaintyParameter10UnitUID uniqueidentifier
	,@nUncertaintyParameter10FormatUID uniqueidentifier
	,@nModifier1UnitUID uniqueidentifier
	,@nModifier1FormatUID uniqueidentifier
	,@nModifier2UnitUID uniqueidentifier
	,@nModifier2FormatUID uniqueidentifier
	,@nS1UnitUID uniqueidentifier
	,@nS1FormatUID uniqueidentifier
	,@nS2UnitUID uniqueidentifier
	,@nS2FormatUID uniqueidentifier
	,@cGuardBandMethod nvarchar(32)
	,@nGuardBandLower float
	,@nGuardBandUpper float
	,@cUncertaintyMethod nvarchar(50)
	,@nUncertainty float
	,@nUncertaintyExpanded float
	,@nUncertaintyDominant float
	,@nUncertaintyStandard float
	,@nLowerLimit float
	,@nUpperLimit float
	,@nCoverageFactor float
	,@nSystemCoverageFactor float
	,@nConfidenceLevel float
	,@cStudentsT nvarchar(32)
	,@nUncertaintyParameter1 float
	,@nUncertaintyParameter2 float
	,@nUncertaintyParameter3 float
	,@nUncertaintyParameter4 float
	,@nUncertaintyParameter5 float
	,@nUncertaintyParameter6 float
	,@nUncertaintyParameter7 float
	,@nUncertaintyParameter8 float
	,@nUncertaintyParameter9 float
	,@nUncertaintyParameter10 float
	,@cSensitivity1 nvarchar(32)
	,@cSensitivity2 nvarchar(32)
	,@cSensitivity3 nvarchar(32)
	,@cSensitivity4 nvarchar(32)
	,@cSensitivity5 nvarchar(32)
	,@cSensitivity6 nvarchar(32)
	,@cSensitivity7 nvarchar(32)
	,@cSensitivity8 nvarchar(32)
	,@cSensitivity9 nvarchar(32)
	,@cSensitivity10 nvarchar(32)
	,@cDegreesOfFreedom1 nvarchar(16)
	,@cDegreesOfFreedom2 nvarchar(16)
	,@cDegreesOfFreedom3 nvarchar(16)
	,@cDegreesOfFreedom4 nvarchar(16)
	,@cDegreesOfFreedom5 nvarchar(16)
	,@cDegreesOfFreedom6 nvarchar(16)
	,@cDegreesOfFreedom7 nvarchar(16)
	,@cDegreesOfFreedom8 nvarchar(16)
	,@cDegreesOfFreedom9 nvarchar(16)
	,@cDegreesOfFreedom10 nvarchar(16)
	,@nModifier1 float
	,@nModifier2 float
	,@nS1 float
	,@nS2 float
	,@cEquilibrationParameters nvarchar(50)
	,@lStudentsT int
	,@lDominant int
	,@lWelchSatterthwaite int

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[PointUncertainties]
	SET
		[nPointUID] = @nPointUID
		,[nGuardBandLowerUnitUID] = @nGuardBandLowerUnitUID
		,[nGuardBandLowerFormatUID] = @nGuardBandLowerFormatUID
		,[nGuardBandUpperUnitUID] = @nGuardBandUpperUnitUID
		,[nGuardBandUpperFormatUID] = @nGuardBandUpperFormatUID
		,[nUncertaintyUnitUID] = @nUncertaintyUnitUID
		,[nUncertaintyFormatUID] = @nUncertaintyFormatUID
		,[nUncertaintyExpandedUnitUID] = @nUncertaintyExpandedUnitUID
		,[nUncertaintyExpandedFormatUID] = @nUncertaintyExpandedFormatUID
		,[nUncertaintyDominantUnitUID] = @nUncertaintyDominantUnitUID
		,[nUncertaintyDominantFormatUID] = @nUncertaintyDominantFormatUID
		,[nUncertaintyStandardUnitUID] = @nUncertaintyStandardUnitUID
		,[nUncertaintyStandardFormatUID] = @nUncertaintyStandardFormatUID
		,[nLowerLimitUnitUID] = @nLowerLimitUnitUID
		,[nLowerLimitFormatUID] = @nLowerLimitFormatUID
		,[nUpperLimitUnitUID] = @nUpperLimitUnitUID
		,[nUpperLimitFormatUID] = @nUpperLimitFormatUID
		,[nUncertaintyParameter1UnitUID] = @nUncertaintyParameter1UnitUID
		,[nUncertaintyParameter1FormatUID] = @nUncertaintyParameter1FormatUID
		,[nUncertaintyParameter2UnitUID] = @nUncertaintyParameter2UnitUID
		,[nUncertaintyParameter2FormatUID] = @nUncertaintyParameter2FormatUID
		,[nUncertaintyParameter3UnitUID] = @nUncertaintyParameter3UnitUID
		,[nUncertaintyParameter3FormatUID] = @nUncertaintyParameter3FormatUID
		,[nUncertaintyParameter4UnitUID] = @nUncertaintyParameter4UnitUID
		,[nUncertaintyParameter4FormatUID] = @nUncertaintyParameter4FormatUID
		,[nUncertaintyParameter5UnitUID] = @nUncertaintyParameter5UnitUID
		,[nUncertaintyParameter5FormatUID] = @nUncertaintyParameter5FormatUID
		,[nUncertaintyParameter6UnitUID] = @nUncertaintyParameter6UnitUID
		,[nUncertaintyParameter6FormatUID] = @nUncertaintyParameter6FormatUID
		,[nUncertaintyParameter7UnitUID] = @nUncertaintyParameter7UnitUID
		,[nUncertaintyParameter7FormatUID] = @nUncertaintyParameter7FormatUID
		,[nUncertaintyParameter8UnitUID] = @nUncertaintyParameter8UnitUID
		,[nUncertaintyParameter8FormatUID] = @nUncertaintyParameter8FormatUID
		,[nUncertaintyParameter9UnitUID] = @nUncertaintyParameter9UnitUID
		,[nUncertaintyParameter9FormatUID] = @nUncertaintyParameter9FormatUID
		,[nUncertaintyParameter10UnitUID] = @nUncertaintyParameter10UnitUID
		,[nUncertaintyParameter10FormatUID] = @nUncertaintyParameter10FormatUID
		,[nModifier1UnitUID] = @nModifier1UnitUID
		,[nModifier1FormatUID] = @nModifier1FormatUID
		,[nModifier2UnitUID] = @nModifier2UnitUID
		,[nModifier2FormatUID] = @nModifier2FormatUID
		,[nS1UnitUID] = @nS1UnitUID
		,[nS1FormatUID] = @nS1FormatUID
		,[nS2UnitUID] = @nS2UnitUID
		,[nS2FormatUID] = @nS2FormatUID
		,[cGuardBandMethod] = @cGuardBandMethod
		,[nGuardBandLower] = @nGuardBandLower
		,[nGuardBandUpper] = @nGuardBandUpper
		,[cUncertaintyMethod] = @cUncertaintyMethod
		,[nUncertainty] = @nUncertainty
		,[nUncertaintyExpanded] = @nUncertaintyExpanded
		,[nUncertaintyDominant] = @nUncertaintyDominant
		,[nUncertaintyStandard] = @nUncertaintyStandard
		,[nLowerLimit] = @nLowerLimit
		,[nUpperLimit] = @nUpperLimit
		,[nCoverageFactor] = @nCoverageFactor
		,[nSystemCoverageFactor] = @nSystemCoverageFactor
		,[nConfidenceLevel] = @nConfidenceLevel
		,[cStudentsT] = @cStudentsT
		,[nUncertaintyParameter1] = @nUncertaintyParameter1
		,[nUncertaintyParameter2] = @nUncertaintyParameter2
		,[nUncertaintyParameter3] = @nUncertaintyParameter3
		,[nUncertaintyParameter4] = @nUncertaintyParameter4
		,[nUncertaintyParameter5] = @nUncertaintyParameter5
		,[nUncertaintyParameter6] = @nUncertaintyParameter6
		,[nUncertaintyParameter7] = @nUncertaintyParameter7
		,[nUncertaintyParameter8] = @nUncertaintyParameter8
		,[nUncertaintyParameter9] = @nUncertaintyParameter9
		,[nUncertaintyParameter10] = @nUncertaintyParameter10
		,[cSensitivity1] = @cSensitivity1
		,[cSensitivity2] = @cSensitivity2
		,[cSensitivity3] = @cSensitivity3
		,[cSensitivity4] = @cSensitivity4
		,[cSensitivity5] = @cSensitivity5
		,[cSensitivity6] = @cSensitivity6
		,[cSensitivity7] = @cSensitivity7
		,[cSensitivity8] = @cSensitivity8
		,[cSensitivity9] = @cSensitivity9
		,[cSensitivity10] = @cSensitivity10
		,[cDegreesOfFreedom1] = @cDegreesOfFreedom1
		,[cDegreesOfFreedom2] = @cDegreesOfFreedom2
		,[cDegreesOfFreedom3] = @cDegreesOfFreedom3
		,[cDegreesOfFreedom4] = @cDegreesOfFreedom4
		,[cDegreesOfFreedom5] = @cDegreesOfFreedom5
		,[cDegreesOfFreedom6] = @cDegreesOfFreedom6
		,[cDegreesOfFreedom7] = @cDegreesOfFreedom7
		,[cDegreesOfFreedom8] = @cDegreesOfFreedom8
		,[cDegreesOfFreedom9] = @cDegreesOfFreedom9
		,[cDegreesOfFreedom10] = @cDegreesOfFreedom10
		,[nModifier1] = @nModifier1
		,[nModifier2] = @nModifier2
		,[nS1] = @nS1
		,[nS2] = @nS2
		,[cEquilibrationParameters] = @cEquilibrationParameters
		,[lStudentsT] = @lStudentsT
		,[lDominant] = @lDominant
		,[lWelchSatterthwaite] = @lWelchSatterthwaite

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nPointUncertaintyUID] = @nPointUncertaintyUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Procedures_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Procedures_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_Procedures_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Procedures_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Procedures_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Procedures_Update]
	@nProcedureUID uniqueidentifier
	,@nCategoryUID uniqueidentifier
	,@cProcedureName nvarchar(150)
	,@cProcedureType nvarchar(50)
	,@cRevision nvarchar(100)
	,@tProcedureDate datetime
	,@tRevisionDate datetime

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[Procedures]
	SET
		[nCategoryUID] = @nCategoryUID
		,[cProcedureName] = @cProcedureName
		,[cProcedureType] = @cProcedureType
		,[cRevision] = @cRevision
		,[tProcedureDate] = @tProcedureDate
		,[tRevisionDate] = @tRevisionDate

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nProcedureUID] = @nProcedureUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupFieldLinks_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroupFieldLinks_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroupFieldLinks_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupFieldLinks_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroupFieldLinks_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroupFieldLinks_Update]
	@nSecurityGroupFieldLinkUID uniqueidentifier
	,@nSecurityGroupUID uniqueidentifier
	,@nUCIDataUID uniqueidentifier

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[SecurityGroupFieldLinks]
	SET
		[nSecurityGroupUID] = @nSecurityGroupUID
		,[nUCIDataUID] = @nUCIDataUID

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nSecurityGroupFieldLinkUID] = @nSecurityGroupFieldLinkUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupMembers_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroupMembers_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroupMembers_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroupMembers_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroupMembers_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroupMembers_Update]
	@nSecurityGroupMemberUID uniqueidentifier
	,@nSecurityGroupUID uniqueidentifier
	,@nUserUID uniqueidentifier

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[SecurityGroupMembers]
	SET
		[nSecurityGroupUID] = @nSecurityGroupUID
		,[nUserUID] = @nUserUID

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nSecurityGroupMemberUID] = @nSecurityGroupMemberUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroups_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_SecurityGroups_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_SecurityGroups_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_SecurityGroups_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_SecurityGroups_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_SecurityGroups_Update]
	@nSecurityGroupUID uniqueidentifier
	,@cGroupName nvarchar(50)
	,@lSystemGroup int

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[SecurityGroups]
	SET
		[cGroupName] = @cGroupName
		,[lSystemGroup] = @lSystemGroup

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nSecurityGroupUID] = @nSecurityGroupUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_UCIData_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_UCIData_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_UCIData_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_UCIData_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_UCIData_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_UCIData_Update]
	@nUCIDataUID uniqueidentifier
	,@cModel nvarchar(150)
	,@cField nvarchar(50)
	,@cProperty nvarchar(50)
	,@cValue nvarchar(150)

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[UCIData]
	SET
		[cModel] = @cModel
		,[cField] = @cField
		,[cProperty] = @cProperty
		,[cValue] = @cValue

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nUCIDataUID] = @nUCIDataUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Units_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Units_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_Units_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Units_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Units_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Units_Update]
	@nUnitUID uniqueidentifier
	,@nUnitType numeric(18, 0)
	,@cUnitSymbol nvarchar(50)
	,@cBaseUnit nvarchar(50)
	,@cPrefix nchar(1)
	,@cAtTemperature nvarchar(50)
	,@cReferenceImpedence nvarchar(50)
	,@nCode int
	,@nConversionFactor numeric(25, 6)
	,@nScale numeric(18, 6)

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[Units]
	SET
		[nUnitType] = @nUnitType
		,[cUnitSymbol] = @cUnitSymbol
		,[cBaseUnit] = @cBaseUnit
		,[cPrefix] = @cPrefix
		,[cAtTemperature] = @cAtTemperature
		,[cReferenceImpedence] = @cReferenceImpedence
		,[nCode] = @nCode
		,[nConversionFactor] = @nConversionFactor
		,[nScale] = @nScale

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nUnitUID] = @nUnitUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Users_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Users_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_Users_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Users_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Users_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Users_Update]
	@nUserUID uniqueidentifier
	,@cFirstName nvarchar(50)
	,@cLastName nvarchar(50)
	,@cInitials nvarchar(50)
	,@cUsername nvarchar(50)
	,@cPassword nvarchar(100)
	,@tLastLogin datetime

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[Users]
	SET
		[cFirstName] = @cFirstName
		,[cLastName] = @cLastName
		,[cInitials] = @cInitials
		,[cUsername] = @cUsername
		,[cPassword] = @cPassword
		,[tLastLogin] = @tLastLogin

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nUserUID] = @nUserUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[spl_Mobile_Workstations_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_Workstations_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_Workstations_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_Workstations_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_Workstations_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_Workstations_Update]
	@nWorkstationUID uniqueidentifier
	,@cWorkstationName nvarchar(50)
	,@cWorkstationId nvarchar(50)
	,@cUserName nvarchar(50)
	,@cMobileId nvarchar(5)
	,@cRemoteServer nvarchar(100)
	,@cMode nvarchar(20)
	,@tLoginDate datetime
	,@tLastLogin datetime
	,@tMobileLoginDate datetime
	,@tCheckoutDate datetime

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[Workstations]
	SET
		[cWorkstationName] = @cWorkstationName
		,[cWorkstationId] = @cWorkstationId
		,[cUserName] = @cUserName
		,[cMobileId] = @cMobileId
		,[cRemoteServer] = @cRemoteServer
		,[cMode] = @cMode
		,[tLoginDate] = @tLoginDate
		,[tLastLogin] = @tLastLogin
		,[tMobileLoginDate] = @tMobileLoginDate
		,[tCheckoutDate] = @tCheckoutDate

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nWorkstationUID] = @nWorkstationUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>METCON-2288<<--
	IF OBJECT_ID(N'[dbo].[splt_GetDatabaseInfo5]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[splt_GetDatabaseInfo5]'
		DROP PROCEDURE [dbo].[splt_GetDatabaseInfo5]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[splt_GetDatabaseInfo5]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[splt_GetDatabaseInfo5]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[splt_GetDatabaseInfo5]
AS
BEGIN
	SELECT @@VERSION
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[splt_GetDatabaseInfo6]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[splt_GetDatabaseInfo6]'
		DROP PROCEDURE [dbo].[splt_GetDatabaseInfo6]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[splt_GetDatabaseInfo6]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[splt_GetDatabaseInfo6]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[splt_GetDatabaseInfo6]
AS
BEGIN
	SELECT SUM((CONVERT(dec (19, 2),
	CONVERT(bigint, SIZE))) * 8192 / 1048576.0) db_size_mb
	FROM [dbo].[sysfiles];
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>METCON-1975<<--
	IF OBJECT_ID(N'[dbo].[GetSecurityGroups]', 'P')	IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[GetSecurityGroups]'
		DROP PROCEDURE [dbo].[GetSecurityGroups]

		IF @@ERROR<>0 AND @@TRANCOUNT>0	ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetSecurityGroups]', 'P')	IS NULL
	BEGIN
		PRINT N'Creating [dbo].[GetSecurityGroups]'

		EXEC sp_executesql N'
CREATE PROCEDURE GetSecurityGroups
AS
BEGIN
SELECT
	sg.[nSecurityGroupUID],
	sg.[cGroupName],
	COUNT(s.[nSecurityGroupMemberUID]) AS [Count]
FROM
	[dbo].[SecurityGroups] sg
OUTER APPLY
(
SELECT
	[nSecurityGroupMemberUID]
FROM
	[dbo].[SecurityGroupMembers] sgm
JOIN
	[dbo].[Users] u
ON
	sgm.[nUserUID] = u.[nUserUID]
WHERE
	sg.[nSecurityGroupUID] = sgm.[nSecurityGroupUID]
AND
	sgm.[lActive] <> 0
AND
	sgm.[lDeleted] = 0
AND
	u.[lActive] <> 0
AND
	u.[lDeleted] = 0
) s
WHERE
	sg.[lActive] <>	0
AND
	sg.[lDeleted] =	0
GROUP BY
	sg.[nSecurityGroupUID],
	sg.[cGroupName]
ORDER BY
	sg.[cGroupName]
END
'
		IF @@ERROR<>0 AND @@TRANCOUNT>0	ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetSecurityMembersForGroup]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[GetSecurityMembersForGroup]'
		DROP PROCEDURE [dbo].[GetSecurityMembersForGroup]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetSecurityMembersForGroup]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[GetSecurityMembersForGroup]'

		EXEC sp_executesql N'
CREATE PROCEDURE GetSecurityMembersForGroup
	@nSecurityGroupUID UNIQUEIDENTIFIER
AS
BEGIN
SELECT
	sgm.[nSecurityGroupMemberUID],
	u.[nUserUID],
	u.[cFirstName],
	u.[cLastName],
	u.[cUserName]
FROM
	[dbo].[SecurityGroupMembers] sgm
JOIN
	[dbo].[Users] u
ON
	sgm.[nUserUID] = u.[nUserUID]
WHERE
	sgm.[nSecurityGroupUID] = @nSecurityGroupUID
AND
	sgm.[lActive] <>	0
AND
	sgm.[lDeleted] =	0
AND
	u.[lActive] <>	0
AND
	u.[lDeleted] =	0
END'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetSecurityItemsForGroup]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[GetSecurityItemsForGroup]'
		DROP PROCEDURE [dbo].[GetSecurityItemsForGroup]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetSecurityItemsForGroup]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[GetSecurityItemsForGroup]'

		EXEC sp_executesql N'
CREATE PROCEDURE GetSecurityItemsForGroup
	@nSecurityGroupUID UNIQUEIDENTIFIER
AS
BEGIN
SELECT
	u.[nUCIDataUID],
	u.[cField],
	s.[nSecurityGroupFieldLinkUID]
FROM
	[dbo].[UCIData] u
OUTER APPLY
(
SELECT
	[nSecurityGroupFieldLinkUID]
FROM
	[dbo].[SecurityGroupFieldLinks] sgfl
WHERE
	sgfl.[nUCIDataUID] = u.[nUCIDataUID]
AND
	sgfl.[nSecurityGroupUID] = @nSecurityGroupUID
AND
	sgfl.[lActive] <> 0
AND
	sgfl.[lDeleted] = 0
) s
WHERE
	u.[cModel] = ''MET/CAL''
AND
	u.[lActive] <> 0
AND
	u.[lDeleted] = 0
END'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetSecurityMembershipsForUser]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[GetSecurityMembershipsForUser]'
		DROP PROCEDURE [dbo].[GetSecurityMembershipsForUser]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetSecurityMembershipsForUser]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[GetSecurityMembershipsForUser]'

		EXEC sp_executesql N'
CREATE PROCEDURE GetSecurityMembershipsForUser
	@nUserUID UNIQUEIDENTIFIER
AS
BEGIN
SELECT
	sg.[nSecurityGroupUID],
	sg.[cGroupName],
	s.[nSecurityGroupMemberUID]
FROM
	[dbo].[SecurityGroups] sg
OUTER APPLY
(
SELECT
	[nSecurityGroupMemberUID]
FROM
	[dbo].[SecurityGroupMembers] sgm
WHERE
	sgm.[nSecurityGroupUID] = sg.[nSecurityGroupUID]
AND
	sgm.[nUserUID] = @nUserUID
AND
	sgm.[lActive] <> 0
AND
	sgm.[lDeleted]	= 0
) s
WHERE
	sg.[lActive] <>	0
AND
	sg.[lDeleted] =	0
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[GetSecuritySettingsForUser]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[GetSecuritySettingsForUser]'
		DROP PROCEDURE [dbo].[GetSecuritySettingsForUser]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetSecuritySettingsForUser]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[GetSecuritySettingsForUser]'

		EXEC sp_executesql N'
CREATE PROCEDURE GetSecuritySettingsForUser
	@nUserUID UNIQUEIDENTIFIER
AS
BEGIN
	SELECT DISTINCT
		uc.[nUCIDataUID],
		uc.[cField]
	FROM
		[dbo].[SecurityGroups] sg
	JOIN
		[dbo].[SecurityGroupMembers] sgm ON sg.[nSecurityGroupUID] = sgm.[nSecurityGroupUID]
	JOIN
		[dbo].[SecurityGroupFieldLinks] sgfl ON sg.[nSecurityGroupUID] = sgfl.[nSecurityGroupUID]
	JOIN
		[dbo].[UCIData] uc ON sgfl.[nUCIDataUID] = uc.[nUCIDataUID]
	WHERE
		sgm.[nUserUID] = @nUserUID
	AND
		uc.[cValue] <> 0
	AND
		uc.[cModel] = ''MET/CAL''
	AND
	    uc.[cProperty] = ''Enabled''
	AND
		sg.[lActive] <> 0
	AND
		sg.[lDeleted] = 0
	AND
		sgm.[lActive] <> 0
	AND
		sgm.[lDeleted] = 0
	AND
		sgfl.[lActive] <> 0
	AND
		sgfl.[lDeleted] = 0
	AND
		uc.[lActive] <> 0
	AND
		uc.[lDeleted] = 0
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-4018<<--
	IF OBJECT_ID(N'[dbo].[spl_Trace]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Trace]'
		DROP PROCEDURE [dbo].[spl_Trace]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Trace]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Trace]'

		EXEC sp_executesql N'
-- ==============================================================================================
-- Company:     Fluke Calibration
-- Author:      (MM)
-- Create date: 20120724
-- Description:	MET/TEAM Traceability Stored Procedure
-- Notes:       Compatibility with MET/TRACK report fields
--
-- Updated:     MM  20140722 Allow UTF8 user name
--              MM  20160812 Use nUserUID instead of user name
--              WJS 20210217 Add nCallSheetUID, cBarcode, cServiceReason, cInitialCondition, lOOT
-- ==============================================================================================
CREATE PROCEDURE [dbo].[spl_Trace]
    @cTraceDirection NVARCHAR(50),
    @nUserUID NVARCHAR(36)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

-- dynamic SQL, need to separate trace tables by user,
-- without creating a schema for each one
DECLARE @sql NVARCHAR(MAX);
SELECT @sql =
N''SELECT
	a.nAssetUID AS mtag,
	a.cID AS i4201,
	f.cFacilityName AS i4202,
	a.cModelNumber AS i4203,
	a.cDescription AS i4204,
	a.cSerialNumber AS i4206,
	cs.tMaintDate AS c2301,
	t.tMaintDate AS t2301,
	t.nDepth AS tident,
	t.cFlags AS tflag,
	t.tMaintNextDate AS t2303,
	t.nOrdinal AS rowid,
	cs.nCallSheetUID AS nCallSheetUID,
	a.cBarcode AS cBarcode,
	cs.cServiceReason as cServiceReason,
	cs.cInitialCondition as cInitialCondition,
	cs.lOOT as lOOT
FROM
	[dbo].[Trace_'' + @nUserUID + ''] t
	LEFT JOIN Assets a ON t.nAssetUID = a.nAssetUID
	LEFT JOIN CallSheets cs ON a.nAssetUID = cs.nAssetUID
	AND t.nAssetUID =  cs.nAssetUID
	AND t.tMaintDate = cs.tMaintDate
	LEFT JOIN Facilities f ON a.nManufacturerUID = f.nFacilityUID
	ORDER BY t.nOrdinal ''
EXECUTE(@sql);
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-4055<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C7FF5DFB-74C0-4B4F-9CA0-40BA1CA016A6' )
	BEGIN
		PRINT 'Adding translation entry: C7FF5DFB-74C0-4B4F-9CA0-40BA1CA016A6'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C7FF5DFB-74C0-4B4F-9CA0-40BA1CA016A6',3244,N'EN',N'INVALID_URL_FILE',N'Invalid URL file. A URL file must have a file path. Non-URL files cannot have a file path, unless a legacy template is specified.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','20210408 15:35:02',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9223F4B1-7C55-4D06-BF3B-1A0A202927C9' )
	BEGIN
		PRINT 'Adding translation entry: 9223F4B1-7C55-4D06-BF3B-1A0A202927C9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9223F4B1-7C55-4D06-BF3B-1A0A202927C9',3244,N'DE',N'INVALID_URL_FILE',N'#DE# Invalid URL file. A URL file must have a file path. Non-URL files cannot have a file path, unless a legacy template is specified.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','20210408 15:35:02',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9DB8D8F1-C611-40D8-B9B1-FCF49A408C05' )
	BEGIN
		PRINT 'Adding translation entry: 9DB8D8F1-C611-40D8-B9B1-FCF49A408C05'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9DB8D8F1-C611-40D8-B9B1-FCF49A408C05',3244,N'RU',N'INVALID_URL_FILE',N'#RU# Invalid URL file. A URL file must have a file path. Non-URL files cannot have a file path, unless a legacy template is specified.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','20210408 15:35:02',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1E1AB09D-6B03-48EC-BE75-F34864128978' )
	BEGIN
		PRINT 'Adding translation entry: 1E1AB09D-6B03-48EC-BE75-F34864128978'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1E1AB09D-6B03-48EC-BE75-F34864128978',3244,N'PT',N'INVALID_URL_FILE',N'#PT# Invalid URL file. A URL file must have a file path. Non-URL files cannot have a file path, unless a legacy template is specified.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','20210408 15:35:02',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C6F46708-6E34-4F3B-98AE-238CA4286EF6' )
	BEGIN
		PRINT 'Adding translation entry: C6F46708-6E34-4F3B-98AE-238CA4286EF6'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C6F46708-6E34-4F3B-98AE-238CA4286EF6',3244,N'ZH',N'INVALID_URL_FILE',N'#ZH# Invalid URL file. A URL file must have a file path. Non-URL files cannot have a file path, unless a legacy template is specified.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','20210408 15:35:02',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2491AE37-1EAF-4629-A60A-E4E9EAF53BD2' )
	BEGIN
		PRINT 'Adding translation entry: 2491AE37-1EAF-4629-A60A-E4E9EAF53BD2'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2491AE37-1EAF-4629-A60A-E4E9EAF53BD2',3244,N'JA',N'INVALID_URL_FILE',N'#JA# Invalid URL file. A URL file must have a file path. Non-URL files cannot have a file path, unless a legacy template is specified.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','20210408 15:35:02',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'FAF7765F-9FD5-4D46-9AB1-A518F8A0E13C' )
	BEGIN
		PRINT 'Adding translation entry: FAF7765F-9FD5-4D46-9AB1-A518F8A0E13C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('FAF7765F-9FD5-4D46-9AB1-A518F8A0E13C',3244,N'FR',N'INVALID_URL_FILE',N'#FR# Invalid URL file. A URL file must have a file path. Non-URL files cannot have a file path, unless a legacy template is specified.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','20210408 15:35:02',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '03879C5E-0910-480B-9736-1B557476CC4E' )
	BEGIN
		PRINT 'Adding translation entry: 03879C5E-0910-480B-9736-1B557476CC4E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('03879C5E-0910-480B-9736-1B557476CC4E',3244,N'ES',N'INVALID_URL_FILE',N'#ES# Invalid URL file. A URL file must have a file path. Non-URL files cannot have a file path, unless a legacy template is specified.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','20210408 15:35:02',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D99587C1-062A-452E-9F76-8A86361A362C' )
	BEGIN
		PRINT 'Adding translation entry: D99587C1-062A-452E-9F76-8A86361A362C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D99587C1-062A-452E-9F76-8A86361A362C',3244,N'IT',N'INVALID_URL_FILE',N'#IT# Invalid URL file. A URL file must have a file path. Non-URL files cannot have a file path, unless a legacy template is specified.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210408 15:35:02','20210408 15:35:02',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>METCON-2268<<--
	INSERT INTO [dbo].[SecurityGroupMembers]([nSecurityGroupMemberUID], [nSecurityGroupUID], [nUserUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
	SELECT NEWID(), 'E319DC4D-C16F-43C7-AA75-97896B9CC8C1', [nUserUID], -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210415 21:38:22.533','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210415 21:38:22.533','20210415 21:38:22.533', NULL, NULL FROM [dbo].[Users] WHERE [nUserUID] NOT IN ('915F9722-3175-4E4D-A571-4A478E8E5172','ABF8F215-1980-4E47-84DA-305699ECF5D5') AND [lDeleted] = 0 AND [lActive] <> 0 AND [nUserUID] NOT IN (SELECT [nUserUID] FROM [dbo].[SecurityGroupMembers] WHERE [nSecurityGroupUID] = 'E319DC4D-C16F-43C7-AA75-97896B9CC8C1')
		
	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	INSERT INTO [dbo].[SecurityGroupMembers]([nSecurityGroupMemberUID], [nSecurityGroupUID], [nUserUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
	SELECT NEWID(), '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', [nUserUID], -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210415 21:38:22.533','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210415 21:38:22.533','20210415 21:38:22.533', NULL, NULL FROM [dbo].[Users] WHERE [nUserUID] NOT IN ('915F9722-3175-4E4D-A571-4A478E8E5172','ABF8F215-1980-4E47-84DA-305699ECF5D5') AND [lDeleted] = 0 AND [lActive] <> 0 AND [nUserUID] NOT IN (SELECT [nUserUID] FROM [dbo].[SecurityGroupMembers] WHERE [nSecurityGroupUID] = '9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC')
		
	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	IF(EXISTS(SELECT * FROM [dbo].[SecurityGroupMembers] WHERE [nSecurityGroupMemberUID] = 'E81B223F-B6B9-4CD7-9B69-A5451EA0D4B4'))
	BEGIN
		DELETE FROM [dbo].[SecurityGroupMembers] WHERE [nSecurityGroupMemberUID] = 'E81B223F-B6B9-4CD7-9B69-A5451EA0D4B4'
		
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF(EXISTS(SELECT * FROM [dbo].[SecurityGroupMembers] WHERE [nUserUID] = '915F9722-3175-4E4D-A571-4A478E8E5172' AND [nSecurityGroupUID] = 'FD8E1F20-3E2F-4C7D-8D24-965F18A5A3E0'))
	BEGIN
		DELETE FROM [dbo].[SecurityGroupMembers] WHERE [nUserUID] = '915F9722-3175-4E4D-A571-4A478E8E5172' AND [nSecurityGroupUID] = 'FD8E1F20-3E2F-4C7D-8D24-965F18A5A3E0'
		
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>METCON-2396<<--
	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '953D5CD3-4B01-423E-BBAF-519B430A051B')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('953D5CD3-4B01-423E-BBAF-519B430A051B', N'MET/CAL', N'Edit Prompt Files', 'Enabled', N'1', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210507 18:36:33.827','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210507 18:36:33.827','20210507 18:36:33.827', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>METCON-2487<<--
	SELECT @sql = N'
	IF EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = ''ACC9A85B-2990-4E2C-AF04-24BABC746EA1'')
	BEGIN	
		IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE [nUCIDataUID] = ''ACC9A85B-2990-4E2C-AF04-24BABC746EA1'' AND [cField] = N''Configure View'' _COLL_)
		BEGIN
			UPDATE
				[dbo].[UCIData]
			SET
				[cField] = N''Configure View''
			WHERE
				[nUCIDataUID] = ''ACC9A85B-2990-4E2C-AF04-24BABC746EA1''
		END
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	-->>MC-3331<<--
	IF OBJECT_ID(N'[dbo].[ConfiguredInstrumentsWip]', 'U') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[ConfiguredInstrumentsWip]'
		DROP TABLE [dbo].[ConfiguredInstrumentsWip]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[ConfiguredInstrumentsWip]', 'U') IS NULL
	BEGIN
		PRINT N'Adding table [dbo].[ConfiguredInstrumentsWip]'

		CREATE TABLE [dbo].[ConfiguredInstrumentsWip](
			[nConfiguredInstrumentsWipUID] [uniqueidentifier] ROWGUIDCOL NOT NULL,
			[cUserUID] [nvarchar](36) NOT NULL,
			[nAssetUID] [uniqueidentifier] NOT NULL,
			[cBarcode] [nvarchar](100) NULL,
			[cInterval] [nvarchar](50) NULL,
			[cIntervalUOM] [nvarchar](50) NULL
		CONSTRAINT [PK_ConfiguredInstrumentsWip] PRIMARY KEY NONCLUSTERED
		(
			[nConfiguredInstrumentsWipUID] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
		) ON [PRIMARY]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetAssetIntervals]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[GetAssetIntervals]'
		DROP PROCEDURE [dbo].[GetAssetIntervals]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetAssetIntervals]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[GetAssetIntervals]'

		EXEC sp_executesql N'
/****************************************************************
	GetAssetIntervals

	Gets the interval and unit pertinent to each asset passed in

	(c) 2021 Fluke Calibration
-----------------------------------------------------------------
	(MM) 05/14/2021    Initial Version
*****************************************************************/

CREATE PROCEDURE [dbo].[GetAssetIntervals]

@assets NVARCHAR(MAX),
@cUserUID NVARCHAR(36)

AS
BEGIN

	DELETE FROM
		[dbo].[ConfiguredInstrumentsWip]
	WHERE
		[cUserUID] = @cUserUID;

	SELECT @assets = REPLACE(@assets, ''||'', '''');
	DECLARE @sql NVARCHAR(MAX);
	SELECT @sql =
	N''INSERT INTO
			[dbo].[ConfiguredInstrumentsWip] ([nConfiguredInstrumentsWipUID], [cUserUID], [nAssetUID], [cBarcode], [cInterval], [cIntervalUOM])
	SELECT
		NEWID(), '''''' + @cUserUID + '''''',
		[nAssetUID],
		[cBarcode],
		[cInterval],
		[cIntervalUOM]
	FROM
		[dbo].[vw_Assets]
	WHERE
		[lActive] <> 0
	AND
		[lDeleted] = 0
	AND
		[cBarcode] IN ('' + @assets + '' )''

	EXECUTE(@sql);

	SELECT
		*
	FROM
		[dbo].[ConfiguredInstrumentsWip]
	WHERE
		[cUserUID] = @cUserUID
	ORDER BY
		[cBarcode];

	RETURN

END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-4227<<--
	EXEC sp_refreshview AuditHistory
	EXEC sp_refreshview AuditHistory2
	EXEC sp_refreshview Ver_8_Config_Vw
	EXEC sp_refreshview Ver_8_Stds_Vw
	EXEC sp_refreshview vw_AlertingEventsCurrentlyDue
	EXEC sp_refreshview vw_AllAssets
	EXEC sp_refreshview vw_AllCallsheets
	EXEC sp_refreshview vw_AllCallsheetStandards
	EXEC sp_refreshview vw_AllParts
	EXEC sp_refreshview vw_AllReadings
	EXEC sp_refreshview vw_Assets
	EXEC sp_refreshview vw_AssetsWithCallSheets
	EXEC sp_refreshview vw_AssetsWithEx
	EXEC sp_refreshview vw_AssetsWithServices
	EXEC sp_refreshview vw_AssetWithOpenCallsheets
	EXEC sp_refreshview vw_AuditDetail
	EXEC sp_refreshview vw_BillingReport
	EXEC sp_refreshview vw_CallSheetLog
	EXEC sp_refreshview vw_CallSheetReadings
	EXEC sp_refreshview vw_CallSheetResultEx
	EXEC sp_refreshview vw_CallSheets
	EXEC sp_refreshview vw_CallSheetsWithAttCheck
	EXEC sp_refreshview vw_ConfigTableColumns
	EXEC sp_refreshview vw_DataToolConflictWIP
	EXEC sp_refreshview vw_DataToolDelWIP
	EXEC sp_refreshview vw_DataToolDupsWIP
	EXEC sp_refreshview vw_DataToolDupsWIPCounts
	EXEC sp_refreshview vw_DataToolDupsWIPLabels
	EXEC sp_refreshview vw_EMXAuditDetail
	EXEC sp_refreshview vw_EMXAuditHeader
	EXEC sp_refreshview vw_EstimateItems
	EXEC sp_refreshview vw_Estimates
	EXEC sp_refreshview vw_Facilities
	EXEC sp_refreshview vw_FileMd5
	EXEC sp_refreshview vw_Inventory_w_CS_IntervalsReport
	EXEC sp_refreshview vw_JobNumberFacilities
	EXEC sp_refreshview vw_JobNumbers
	EXEC sp_refreshview vw_LabMetricsTimeSpent
	EXEC sp_refreshview vw_LabMetricsTurnTimes
	EXEC sp_refreshview vw_LabMetricsTurnTimesWithBreakdown
	EXEC sp_refreshview vw_ManualTemplateInfo
	EXEC sp_refreshview vw_METCAL_DataPoints
	EXEC sp_refreshview vw_METCONNECT_RESULTS
	EXEC sp_refreshview vw_OpenCallSheets
	EXEC sp_refreshview vw_PackageHistory
	EXEC sp_refreshview vw_Parts
	EXEC sp_refreshview vw_PointExNumerics
	EXEC sp_refreshview vw_PointReadings
	EXEC sp_refreshview vw_Points
	EXEC sp_refreshview vw_PointStatistics
	EXEC sp_refreshview vw_PointTolerances
	EXEC sp_refreshview vw_PointUncertainties
	EXEC sp_refreshview vw_ProblemReports
	EXEC sp_refreshview vw_ProblemReportsWithEx
	EXEC sp_refreshview vw_Procedures
	EXEC sp_refreshview vw_ProcedureStandards
	EXEC sp_refreshview vw_ServiceTypes1
	EXEC sp_refreshview vw_ShipmentItems
	EXEC sp_refreshview vw_Shipments
	EXEC sp_refreshview vw_ToolAssignments
	EXEC sp_refreshview vw_Types
	EXEC sp_refreshview vw_UnbilledLabor
	EXEC sp_refreshview vw_WorkOrdersWithEx


	PRINT N'Updating database version'
	INSERT INTO [dbo].[Version] (
		[nVersionUID]
		,[cVersion]
		,[tInstallDate]
		,[mNote]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
	  )
	  VALUES
	  (
		'5E750356-7DBF-47CE-BF02-1FE831F73383'
		,'3.4.0'
		,'20210520 20:37:57.427'
		,'3.4.0 Release'
		,-1
		,0
		,0
		,0
		,'DBA97ADF-F868-459D-8343-DE1DF0FFB398'
		,'915F9722-3175-4E4D-A571-4A478E8E5172'
		,'20210520 20:37:57.427'
		,'DBA97ADF-F868-459D-8343-DE1DF0FFB398'
		,'915F9722-3175-4E4D-A571-4A478E8E5172'
		,'20210520 20:37:57.427'
		,'20210520 20:37:57.427'
		,NULL
	  )

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	-- Make sure previous version records are inactive
	UPDATE [dbo].[Version] SET lActive = 0, tUpdateTime = '20210520 20:37:57.427', tMobileTime = '20210520 20:37:57.427' WHERE lActive <> 0 AND nVersionUID <> '5E750356-7DBF-47CE-BF02-1FE831F73383'

	IF EXISTS (SELECT * FROM #tmpErrors) ROLLBACK TRANSACTION

	IF @@TRANCOUNT>0 BEGIN
	PRINT 'The database update succeeded'
	COMMIT TRANSACTION
	END
	ELSE PRINT 'The database update failed'

	DROP TABLE #tmpErrors
END
ELSE
	Print N'The database is up-to-date, version 3.4.0'
GO
